var webim;
$(function () {
    try {
        $.getScript(WebIMServer + "/static/js/WebIM.js", function () {
            $.post(WebIMServer + "/login", {loginCode: "admin", loginPassword: "admin_BT2020"}, function (result) {
                if (result.success) {
                    var sessionid = result.data;
                    webim = new WebIM({
                        token: sessionid
                    });
                } else {
                    console.log("登陆失败" + result.msg);
                }
            })
        })
    } catch (e) {
        console.log("WebIM初始化出错,可能是远程WebIM.js未加载");
        console.log(e);
    }

    initOrgtree();
    initGrid();
});
var isLoad = false;//是否加载过grid
//初始话用户grid
function initGrid() {
    $('#basemp_datagrid').datagrid({
       // fit: true,
        singleSelect: true,
        rownumbers: true,
        fitColumns: true,
        pagination: true,
        url: ctx + '/basemp/pageall',
        toolbar: '#tb',
		cls:'md',
		height:$("body").height()-160,
        columns: [[
//					{
//						field:'opt',title:'明细',width:40,align:'center',
//						formatter:function(value,rowData,index){	//value表示字段的值,rowData行记录数据,index行索引
//							return '<div onclick="showDetail(\''+rowData.EMP_ID+'\')" class="icon-detail iconfont blue">&nbsp;</div>';
//					}},
            {field: 'EMP_ID', title: 'EmpId', width: 100, hidden: true},
            {field: 'EMP_CODE', title: '员工编码', width: 100},
            {field: 'EMP_NAME', title: '员工名称', width: 100},
            {field: 'LOGIN_NAME', title: '登陆名称', width: 100},
            {field: 'ORG_NAME', title: '组织名称', width: 100},
            {field: 'DEPT_NAME', title: '部门名称', width: 100},
            {field: 'PRESENT_JOB_TEXT_', title: '岗位', width: 100},
            {field: 'SEX_TEXT_', title: '性别',align:'center',halign:'center',width: 40},
            {field: 'IS_APP_TEXT_', title: '手机端',align:'center',halign:'center', width: 50},
//			          {field:'BIRTHDAY',title:'出生日期',width:80},
//			          {field:'EMAIL',title:'电子邮箱',width:100},
//			          {field:'STATUS_TEXT_',title:'在职状态',width:60},
//			          {field:'LOCK_COUNT',title:'错误次数',align:'center',width:60,styler: function(value,row,index){
//								if (value){
//									return 'color:red;';
//								}
//						}},
            {
                field: 'LOCKTIME', title: '解冻截止时间', width: 100, styler: function (value, row, index) {
                    if (value) {
                        return 'color:red;';
                    }
                }
            }
//			          {field:'DISPLAY_NO',title:'排序',width:100,hidden:true}
        ]]
    });
    $('#basemp_datagrid').datagrid('doCellTip');
    var pager = $('#basemp_datagrid').datagrid('getPager');    // 得到datagrid的pager对象
    pager.pagination({
        buttons: [{
            iconCls: 'icon-page_excel',
            handler: function () {
                exportExcel('basemp_datagrid', "用户信息");
            }
        }]
    });
}

//重新加载数据
function reloadGrid(orgid, deptid) {
    $('#basemp_datagrid').datagrid('reload', {
        orgid: orgid,
        deptid: deptid,
        search: $("#doSearch").val()
    });
}

//初始化组织机构tree
function initOrgtree() {
    $('#basemp_orgdepttree').tree({
        url: ctx + '/basorg/queryOrgAndDeptTree',
        onLoadSuccess: function (node, data) {
            // 默认显示根节点信息
            var root = $(this).tree('getRoot');
            if (node) {
                $(this).tree('select', node.target);
            } else {
                $(this).tree('collapseAll');
                $(this).tree('expand', root.target);
                $(this).tree('select', root.target);
            }
        },
        onSelect: function (node) {
            reloadGrid(node.attributes.org_id, node.attributes.dept_id);
        }
    });
}

function doSearch() {
    var node = $('#basemp_orgdepttree').tree('getSelected');
    reloadGrid(node.attributes.org_id, node.attributes.dept_id);
}

function unlock() {
    var row = $('#basemp_datagrid').datagrid('getSelected');
    if (row) {
        alertConfirm('确定解冻该用户的登陆限制?', function (r) {
            if (r) {
                $.ajax({
                    type: 'post',
                    dataType: 'json',
                    url: ctx + "/basemp/unlock?empId=" + row.EMP_ID,
                    success: function (result) {
                        if (result.success) {
                            $('#basemp_datagrid').datagrid('reload');
                            alertInfo(result.msg);
                        } else {
                            alertError(result.msg);
                        }
                    }
                });
            }
        });
    } else {
        alertInfo('请选择一条记录进行操作');
    }

}


function resetPassword() {
    var row = $('#basemp_datagrid').datagrid('getSelected');
    if (row) {
        alertConfirm('重置操作会将密码重置为默认密码,是否确定?', function (r) {
            if (r) {
                $.ajax({
                    type: 'post',
                    dataType: 'json',
                    url: ctx + "/basemp/resetPassword?empId=" + row.EMP_ID,
                    success: function (result) {
                        if (result.success) {
                            alertInfo(result.msg);
                        } else {
                            alertError(result.msg);
                        }
                    }, error: function () {
                        alertError("请求失败!");
                    }
                });
            }
        });
    } else {
        alertInfo('请选择一条记录进行操作');
    }
}

//绑定ca证书
function bindCa() {
    var row = $('#basemp_datagrid').datagrid('getSelected');
    if (row) {
        layer.prompt({
            formType: 1,
            value: '123456',
            title: '请输入UKey的PIN码,默认123456'
        }, function (value, index, elem) {
            if (value == null) {
                value = '123456';
            }
            layer.close(index);
            CMSSign.ClearPasswd();
            //初始化 并验证用户密码
            var bRet = CMSSign.SetPasswd("P11", value, 2);
            if (!bRet) {
                //获取最后一次错误信息
                alertWarn(CMSSign.GetLastErrorInfo(0));
                return false;
            }
            var certInfo = CMSSign.GetCertEx(2);
            bRet = CMSSign.Sign("testdata");
            if (!bRet) {
                alertWarn('签名失败!');
                return false;
            }
            var signDate = CMSSign.SignedData;
            alertConfirm('确定将该证书与用户绑定?', function (r) {
                if (r) {
                    $.ajax({
                        type: 'post',
                        dataType: 'json',
                        url: ctx + "/basemp/bindCa",
                        data: {
                            strCert: certInfo,
                            strSignData: signDate,
                            empId: row.EMP_ID
                        },
                        success: function (result) {
                            if (result.success) {
                                $('#basemp_datagrid').datagrid('reload');
                                alertInfo(result.msg);
                            } else {
                                alertError(result.msg);
                            }
                        }
                    });
                }
            });
        });
    } else {
        alertInfo('请选择一条记录进行操作');
    }

}

//刷新grid
function refreshGride() {
    $('#basemp_datagrid').datagrid('reload');
}

//点击新增加载数据方法
function addLoad() {
    var node = $('#basemp_orgdepttree').tree('getSelected');
    $('#orgId').val(node.attributes.org_id);
    $('#deptId').val(node.attributes.dept_id);
    $("#documentid").val(generateUUID())
}

//添加用户
function addEmp() {
    openSaveDialog({
        title: "添加用户",
        width: 650,
        height: 400,
        contenturl: "/view/base/basempform",
        submiturl: "/basemp/saveemp",
        callback: refreshGride,
        onload: addLoad
    });
}

//修改用户
function editEmp() {
    var row = $('#basemp_datagrid').datagrid('getSelected');
    if (row) {
        openSaveDialog({
            title: "修改用户",
            width: 650,
            height: 400,
            contenturl: "/view/base/basempform",
            submiturl: "/basemp/saveemp",
            onload: formOnLoad,
            callback: refreshGride
        });
    } else {
        alertInfo('请先选择一条记录再进行修改');
    }
}

function formOnLoad() {
    var row = $('#basemp_datagrid').datagrid('getSelected');
    if (row) {
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: ctx + "/basemp/queryEmpById?empId=" + row.EMP_ID,
            success: function (data) {
                var submitform = $("#empManage_form");
                submitform.form('load', data);
            }
        });
    }
}

//删除用户
function delEmp() {
    var row = $('#basemp_datagrid').datagrid('getSelected');
    if (row) {
        alertConfirm('删除操作会删除该用户及其权限组,是否确定?', function (r) {
            if (r) {
                $.ajax({
                    type: 'post',
                    dataType: 'json',
                    url: ctx + "/basemp/delemp?empId=" + row.EMP_ID,
                    success: function (result) {
                        if (result.success) {
                            alertInfo(result.msg);
                            $('#basemp_datagrid').datagrid('reload');
                        } else {
                            alertError(result.msg);
                        }
                    }
                });
            }
        });
    } else {
        alertInfo('请先选择一条记录再进行删除');
    }
}

function saveUser() {
    var url = ctx + "/basemp/saveemp.action";
    $('#empManage_form').form('submit', {
        url: url,
        dataType: 'json',
        onSubmit: function () {
            return $(this).form('validate');
        },
        success: function (data) {
            alertInfo("操作成功！");
            $('#empManage_window').window('close');
            $('#basemp_datagrid').datagrid('reload');
        },
        error: function (result) {
            alertError("失败！");
        }
    });
}


//用户帐套按钮
function showAccount() {
    var row = $('#basemp_datagrid').datagrid('getSelected');
    var index;
    if (row) {
        index = $('#basemp_datagrid').datagrid('getRowIndex', row);
        $('<div/>').dialog({
            href: ctx + '/view/base/basempAccount',
            width: 550,
            height: 400,
            modal: true,
            title: '用户帐套',
            onClose: function () {
                $(this).dialog('destroy');
            },
            onLoad: function () {
                initAccounGrid(row["EMP_ID"]);
            }
        });
    } else {
        alertInfo('请先选择一条记录');
    }
}

//点击进入明细的界面
function showDetail(empid) {
    openDetailDialog({
        title: "用户详情",
        width: 650,
        height: 400,
        contenturl: "/basemp/basempdetail?id=" + empid
    });
}

function detailOnLoad(params) {
    var row = $('#basemp_datagrid').datagrid('getSelected');
    $.ajax({
        type: 'post',
        dataType: 'json',
        url: ctx + "/sysemp/queryEmpById.action?empId=" + row["EMP_ID"],
        success: function (result) {
            $('#empManageDetail_form').form('LoadLabel', result);
            formatterDetailForm(dicresult);
        },
        error: function () {
            alertInfo("数据请求失败");
        }
    });
}

function initDD() {
    var loadIndex = layer.msg('数据同步中...', {
        icon: 16,
        shade: 0.3, time: 0
    });
    $.ajax({
        type: 'post',
        dataType: 'json',
        url: ctx + "/app/userddsyn",
        success: function (result) {
            layer.close(loadIndex);
            alertInfo(result.msg);
        },
        error: function () {
            layer.close(loadIndex);
            alertInfo("数据同步出错");
        }
    });
}

function visualChange() {
    var isVisual = $("#isVisual").combobox("getValue");
    if (isVisual == 'Y') {
        setCss($("#contactOrgId_TEXT_"), "textbox", false, false, true, false);
    } else {
        setCss($("#contactOrgId_TEXT_"), "textbox", false, true, false, true, true);
    }
}


function initWebChatUsers() {
    if (webim) {
        var loadIndex = layer.msg('数据同步中...', {
            icon: 16,
            shade: 0.3, time: 0
        });
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: ctx + "/basemp/getAllWebChatUser",
            success: function (result) {
                webim.initUsers(result, function (data) {
                    layer.close(loadIndex);
                    if (data.success) {
                        alertInfo(data.msg);
                    } else {
                        alertInfo(data.msg);
                    }
                });

            },
            error: function () {
                layer.close(loadIndex);
                alertInfo("数据同步出错");
            }
        });
    } else {
        console.log("WebIM未能初始化");
        alertError("WebIM未能初始化");
    }

}



function initERP() {
	    
        var loadIndex = layer.msg('数据同步中...', {
            icon: 16,
            shade: 0.3, time: 0
        });
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: ctx + "/basemp/initERP",
            success: function (result) {
                layer.close(loadIndex);
                alertInfo(result.msg);
            },
            error: function () {
                layer.close(loadIndex);
                alertInfo("数据同步出错");
            }
        });

}

function setApp() {
	var row = $('#basemp_datagrid').datagrid('getSelected');
	var isApp = 'Y';
	if(row.IS_APP=='Y'){
		alertConfirmYes('是否取消该用户手机端权限？', function(r) {
			if (r) {
				isApp = 'N';
				setIsApp(row.EMP_ID,isApp)
			}
		});
	}else{
		setIsApp(row.EMP_ID,isApp)
	}
	
}

function setIsApp(empId,isApp){
	 $.ajax({
	        type: 'post',
	        dataType: 'json',
	        url: ctx + "/basemp/setApp",
	        data : {
	        	empId : empId,
	        	isApp : isApp
			},
	        success: function (result) {
	        	doSearch();
	            alertInfo(result.msg);
	        },
	        error: function () {
	            alertInfo("设置手机端出错");
	        }
	    });
}