var dictype = basegrid.datagrid("getSelected");
$(function(){
	initGrid();
});
function initGrid(){
	$('#dic_datagrid').datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
			typeId:dictype.id
		},
		toolbar:"#dic_datagrid_tb",
	    url:ctx+'/dic/getalltype',
	    columns:[[
	        {field:'dicId',title:'id',checkbox:true},
//	        {field:'DIC_NAME',title:'字典名称',width:80},
//	        {field:'DIC_CODE',title:'字典编码',width:80},
	        {field:'dicText',title:'文字',width:120},
	        {field:'dicValue',title:'值',width:120},
	        {field:'isDefault',title:'默认',align:"center",width:40,formatter:function(value,row,index){
	        	return value==1?"<a class='icon-ok'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</a>":"";
	        }},
	        {field:'enableName',title:'字典状态',align:"center",width:70},
	        {field:'displayNo',title:'顺序',width:40},
//	        {field:'usenum',title:'引用次数',width:60},
	        {field:'memo',title:'备注',width:80}
	    ]]
	});
	$('#dic_datagrid').datagrid('doCellTip');
	var pager = $('#dic_datagrid').datagrid('getPager');    // 得到datagrid的pager对象  
	pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('dic_datagrid',"字典信息");   
	        }    
	    }]   
	}); 
}

function reloadGrid(){
	$('#dic_datagrid').datagrid('reload',{
		typeId:dictype.id
	});
}

function doSearch(){
	$('#dic_datagrid').datagrid('load',{
		search:$("#searchbox").val(),
		typeId:dictype.id
	});
}

//增加数据字典
function dic_appendFun() {
	if(!dictype){
		alertInfo("请先选择左侧字典类型");
	}
	openSaveDialog({
		title:"添加数据字典",
		height:350,
		width:660,
		contenturl:"/view/base/basdicform",
		submiturl:"/dic/saveDic",
		callback:reloadGrid,
		onload:function(){
			$("#dicName").textbox("setValue",dictype.dicName);
			$("#dicCode").textbox("setValue",dictype.dicCode);
			$("#typeId").val(dictype.id);
			$("#dicType").val(dictype.dicType);
		}
	});
}

function dic_appendFunValue() {
	var row = $('#dic_datagrid').datagrid('getSelections');
	if (row.length ==1) {
		var dicName = row[0].dicName;
		var dicCode = row[0].dicCode;
		var memo = row[0].memo;
		var dicType= row[0].dicType;
		openSaveDialog({
		title:"添加数据字典",
		height:350,
		width:660,
		contenturl:"/view/base/basdicform",
		submiturl:"/dic/saveDic",
		callback:reloadGrid,
		onload:function(){
			$("#dicName").textbox("setValue",dicName);
			$("#dicCode").textbox("setValue",dicCode);
			$("#memo").textbox("setValue",memo);
			$("#dicType").textbox("setValue",dicType);
		}
	});
	
	}else {
		alertInfo('请选择一条记录');
	}
}


//修改数据字典
function dic_editFun() {
	var row = $('#dic_datagrid').datagrid('getSelections');
	if (row.length ==1) {
		var dicId = row[0].dicId;
		var index = $('#dic_datagrid').datagrid('getRowIndex', row[0]);
		openSaveDialog({
			title : "修改数据字典",
			height:350,
			width:600,
			contenturl : "/view/base/basdicform",
			submiturl : "/dic/saveDic",
			onload : "/dic/findDic?dicId=" + dicId,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除数据字典
function dic_removeFun() {
	var rows = $('#dic_datagrid').datagrid('getChecked');
	var dicids = [];
	if (rows.length > 0) {
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				for ( var i = 0; i < rows.length; i++) {
					/*if(rows[i].dicType =='S'){
							alertInfo('系统字典，禁止删除！');
							return;
						}else if(rows[i].usenum >0){
							alertInfo('字典被引用，禁止删除！');
							return;
						}*/
					dicids.push(rows[i].dicId);
				}
				$.ajax({
					url : ctx+"/dic/delDic",
					data : {
						dicids : dicids.join(',')
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							$('#dic_datagrid').datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据字典信息');
	}
}
//上移
function moveupGenPanelItem() {
	var selections = $('#dic_datagrid').datagrid('getSelections');
	if (! selections.length) {
		alertInfo('请先选择要移动的项目属性');
		return;
	}
	// 多行移动(上移)
	for(var i = 0; i < selections.length; i++){
		var index = $('#dic_datagrid').datagrid('getRowIndex',selections[i]);
        if(index <= 0){
        	return;
        }
        // 当前行
		var toup = selections[i];
		// 当前行的上一行,即移往的行
		var todown = $('#dic_datagrid').datagrid('getData').rows[index - 1];
		$('#dic_datagrid').datagrid('getData').rows[index] = todown;
		$('#dic_datagrid').datagrid('getData').rows[index - 1] = toup;
		$('#dic_datagrid').datagrid('refreshRow', index);
		$('#dic_datagrid').datagrid('refreshRow', index - 1);
		// 支持多选,因此要先取消选中之前的选中行
		$('#dic_datagrid').datagrid('unselectRow', index );
		$('#dic_datagrid').datagrid('selectRow', index - 1);
    }
}

// 下移
function movedownGenPanelItem() {
	var selections = $('#dic_datagrid').datagrid('getSelections');
	if (! selections.length) {
		alertInfo('请先选择要移动的项目属性');
		return;
	}
	// 多行移动(下移)
	var length = $('#dic_datagrid').datagrid("getRows").length;
	for(var i = 0; i < selections.length; i++){
		// 从最下面的选中列判断
		var $i = selections.length-1-i;
        var index = $('#dic_datagrid').datagrid('getRowIndex',selections[$i]);
        if(index >= length-1){
        	return;
        }
        // 当前行
		var todown = selections[$i];
		// 当前行的下一行,即移往的行
		var toup = $('#dic_datagrid').datagrid('getData').rows[index + 1];
		$('#dic_datagrid').datagrid('getData').rows[index + 1] = todown;
		$('#dic_datagrid').datagrid('getData').rows[index] = toup;
		$('#dic_datagrid').datagrid('refreshRow', index);
		$('#dic_datagrid').datagrid('refreshRow', index + 1);
		// 支持多选,因此要先取消选中之前的选中行
		$('#dic_datagrid').datagrid('unselectRow', index );
		$('#dic_datagrid').datagrid('selectRow', index + 1);
    }
}

function saveDisplayNo() {
	$('#save_GenPanelItem').linkbutton('disable');
	// 已分配里程碑节点列表grid信息
	var rows = $('#dic_datagrid').datagrid('getRows');
	if(! rows.length){
		$('#save_GenPanelItem').linkbutton('enable');
		return;
	}
	var effectRow = new Object();
	effectRow["data"] = JSON.stringify(rows);

	var saveUrl = ctx + "/dic/savePanelItemDisplayNo";
	// 所有datagrid的数据均传入后台
	// 后台根据index进行排序并保存
	$.post(saveUrl, effectRow, function(result) {
		alertInfo('保存排序成功');
		$('#dic_datagrid').datagrid('reload');
		// 启用按钮
		$('#save_GenPanelItem').linkbutton('enable');
	}, "JSON").error(function() {
		alertError('保存排序失败，请重试');
		// 启用按钮
		$('#save_GenPanelItem').linkbutton('enable');
	});
}