var basegrid=$('#GcMealsCost_datagrid');
$(function(){
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#GcMealsCost_datagrid_tb",
	    url:ctx+'/GcMealsCost/pageGcMealsCost',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="openFormDetail('+row.ID+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'ID',title:'id',width:100,align:'center',halign:'center'},
	    {field:'MEONEY',title:'meoney',width:100,align:'center',halign:'center'},
	    {field:'PARTICIPANTS',title:'人员',width:100,align:'center',halign:'center'},
	    {field:'DIRECTION',title:'方向1,-1',width:100,align:'center',halign:'center'},
	    {field:'BIZ_DATE',title:'bizDate',width:100,align:'center',halign:'center'},
	    {field:'CREATE_BY',title:'创建人',width:100,align:'center',halign:'center'},
	    {field:'CREATE_TIME',title:'创建时间',width:100,align:'center',halign:'center'},
	    {field:'MODIFY_ACCOUNT',title:'修改人',width:100,align:'center',halign:'center'},
	    {field:'MODIFY_TIME',title:'修改时间',width:100,align:'center',halign:'center'},
	    {field:'IS_USE',title:'状态',width:100,align:'center',halign:'center'},
	    {field:'REMARK',title:'备注',width:100,align:'center',halign:'center'}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			openFormDetail(row.ID);
	    }
	});
    basegrid.datagrid('doCellTip');
    var pager = basegrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('GcMealsCost_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function openFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=GcMealsCost_Form&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchGcMealsCost(){
	basegrid.datagrid('load',{
		search:$("#searchGcMealsCost").val()
	});
}

//增加记录
function addGcMealsCost() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=GcMealsCost_Form",
		submiturl:"/GcMealsCost/saveGcMealsCost?formcode=GcMealsCost_Form",
//		contenturl:"/view/base/GcMealsCost_Form",
//		submiturl:"/GcMealsCost/saveGcMealsCost",
		callback:reloadGrid
	});
	
}

//修改记录
function editGcMealsCost() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.ID;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=GcMealsCost_Form&id=" + id,
			submiturl:"/GcMealsCost/saveGcMealsCost?formcode=GcMealsCost_Form",
//			contenturl : "/view/base/GcMealsCost_Form",
//			submiturl : "/GcMealsCost/saveGcMealsCost",
//			onload : "/GcMealsCost/findGcMealsCost?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delGcMealsCost() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.ID;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/GcMealsCost/delGcMealsCost",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
