var basegrid=$('#BasUserFeedback_datagrid');
$(function(){
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#BasUserFeedback_datagrid_tb",
	    url:ctx+'/BasUserFeedback/pageBasUserFeedback',
	    columns:[[
	    {field:'USER_FEEDBACK_ID',title:'主键',hidden:true},
	    {field:'TOPIC_NAME',title:'标题名称',width:100,align:'left',halign:'center'},
	    {field:'ACCOUNT_NAME',title:'反馈人员',width:50,align:'center',halign:'center'},
	    {field:'BROWSER_VERSION',title:'浏览器版本',width:150,align:'center',halign:'center'},
	    {field:'CONTACTS_WAY',title:'网络方式',width:60,align:'center',halign:'center',formatter:function(value){
	    	if(value==1){
	    		return '局域网访问';
	    	}else if(value==2){
	    		return '互联网访问';
	    	}else{
	    		return '';
	    	}
	    }},
	    {field:'FEEDBACK_DATE',title:'反馈时间',width:100,align:'center',halign:'center'},
	    {
			field:'FEEDBACK_OPINION',title:'内容',width:40,align:'center',
			formatter:function(value,rowData,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="showDetail(\''+value+'\')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'CONTACT_WAY',title:'联系方式',width:100,align:'center',halign:'center'},
	    {field:'PROCESS_STATUS',title:'处理状态',width:100,align:'center',halign:'center',formatter:function(value){
	    	if(value==1){
	    		return '<font color="red">未处理</font>';
	    	}else if(value==2){
	    		return '<font color="blue">处理中</font>';
	    	}else if(value==3){
	    		return '<font color="green">已处理</font>';
	    	}else{
	    		return '';
	    	}
	    }},
	    {field:'PROCESS_MAN_NAME',title:'处理人',width:50,align:'center',halign:'center'},
	    {field:'PROCESS_DATE',title:'处理时间',width:100,align:'center',halign:'center'},
	    {
			field:'PROCESS_RESULT',title:'处理结果',width:60,align:'center',
			formatter:function(value,rowData,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="showDetail(\''+value+'\')" class="icon-detail iconfont blue">&nbsp;</div>';
		}}
	    ]],
	    onDblClickRow : editBasUserFeedback
	});
	var pager = basegrid.datagrid('getPager');    // 得到datagrid的pager对象  
	pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('BasUserFeedback_datagrid',"用户反馈处理信息");   
	        }    
	    }]   
	}); 
}
//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchBasUserFeedback(){
	basegrid.datagrid('load',{
		search:$("#searchBasUserFeedback").val()
	});
}


//修改记录
function editBasUserFeedback() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.USER_FEEDBACK_ID;
		openSaveDialog({
			title : "用户反馈处理",
			contenturl : "/view/base/BasUserFeedbackform",
			submiturl : "/BasUserFeedback/saveDealBasUserFeedback",
			onload : "/BasUserFeedback/findBasUserFeedback?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}
function showDetail(contentstr){
	if(!contentstr||contentstr=='null'){
		contentstr='';
	}
	$('#BasUserFeedback_dialog').dialog({   
		content:contentstr
	}); 
	$('#BasUserFeedback_dialog').dialog('open'); 
}
