var BasTimedTaskDataGrid=$('#BasTimedTask_datagrid');
$(function(){
	initBasTimedTaskGrid();
});

function initBasTimedTaskGrid(){
	BasTimedTaskDataGrid.datagrid({
		height:$("body").height()-172,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
			startDate:$('#sDate').datebox('getValue'),
			endDate:$('#eDate').datebox('getValue')
		},
		cls:'md',
		toolbar:"#BasTimedTask_datagrid_tb",
	    url:ctx+'/BasTimedTask/pageBasTimedTask',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="BasTimedTaskFormDetail('+row.taskId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'className',title:'类名',width:120,align:'center',halign:'center',sortable:true},
		{field:'taskName',title:'任务名称',width:120,align:'center',halign:'center',sortable:true},
		{field:'taskCode',title:'任务编码',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'isUse',title:'是否删除',width:100,align:'center',halign:'center',sortable:true},
	    {field:'methodName',title:'方法名',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'modifyAccount',title:'修改人',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'modifyTime',title:'修改时间',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'remark',title:'备注',width:100,align:'center',halign:'center',sortable:true},
	    {field:'taskAbleText',title:'是否启用',width:80,align:'center',halign:'center',sortable:true},
	    // {field:'taskCode',title:'定时任务编码',width:100,align:'center',halign:'center',sortable:true},
			// {field:'taskId',title:'',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'taskInstruction',title:'任务说明',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'taskName',title:'定时任务名称',width:100,align:'center',halign:'center',sortable:true},
	    {field:'timingExpression',title:'定时表达式',width:100,align:'center',halign:'center',sortable:true},
	    {field:'createAccount',title:'创建人',width:100,align:'center',halign:'center',sortable:true},
	    {field:'createTime',title:'创建时间',width:80,align:'center',halign:'center',sortable:true},
		{field:'oper',title:'操作',width:100,align:'center',halign:'center',formatter:formatter}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			BasTimedTaskFormDetail(row.taskId);
	    }
	});
    BasTimedTaskDataGrid.datagrid('doCellTip');
    var pager = BasTimedTaskDataGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('BasTimedTask_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function BasTimedTaskFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasTimedTask&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadBasTimedTask(){
	BasTimedTaskDataGrid.datagrid('reload');
}
//查询表格
function searchBasTimedTask(){
	BasTimedTaskDataGrid.datagrid('load',{
		search:$("#searchBasTimedTask").val(),
		startDate:$('#sDate').datebox('getValue'),
		endDate:$('#eDate').datebox('getValue'),
		// applyPerson: $("#applyPerson").textbox('getValue'),
		// applyDept :$("#applyDept").combobox('getValue'),
		isAbleOrNo:$("#enable").combo('getValue')
	});
}

//增加记录
function addBasTimedTask() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasTimedTask",
		submiturl:"/BasTimedTask/saveBasTimedTask?formcode=BasTimedTask",
//		contenturl:"/view/base/BasTimedTask",
//		submiturl:"/BasTimedTask/saveBasTimedTask",
		callback:reloadBasTimedTask
	});
	
}

//修改记录
function editBasTimedTask() {
	var row = BasTimedTaskDataGrid.datagrid('getSelected');
	if (row) {
		var id = row.taskId;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=BasTimedTask&id=" + id,
			submiturl:"/BasTimedTask/saveBasTimedTask?formcode=BasTimedTask",
//			contenturl : "/view/base/BasTimedTask",
//			submiturl : "/BasTimedTask/saveBasTimedTask",
//			onload : "/BasTimedTask/findBasTimedTask?id=" + id,
			callback : reloadBasTimedTask
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delBasTimedTask() {
	var row = BasTimedTaskDataGrid.datagrid('getSelected');
	if (row) {
	var id =row.taskId;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasTimedTask/delBasTimedTask",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							BasTimedTaskDataGrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}

function formatter(value,row,index){
	var str='<div class="easyui-panel">';
	str +='<a href="javascript:void(0);" style="color:#409eff;" onclick="doOnce(\''+row.taskId+'\',\''+row.className+'\',\''+row.methodName+'\')">执行一次&nbsp;&nbsp;</a>';
	if(row.taskAble == "Y"){
		str +='<a href="javascript:void(0);" style="color:#409eff;" onclick="optionUse(\''+row.taskId+'\',\'N\')">禁用</a>';
	}else {
		str +='<a href="javascript:void(0);" style="color:#409eff;" onclick="optionUse(\''+row.taskId+'\',\'Y\')">启用</a>';
	}

	str+='</div>';
	return str;
}

function doOnce(taskId,className,methodName) {
	alertConfirmYes('您是否要立即执行一次当前任务？', function(r) {
		if (r) {
			$.ajax({
				url : ctx+"/BasTimedTask/doOnceBasTimedTask",
				data : {
					id : taskId,
					className : className,
					methodName : methodName
				},
				dataType : 'json',
				success : function(result) {
					if (result.success) {
						BasTimedTaskDataGrid.datagrid('reload');
						alertInfo(result.msg);
					}else{
						alertError(result.msg);
					}
				}
			});
		}
	});
}

function optionUse(taskId,option) {
	alertConfirmYes(option=="Y"?'启用该任务，确定吗？':'禁用该任务，确定吗？', function(r) {
		if (r) {
			$.ajax({
				url : ctx+"/BasTimedTask/optionUseBasTimedTask",
				data : {
					taskId : taskId,
					option : option
				},
				dataType : 'json',
				success : function(result) {
					if (result.success) {
						BasTimedTaskDataGrid.datagrid('reload');
						alertInfo(result.msg);
					}else{
						alertError(result.msg);
					}
				}
			});
		}
	});
}