var basegrid=$('#BasMessage_datagrid');
$(function(){
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		pagination:true,
		fitColumns:true,
		toolbar:"#BasMessage_datagrid_tb",
	    url:ctx+'/BasMessage/pageBasSysMessage',
	    columns:[[
	    {field:'MSG_ID',title:'msgId',hidden:true},
	    {field:'MSG_TITLE',title:'通知内容',width:300,align:'left',halign:'center'},
	    {field:'SENDTIME',title:'生效时间',width:100,align:'center',halign:'center'}
	    ]]
	});

}

function reloadGrid(){
	basegrid.datagrid('reload');
}

function searchBasMessage(){
	basegrid.datagrid('load',{
		search:$("#searchBasMessage").val()
	});
}

//增加数据字典
function addBasMessage() {
	openSaveDialog({
		title:"添加记录",
		contenturl:"/view/base/BasSysMessageform",
		submiturl:"/BasMessage/saveBasSysMessage",
		callback:reloadGrid,
		onload:function(){
			$("#msgTitle").textbox('setValue',"系统将于xxxxxx进行维护升级,预计维护时长xx小时.请您尽快结束手中的工作,以免为您的工作带来影响.")
		}
	});
	
}

//修改数据字典
function editBasMessage() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.MSG_ID;
		openSaveDialog({
			title : "修改记录",
			contenturl : "/view/base/BasSysMessageform",
			submiturl : "/BasMessage/saveBasSysMessage",
			onload : "/BasMessage/findBasMessage?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除数据字典
function delBasMessage() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.MSG_ID;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasMessage/delBasMessage",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据字典信息');
	}
}
