var basetree=$('#BasFundSource_tree');
var basegrid=$('#Orgs_datagrid');
var orgId;
$(function(){
	initGrid();
	initTree();
});

function initTree(){
	basetree.tree({
		checkbox:true,
		url : ctx + "/BasFundSource/treeBasFundSourceAllot"
	});
}

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:false,
	    url:ctx+'/basorg/pageBasOrgSelect',
	    columns:[[
	    {field:'orgId',title:'主键ID',width:100,align:'center',halign:'center',sortable:true,hidden:true},
	    {field:'abbr',title:'组织机构名称',width:100,align:'center',halign:'center',sortable:true}
	    ]],
	    onSelect:function(index,row){
	    	orgId = row.orgId;
	    	loadFundSource();
	    }
	});
    basegrid.datagrid('doCellTip');
    var pager = basegrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('Orgs_datagrid',"title");   
	        }    
	    }]   
	});
}
//重新加载表格
function reloadFundSource(){
	var params = {
			orgid: orgId
		};
	basetree.tree("options").queryParams = params;
	basetree.tree('reload');
}
//重新加载现金流量
function loadFundSource(){
	if(!orgId){
		alertInfo('请先选择一条组织机构信息,再进行模块的关联操作');
		return;
	}
	//角色对应菜单
	basetree.tree({
		checkbox : true,
		url : ctx + "/BasFundSource/treeBasFundSourceAllot?orgid="+orgId,
		onBeforeLoad:function(){
			$(this).tree('options').cascadeCheck=false;
		},
		onLoadSuccess:function(){
			$(this).tree('options').cascadeCheck=true;
			$('#BasFundSource_tree').tree('expandAll');
		}
	});
}
//查询表格
function searchBasSouceAllot(){
	basegrid.datagrid('load',{
		search:$("#searchBasSouceAllot").val()
	});
}


function saveMenu(){
	if(!orgId){
		alertInfo('请先选择一条角色信息,再进行模块的关联操作');
		return;
	}
	var nodes = basetree.tree('getChecked',['checked','indeterminate']);
	var fundSourceIds = [];
	for ( var i = 0; i < nodes.length; i++) {
		if(nodes[i].attributes.nodetype==0){
			fundSourceIds.push(nodes[i].attributes.keyid);
		}
	}
	$('#saveBtn').linkbutton('disable');
	var loadIndex = layer.msg('保存中', {icon: 16,
		  shade :0.3,time:0});
	$.ajax({
		dataType : 'json',
		type : "POST",
		data : {
			orgid : orgId,
			fundSourceIds : fundSourceIds.join(',')
		},
		url : ctx + "/BasSouceAllot/saveBasSouceAllot",
		success : function(result) {
			layer.close(loadIndex);
			if (result.success) {
				alertInfo(result.msg);
			} else {
				alertInfo("操作失败,请重试");
			}
			// 启用按钮
			$('#saveBtn').linkbutton('enable');
			
		},error:function(){
			layer.close(loadIndex);
			$('#saveBtn').linkbutton('enable');
		},
	});
	reloadFundSource();
}