var basetree=$('#BaseOrg_tree');
var commongrid=$('#CommonRoles_datagrid');
var basegrid=$('#BasRoles_datagrid');
var basemenutree=$('#BasMenu_tree');
var baseappmenutree=$('#BasAppMenu_tree');
var choosegrid=$('#choosegrid');
var unchoosegrid=$('#unchoosegrid');
var basemodelgrid=$('#BasRolesModel_datagrid');
var unchoosetree=$('#UnOrg_tree');
var oldchecks;
var roleId;//角色ID
var roleType;//角色类型
var orgId;//角色下组织机构
var deptId;//角色下部门
var unOrgId;//未选人员组织机构
var unDeptId;//未选人员部门
$(function(){
	initTree();
	initUnTree();
	initGrid();
});

function initTree(){
	basetree.combotree({
		editable:false,
		width:280,
		panelHeight:'auto',
		url : ctx + '/basorg/queryOrgAndDeptTree',
		onSelect : function(node) {
			//区分所选是组织机构还是部门
			var rt = 'org';
			if(node.attributes.dtype == '1'){
				rt = 'dept'
			}
			unchoosetree.combotree('setValue',node.id);
            unchoosetree.combotree('setText',node.text);
            basegrid.datagrid('unselectAll');
            //赋值
            orgId = node.attributes.org_id;
            if(node.attributes.dept_id){
            	deptId = node.attributes.dept_id;
            }else{
            	deptId = '';
            }
            unOrgId = orgId;
            unDeptId = deptId;
            //刷新组织角色表、已选人员、未选人员
            reloadCommonGrid();
			reloadGrid(rt);
			reloadChooseGrid();
			reloadUnChooseGrid();
		},
		onLoadSuccess : function(node, data) {
			// 默认显示根节点信息
			var root = $(this).tree('getRoot');
			if(node){
				$(this).tree('select', node.target);
			}else{
				$(this).tree('collapseAll');
				$(this).tree('expand',root.target);
				$(this).tree('select', root.target);
			}
			basetree.combotree('setValue',root.id);
		}
	});
	
	basemenutree.tree({
		checkbox:true,
		url : ctx + '/BasRolesMenu/findRoleMenutree'
	});
	
	baseappmenutree.tree({
		checkbox:true,
		url : ctx + '/BasAppRolesMenu/findAppRolesMenutree'
	});
}

function initUnTree(){
	unchoosetree.combotree({
		editable:false,
		width:220,
		url : ctx + '/basorg/queryOrgAndDeptTree',
		onSelect : function(node) {
			//赋值
            unOrgId = node.attributes.org_id;
            unDeptId = node.attributes.dept_id;
            //刷新未选人员列表
			reloadUnChooseGrid();
		},
		onLoadSuccess : function(node, data) {
			// 默认显示根节点信息
			var root = $(this).tree('getRoot');
			if(node){
				$(this).tree('select', node.target);
			}else{
				$(this).tree('collapseAll');
				$(this).tree('expand',root.target);
				$(this).tree('select', root.target);
			}
			unchoosetree.combotree('setValue',root.id);
		}
	});
	
//	basemenutree.tree({
//		checkbox:true,
//		url : ctx + '/BasRolesMenu/findRoleMenutree'
//	});
}

function initGrid(){
	commongrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
	    url:ctx+'/BasRoles/pageBasRoles?roleType=sys,common',
	    columns:[[
	    {field:'ROLE_ID',title:'角色ID',hidden:true},
	    {field:'ROLE_NAME',title:'角色名称',width:100},
	    {field:'ROLE_TYPE',hidden:true},
	    {field:'ROLE_TYPE_TEXT_',title:'角色类型',width:100}
	    ]],
	    onSelect:function(index,row){
	    	//赋值
	    	roleType = 'sys,common';
	    	roleId = row.ROLE_ID;
	    	deptId = '';
	    	loadEmpAndMenu();
	    }
});
	
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		toolbar:"#BasRoles_datagrid_tb",
		queryParams:{
			roleType:'org',
		},
		pagination:true,
	    url:ctx+'/BasRoles/pageBasRoles',
	    columns:[[
	    {field:'ROLE_ID',title:'角色ID',hidden:true},
	    {field:'ROLE_NAME',title:'角色名称',width:100},
	    {field:'ROLE_TYPE',hidden:true},
	    {field:'ROLE_TYPE_TEXT_',title:'角色类型',width:100}
	    ]],
	    onSelect:function(index,row){
	    	//赋值
	    	roleType = 'org,dept';
	    	roleId = row.ROLE_ID;
	    	loadEmpAndMenu();
	    }
	});
	
	choosegrid.datagrid({
		fit:true,
		border:false,
		rownumbers:true,
		fitColumns:true,
	    url:ctx+'/BasRolesAccount/PageRoleAccountInAndOut',
	    pagination:true,
		toolbar:'#choosegrid_tb',
	    columns:[[
	    {field:'ACCOUNT_ID',title:'角色ID',checkbox:true},
	    {field:'ACCOUNT_NAME',title:'帐套名称',width:100},
	    {field:'EMP_NAME',title:'人员名称',width:100},
	    {field:'DEPT_NAME',title:'部门名称',width:100}
	    ]]
	});
	
	unchoosegrid.datagrid({
		fit:true,
		border:false,
		rownumbers:true,
		fitColumns:true,
	    url:ctx+'/BasRolesAccount/PageRoleAccountInAndOut',
	    pagination:true,
		toolbar:'#unchoosegrid_tb',
	    columns:[[
	    {field:'ACCOUNT_ID',title:'角色ID',checkbox:true},
	    {field:'ACCOUNT_NAME',title:'帐套名称',width:100},
	    {field:'EMP_NAME',title:'人员名称',width:100},
	    {field:'DEPT_NAME',title:'部门名称',width:100}
	    ]]
	});
	
	basemodelgrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#BasRolesModel_datagrid_tb",
	    url:ctx+'/BasRolesModel/pageBasRolesModel',
	    columns:[[
	    {field:'ROLEMODEL_ID',title:'rolemodelId',hidden:true},
	    {field:'ROLE_ID',title:'roleId',hidden:true},
	    {field:'MODEL_ID',title:'modelId',hidden:true},
	    {field:'MODEL_TITLE',title:'模块标题',width:100,align:'left'},
	    {field:'MODEL_TYPE_TEXT_',title:'模块类型',width:100,align:'center',halign:'center'},
	    {field:'MODEL_WIDTH',title:'模块宽度',width:100,align:'center',halign:'center'}
	    ]]
	});
	
}
//角色根据类别过滤
function reloadCommonGrid(){
	commongrid.datagrid('reload',{
//		roleType:roleType
	});
}

function reloadGrid(rt){
	if(!rt){
		rt = roleType;
	}
	basegrid.datagrid('reload',{
		roleType:rt
	});
}

function reloadChooseGrid(){
	choosegrid.datagrid('reload',{
		orgid:orgId,
		deptid:deptId,
		search:$("#search_choosegrid").val()
	});
}




function reloadUnChooseGrid(){
	unchoosegrid.datagrid('reload',{
		inout:false,
		orgid:orgId,
		deptid:deptId,
		unOrgid:unOrgId,
		unDeptid:unDeptId,
		roleid:roleId,
		search:$("#search_unchoosegrid").val()
	});
}




function loadEmpAndMenu(){
	if(!roleId){
		alertInfo('请先选择一条角色信息,再进行模块的关联操作');
		return;
	}
	//角色对应菜单
	basemenutree.tree({
		checkbox : true,
		url : ctx + "/BasRolesMenu/findRoleMenutree?roleid=" + roleId+"&roleType="+roleType+"&orgid="+orgId+"&deptid="+deptId,
		onBeforeLoad:function(){
			$(this).tree('options').cascadeCheck=false;
		},
		onLoadSuccess:function(data){
			$(this).tree('options').cascadeCheck=true;
			$(this).tree('collapseAll');
			oldchecks = basemenutree.tree('getChecked',['checked','indeterminate']);
		}
	});
	baseappmenutree.tree({
		checkbox : true,
		url : ctx + "/BasAppRolesMenu/findAppRolesMenutree?rolesid=" + roleId+"&roleType="+roleType+"&orgid="+orgId+"&deptid="+deptId,
		onBeforeLoad:function(){
			$(this).tree('options').cascadeCheck=false;
		},
		onLoadSuccess:function(){
			$(this).tree('options').cascadeCheck=true;
			$(this).tree('collapseAll');
		}
	});
	//角色对应已选人员
	choosegrid.datagrid('reload',{
		inout:true,
		orgid:orgId,
		deptid:deptId,
		roleid:roleId,
		search:$("#search_choosegrid").val()
	});
	//角色对应未选人员
	unchoosegrid.datagrid('reload',{
		inout:false,
		orgid:unOrgId,
		deptid:unDeptId,
		roleid:roleId,
		search:$("#search_unchoosegrid").val()
	})
	//角色对应首页模块
	basemodelgrid.datagrid('reload',{
		roleid:roleId,
		orgid:orgId,
		deptid:deptId
	})
}




function saveMenu(){
	if(!roleId){
		alertInfo('请先选择一条角色信息,再进行模块的关联操作');
		return;
	}
	var nodes = basemenutree.tree('getChecked',['checked','indeterminate']);
	var menuids = [];
	var buttonids = [];
	var delmenuids = [];
	var delbuttonids = [];
	var addmenuids = [];
	var addbuttonids = [];
	var oldmenuids = [];
	var oldbuttonids = [];
	for ( var i = 0; i < oldchecks.length; i++) {//原先的权限
		if(oldchecks[i].attributes.nodetype==0){
			oldmenuids.push(oldchecks[i].attributes.keyid);
		}else if(oldchecks[i].attributes.nodetype==1){
			oldbuttonids.push(oldchecks[i].attributes.keyid);
		}
	}
	for ( var i = 0; i < nodes.length; i++) {//当前的权限
		if(nodes[i].attributes.nodetype==0){
			menuids.push(nodes[i].attributes.keyid);
		}else if(nodes[i].attributes.nodetype==1){
			buttonids.push(nodes[i].attributes.keyid);
		}
	}
	addmenuids = menuids.filter(function(val){return oldmenuids.indexOf(val)==-1});
	addbuttonids = buttonids.filter(function(val){return oldbuttonids.indexOf(val)==-1});
	
	delmenuids = oldmenuids.filter(function(val){return menuids.indexOf(val)==-1});
	delbuttonids = oldbuttonids.filter(function(val){return buttonids.indexOf(val)==-1});

	$('#saveBtn').linkbutton('disable');
	var loadIndex = layer.msg('保存中', {icon: 16,
		  shade :0.3,time:0});
	$.ajax({
		dataType : 'json',
		type : "POST",
		data : {
			roleid : roleId,
			orgid : orgId,
			deptid : deptId,
			addmenuids : addmenuids.join(','),
			addbuttonids : addbuttonids.join(','),
			delmenuids : delmenuids.join(','),
			delbuttonids : delbuttonids.join(',')
		},
		url : ctx + "/BasRolesMenu/saveBasRolesMenu",
		success : function(result) {
			layer.close(loadIndex);
			if (result.success) {
				alertInfo(result.msg);
			} else {
				alertInfo("操作失败,请重试");
			}
			// 启用按钮
			$('#saveBtn').linkbutton('enable');
		},error:function(){
			layer.close(loadIndex);
			$('#saveBtn').linkbutton('enable');
		}
	});
	
}

/*
 * 手机app保存角色菜单
 */
function saveAppMenu(){
	if(!roleId){
		alertInfo('请先选择一条角色信息,再进行模块的关联操作');
		return;
	}
	var nodes = baseappmenutree.tree('getChecked',['checked','indeterminate']);
	var menuids = [];
	for ( var i = 0; i < nodes.length; i++) {
		if(nodes[i].attributes.nodetype==0){
			menuids.push(nodes[i].attributes.keyid);
		}
	}
	$('#saveAppBtn').linkbutton('disable');
	var loadIndex = layer.msg('保存中', {icon: 16,
		  shade :0.3,time:0});
	$.ajax({
		dataType : 'json',
		type : "POST",
		data : {
			roleid : roleId,
			orgid : orgId,
			deptid : deptId,
			menuids : menuids.join(',')
		},
		url : ctx + "/BasAppRolesMenu/saveBasAppRolesMenu",
		success : function(result) {
			layer.close(loadIndex);
			if (result.success) {
				alertInfo(result.msg);
			} else {
				alertInfo("操作失败,请重试");
			}
			// 启用按钮
			$('#saveAppBtn').linkbutton('enable');
		},error:function(){
			layer.close(loadIndex);
			$('#saveAppBtn').linkbutton('enable');
		}
	});
}

function moveUsers(inout){
var row = basegrid.datagrid('getSelected');
	if(!roleId){
		alertInfo('请先选择一条角色信息,再进行模块的关联操作');
		return;
	}
	var rowData;
	if(inout==true){
		rowData=unchoosegrid.datagrid('getSelections');
	}else{
		rowData=choosegrid.datagrid('getSelections');
	}
	
	if (rowData.length == 0) {
		alertInfo('请选择要移动的数据');
		return;
	}
	var loadIndex = layer.msg('保存中', {icon: 16,
		  shade :0.3,time:0});
	var accountids = [];
	for ( var i = 0; i < rowData.length; i++) {
		accountids.push(rowData[i].ACCOUNT_ID);
	}
	$.ajax({
		cache : false,
		dataType : 'json',
		type : "POST",
		data : {
			inout:inout,
			roleid : roleId,
			orgid:orgId,
			deptid:deptId,
			accountids : accountids.join(',')
		},
		url : ctx + "/BasRolesAccount/moveBasRolesAccount",
		success : function(result) {
			layer.close(loadIndex);
			if (result.success) {
				choosegrid.datagrid('reload');
				unchoosegrid.datagrid('reload');
				alertInfo(result.msg);
			} else {
				alertError(result.msg);
			}
		},error:function(){
			layer.close(loadIndex);
		}
	});
}


function doSearchin(value){
	if(!roleId){
		alertInfo('请先选择一条角色信息,再进行模块的关联操作');
		return;
	}
	choosegrid.datagrid('reload',{
		inout:true,
		orgid:orgId,
		deptid:deptId,
		roleid:roleId,
		search:value
	});
}
function doSearchout(value){
	if(!roleId){
		alertInfo('请先选择一条角色信息,再进行模块的关联操作');
		return;
	}
	unchoosegrid.datagrid('reload',{
		inout:false,
		orgid:unOrgId,
		deptid:unDeptId,
		roleid:roleId,
		search:value
	});

}


//增加数据字典
function addBasRolesModel() {
		if(roleId){
			openChooseDialog({
				width:550,
				height:430,
				title:"添加记录",
				contenturl:"/view/base/chooseBasModel?roleid="+roleId+"&orgid="+orgId+"&deptid="+deptId,
				okhandler:function(){
					var rows=$("#chooseBasModel_datagrid").datagrid('getChecked');
					if(rows.length>0){
						var loadIndex = layer.msg('保存中', {icon: 16,shade :0.3,time:0});
						var modelids = [];
						for ( var i = 0; i < rows.length; i++) {
							modelids.push(rows[i].MODEL_ID);
						}
						$.ajax({
							ansyn:true,
							dataType : 'json',
							type : "POST",
							data : {
								roleid:roleId,
								orgid:orgId,
								deptid:deptId,
								modelids : modelids.join(',')
							},
							url : ctx + "/BasRolesModel/moveInBasRolesModel",
							success : function(result) {
								layer.close(loadIndex);
								if (result.success) {
									basemodelgrid.datagrid('reload');
									alertInfo(result.msg);
								} else {
									alertError(result.msg);
								}
							},error:function(){
								layer.close(loadIndex);
							}
						});
							return true;
					}else{
						alertInfo('请选择要添加的模块');
					}
					
				}
			});
		}else{
			alertInfo('请选择角色');
		}
		
	}

function delBasRolesModel(){
var row = basemodelgrid.datagrid('getSelected');
	if (row) {
	var id =row.ROLEMODEL_ID;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasRolesModel/delBasRolesModel",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basemodelgrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}


//上移
	function moveupRolesModel() {
		var selections = basemodelgrid.datagrid('getSelections');
		if (! selections.length) {
			alertInfo('请先选择要移动的数据');
			return;
		}
		// 多行移动(上移)
		for(var i = 0; i < selections.length; i++){
			var index = basemodelgrid.datagrid('getRowIndex',selections[i]);
	        if(index <= 0){
	        	return;
	        }
	        // 当前行
			var toup = selections[i];
			// 当前行的上一行,即移往的行
			var todown = basemodelgrid.datagrid('getData').rows[index - 1];
			basemodelgrid.datagrid('getData').rows[index] = todown;
			basemodelgrid.datagrid('getData').rows[index - 1] = toup;
			basemodelgrid.datagrid('refreshRow', index);
			basemodelgrid.datagrid('refreshRow', index - 1);
			// 支持多选,因此要先取消选中之前的选中行
			basemodelgrid.datagrid('unselectRow', index );
			basemodelgrid.datagrid('selectRow', index - 1);
	    }
	}

	// 下移
	function movedownRolesModel() {
		var selections = basemodelgrid.datagrid('getSelections');
		if (! selections.length) {
			alertInfo('请先选择要移动的项目属性');
			return;
		}
		// 多行移动(下移)
		var length = basemodelgrid.datagrid("getRows").length;
		for(var i = 0; i < selections.length; i++){
			// 从最下面的选中列判断
			var $i = selections.length-1-i;
	        var index = basemodelgrid.datagrid('getRowIndex',selections[$i]);
	        if(index >= length-1){
	        	return;
	        }
	        // 当前行
			var todown = selections[$i];
			// 当前行的下一行,即移往的行
			var toup = basemodelgrid.datagrid('getData').rows[index + 1];
			basemodelgrid.datagrid('getData').rows[index + 1] = todown;
			basemodelgrid.datagrid('getData').rows[index] = toup;
			basemodelgrid.datagrid('refreshRow', index);
			basemodelgrid.datagrid('refreshRow', index + 1);
			// 支持多选,因此要先取消选中之前的选中行
			basemodelgrid.datagrid('unselectRow', index );
			basemodelgrid.datagrid('selectRow', index + 1);
	    }
	}
	
	function saveDisplayNo() {
		$('#save_RolesModel').linkbutton('disable');
		// 已分配里程碑节点列表grid信息
		var rows = basemodelgrid.datagrid('getRows');
		if(! rows.length){
			$('#save_RolesModel').linkbutton('enable');
			return;
		}
		var effectRow = new Object();
		effectRow["data"] = JSON.stringify(rows);

		var saveUrl = ctx + "/BasRolesModel/saveBasRolesModelDisplayNo";
		// 所有datagrid的数据均传入后台
		// 后台根据index进行排序并保存
		$.post(saveUrl, effectRow, function(result) {
			alertInfo('保存排序成功');
			basemodelgrid.datagrid('reload');
			// 启用按钮
			$('#save_RolesModel').linkbutton('enable');
		}, "JSON").error(function() {
			alertError('保存排序失败，请重试');
			// 启用按钮
			$('#save_RolesModel').linkbutton('enable');
		});
	}
