var basegrid=$('#BasPost_datagrid');
$(function(){
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#BasPost_datagrid_tb",
	    url:ctx+'/BasPost/pageBasPost',
	    columns:[[
	    {field:'POST_ID',title:'postId',hidden:true},
	    {field:'POST_CODE',title:'岗位编码',width:100,align:'center',halign:'center'},
	    {field:'POST_NAME',title:'岗位名称',width:100,align:'center',halign:'center'},
	    {field:'OA_ID',title:'OA系统ID',hidden:true}
	    ]],
	    onDblClickRow : editBasPost
	});

}
//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchBasPost(){
	basegrid.datagrid('load',{
		search:$("#searchBasPost").val()
	});
}

//增加记录
function addBasPost() {
	openSaveDialog({
		title:"添加记录",
		contenturl:"/view/base/BasPostform",
		submiturl:"/BasPost/saveBasPost",
		callback:reloadGrid
	});
	
}

//修改记录
function editBasPost() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.POST_ID;
		openSaveDialog({
			title : "修改记录",
			contenturl : "/view/base/BasPostform",
			submiturl : "/BasPost/saveBasPost",
			onload : "/BasPost/findBasPost?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delBasPost() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.POST_ID;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasPost/delBasPost",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
