var basetree=$('#BasMenu_tree');
var baseform=$('#BasMenu_form');
var basegrid=$('#BasMenuButton_datagrid');
var basegrid_public=$('#BasMenuButton_datagrid_public');
var basegrid_data=$('#BasMenuButton_datagrid_data');

$(function(){
	initTree();
	initGridData();
	initGrid();
	initGridPublic();

});

function initTree(){
	basetree.tree({
		url : ctx + '/BasMenu/treeBasMenuWithRoot',
		onSelect : function(node) {
			openNode(node);
		},
		onLoadSuccess : function(node, data) {
			// 默认显示根节点信息
			var root = $(this).tree('getRoot');
			if(node){
				$(this).tree('select', node.target);
			}else{
				$(this).tree('collapseAll');
				$(this).tree('expand',root.target);
				$(this).tree('select', root.target);
			}
		}
	});
}

//初始化自定义权限
function initGrid(){
	basegrid.datagrid({
		// fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		pagination:true,
		toolbar:"#BasMenuButton_datagrid_tb",
	    url:ctx+'/BasMenuButton/pageBasMenuButton',
	    columns:[[
	    {field:'BUTTON_ID',title:'buttonId',hidden:true},
//	    {field:'BUTTON_ICON',title:'图标',width:30,formatter:function(value){
//	    return '<div class="'+value+'" style="font-style:normal">&nbsp;</div>';
//	    }},
//	    {field:'GROUP_NO',title:'组号',width:30,align:'left',halign:'center'},
	    {field:'BUTTON_TEXT',title:'权限名称',width:80,align:'left',halign:'center'},
	    {field:'BUTTON_HTMLID',title:'权限编码',width:160,align:'left',halign:'center'},
	    {field:'IS_CONTROL',title:'权限控制',width:60,formatter:function(value){
	    	if(value=='Y'){
	    		return '<font color="green">是</font>';
	    	}else if(value=='N'){
	    		return '<font color="red">否</font>';
	    	}
	    }},
	    {field:'MEMO',title:'备注说明',width:100,align:'left',halign:'center'}
	    ]],
	    onDblClickRow : editBasMenuButton
	});
}

//初始化公用权限
function initGridPublic() {
	basegrid_public.datagrid({
		border:false,
		singleSelect:true,
		rownumbers:true,
		pagination:true,
		toolbar:"#BasMenuButton_datagrid_tb_public",
		url:ctx+'/dic/findDicByDicCode?dicCode=shrioType',
		columns:[[
			// {field:'opt',checkbox:true},
			{field:'IS_CHECK',title:'选择',width:40,align:'center',halign:'center',
				editor: { type: 'checkbox',options:{on:'Y',off:'N'}},
				formatter:function(value){
					return value=='Y'?"<a class='icon-ok'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</a>":"";
				}
			},
			{field:'MENU_ID',title:'MENU_ID',hidden:true},
//	    {field:'BUTTON_ICON',title:'图标',width:30,formatter:function(value){
//	    return '<div class="'+value+'" style="font-style:normal">&nbsp;</div>';
//	    }},
//	    {field:'GROUP_NO',title:'组号',width:30,align:'left',halign:'center'},
			{field:'BUTTON_TEXT',title:'权限名称',width:80,align:'left',halign:'center'},
			{field:'BUTTON_HTMLID',title:'权限编码',width:160,align:'left',halign:'center'},
			// {field:'IS_CONTROL',title:'权限控制',width:60,formatter:function(value){
			// 	if(value=='Y'){
			// 		return '<font color="green">是</font>';
			// 	}else if(value=='N'){
			// 		return '<font color="red">否</font>';
			// 	}
			// }},
			{field:'MEMO',title:'备注说明',width:100,align:'left',halign:'center',editor: { type: 'textbox',options: { required: false}}}
		]],
		// onDblClickRow : editBasMenuButton
		onClickRow:function(index, row){
			//查看明细
			if (endGridEdit()) {
				basegrid_public.datagrid('selectRow', index);
				$(this).datagrid("beginEdit", index);
			}
		},
	});
}

// 判断当前行是否编辑结束
function endGridEdit() {
	var rows = basegrid_public.datagrid('getRows');
	for (var i = 0; i < rows.length; i++) {
		if (basegrid_public.datagrid('validateRow', i)) {
			basegrid_public.datagrid('endEdit', i);
		} else {
			basegrid_public.datagrid('endEdit', i);
			return true;
		}
	}
	return true;
}


//初始化数据权限
function initGridData() {
	basegrid_data.datagrid({
		// fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		method : 'post',
		pagination:true,
		toolbar:"#BasMenuButton_datagrid_tb_data",
		url:ctx+'/dic/findDicByDicCode?dicCode=shrioDateType',
		columns:[[
			// {field:'opt',checkbox:true},
			{field:'IS_CHECK',title:'选择',width:40,align:'center',halign:'center',
				editor: { type: 'checkbox',options:{on:'Y',off:'N'}},
				formatter:function(value,raw,index){
					return value=='Y'?"<a class='icon-ok'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</a>":"";
				}
			},
			{field:'MENU_ID',title:'MENU_ID',hidden:true},
//	    {field:'BUTTON_ICON',title:'图标',width:30,formatter:function(value){
//	    return '<div class="'+value+'" style="font-style:normal">&nbsp;</div>';
//	    }},
//	    {field:'GROUP_NO',title:'组号',width:30,align:'left',halign:'center'},
			{field:'BUTTON_TEXT',title:'权限名称',width:80,align:'left',halign:'center'},
			{field:'BUTTON_HTMLID',title:'权限编码',width:160,align:'left',halign:'center'},
			// {field:'IS_CONTROL',title:'权限控制',width:60,formatter:function(value){
			// 	if(value=='Y'){
			// 		return '<font color="green">是</font>';
			// 	}else if(value=='N'){
			// 		return '<font color="red">否</font>';
			// 	}
			// }},
			{field:'MEMO',title:'备注说明',width:100,align:'left',halign:'center',
				editor:{
					type:'textbox' ,
				}}
		]],
		onClickRow:function(index, row){
			//查看明细
			if (endGridEditData()) {
				basegrid_data.datagrid('selectRow', index);
				basegrid_data.datagrid("beginEdit", index);
			}
		},
		// onDblClickRow : editBasMenuButton
	});
}

function endGridEditData() {
	var rows = basegrid_data.datagrid('getRows');
	for (var i = 0; i < rows.length; i++) {
		if (basegrid_data.datagrid('validateRow', i)) {
			basegrid_data.datagrid('endEdit', i);
		} else {
			basegrid_data.datagrid('scrollTo', i);
			return false;
		}
	}
	return true;
}

function openNode(node) {
	var public=1;
	var data=1;
	var user=1;
	var titleNow = $('.tabs-selected').text();
	//当前打开的选项卡不再初始化
	if(titleNow=="公用权限"){
		if((public++)==2){}
	}
	if(titleNow=="数据权限"){
		if((data++)==2){}
	}
	if(titleNow=="自定义权限"){
		if((user++)==2){}
	}
	$('#tabs').tabs({
		border:false,
		onSelect:function(title){
			//如果此节点下该选项卡是第一次打开，则初始化
			if(title=="公用权限"){
				basegrid_public.show();
				basegrid_data.hidden;
				basegrid.hidden;
				if((public++)==1){
					initGridPublic();
				}
			}
			if(title=="数据权限"){
				basegrid_data.show();
				basegrid_public.hidden;
				basegrid.hidden;
				if((data++)==1){
					initGridData();
				}
			}
			if(title=="自定义权限"){
				basegrid.show();
				basegrid_data.hidden;
				basegrid_public.hidden;
				if((user++)==1){
					initGrid();
				}
			}
		}
	});
	baseform.form('clear');
	if(node.id==0){
		return;
	}
	baseform.form('load',ctx+"/BasMenu/findBasMenu?id="+node.id);
	basegrid.datagrid('load',{
		menuid:node.id
	});
	basegrid_public.datagrid('load',{
		menuid:node.id
	});
	basegrid_data.datagrid('load',{
		menuid:node.id
	});
}

function expandNode(){
	basetree.tree('expandAll');
}

function resetBasMenu(){
	//form本身的reset方法会清空表单
	var node = basetree.tree('getSelected');
	openNode(node);
}
//增加
function addBasMenu() {
	var node = basetree.tree('getSelected');
	// 清除当前界面信息
	$("#menuType").combobox("clear");
	baseform.form('clear');	
	$("#appCode").combobox("setValue","1");
	$("#operationPrivilege").val("0");

	$("#enable").combobox("setValue","Y");
	$('#pmenuId').combotree('setValue',node.id);
	basegrid.datagrid('load',{
		menuid:0
	});
	basegrid_public.datagrid('load',{
		menuid:node.id
	});
	basegrid_data.datagrid('load',{
		menuid:node.id
	});
}

//删除
function delBasMenu() {
	var node = basetree.tree('getSelected');
	if (node) {
		if(node.id==0){
			alertInfo('根节点不可删除!');
			return;
		}
		alertConfirm('将删除该节点级下级所有节点,确定?', function(r) {
			if (r) {
				$.ajax({
					type : 'post',
					dataType : 'json',
					url : ctx + "/BasMenu/delBasMenuAndChild?id=" + node.id,
					success : function(result) {
						if (result.success) {
							var pnode = basetree.tree('getParent',node.target);
							if(pnode){
								basetree.tree('select', pnode.target);
							}
							basetree.tree('remove', node.target);
							alertInfo(result.msg);
						}else {
							alertError(result.msg);
						}
					},error:function(){
						alertError("删除失败!");
					}
				});
			}
		});
	} else {
		alertInfo('请选择一个节点');
	}
}

function saveBasMenu(){
	var selectnode = basetree.tree('getSelected');
	if (selectnode) {
		if ($("#menuId").val() === 0) {
			alertInfo('根节点无需保存');
			return;
		}
		baseform.form('submit', {
			url : ctx + "/BasMenu/saveBasMenu",
			onSubmit : function() {
				if ($(this).form('validate')) {
					// 防止重复发送
					$('#saveBasMenu').linkbutton('disable');
					return true;
				} else {
					return false;
				}
			},
			success : function(result) {
				result = jQuery.parseJSON(result);
				if (result.success) {
					$('#pmenuId').combotree('reload');
					// 获取选中的节点
					var resultnode = basetree.tree('find',result.o.menuId);
					if (resultnode) {// 通过节点上是否有该节点判断 新增还是修改
						basetree.tree('update', {
									target : selectnode.target,
									text : result.o.menuName
								});
					} else {
						basetree.tree('append', {
									parent : selectnode.target,
									data : [{
												id : result.o.menuId,
												text : result.o.menuName
											}]
								});
					}
					//alertInfo(result.msg);
					var newnode = basetree.tree('find', result.o.menuId);
					basetree.tree('select', newnode.target);
					$('#saveBasMenu').linkbutton('enable');
					saveBasMenuButton();
					//saveBasMenuButtondata();
					//sleep(400);
					//reloadGrid();
					//alertInfo(result.msg);
				} else {
					alertError(result.msg);
					$('#saveBasMenu').linkbutton('enable');
				}

			}
		});
	} else {
		alertInfo('请选择一个节点');
	}

}


function chooseIco(){
openChooseDialog({
	title:'选择图标',
	contenturl:"/BasMenu/chooseIcons",
	width:600,
	height:400,
	okhandler:function(){
		if($('#chooseico').val()){
			$('#menuIco').textbox('setValue',$('#chooseico').val());
			return true;
		}else{
			alertInfo('请选择一个图标');
			return false;
		}
	}
});

}

//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
	basegrid_public.datagrid('reload');
	basegrid_data.datagrid('reload');
}

//增加记录
function addBasMenuButton() {
	var node = basetree.tree('getSelected');
			if (node) {
				if(node.id==0){
					alertInfo('根节点不能操作!');
					return false;
				}else if($("#menuType").combobox('getValue')!="2"){
					alertInfo('只有网页型菜单才可以增加按钮!');
					return false;
				}else{
					openSaveDialog({
						width:500,
						height:300,
						title:"添加记录",
						contenturl:"/view/base/BasMenuButtonform",
						submiturl:"/BasMenuButton/saveBasMenuButton",
						onload:function(){
							$("#BasMenuButton_Form #menuId").val(node.id);
						},
						callback:reloadGrid
					});
					
				}
			}else{
				alertInfo('请选择一个节点');
			}
	
}

//修改记录
function editBasMenuButton() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.BUTTON_ID;
		openSaveDialog({
			width:500,
			height:300,
			title : "修改记录",
			contenturl : "/view/base/BasMenuButtonform",
			submiturl : "/BasMenuButton/saveBasMenuButton",
			onload : "/BasMenuButton/findBasMenuButton?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delBasMenuButton() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.BUTTON_ID;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasMenuButton/delBasMenuButton",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}


function buttonchooseIco(){
openChooseDialog({
	title:'选择图标',
	contenturl:"/BasMenu/chooseBtnIcons",
	width:600,
	height:400,
	okhandler:function(){
		if($('#chooseico').val()){
			$('#buttonIcon').textbox('setValue',$('#chooseico').val());
			return true;
		}else{
			alertInfo('请选择一个图标');
			return false;
		}
	}
});

}


//上移
	function moveupBasMenuButton() {
		var selections = basegrid.datagrid('getSelections');
		if (! selections.length) {
			alertInfo('请先选择要移动的项目属性');
			return;
		}
		// 多行移动(上移)
		for(var i = 0; i < selections.length; i++){
			var index = basegrid.datagrid('getRowIndex',selections[i]);
	        if(index <= 0){
	        	return;
	        }
	        // 当前行
			var toup = selections[i];
			// 当前行的上一行,即移往的行
			var todown = basegrid.datagrid('getData').rows[index - 1];
			basegrid.datagrid('getData').rows[index] = todown;
			basegrid.datagrid('getData').rows[index - 1] = toup;
			basegrid.datagrid('refreshRow', index);
			basegrid.datagrid('refreshRow', index - 1);
			// 支持多选,因此要先取消选中之前的选中行
			basegrid.datagrid('unselectRow', index );
			basegrid.datagrid('selectRow', index - 1);
	    }
	}

	// 下移
	function movedownBasMenuButton() {
		var selections = basegrid.datagrid('getSelections');
		if (! selections.length) {
			alertInfo('请先选择要移动的项目属性');
			return;
		}
		// 多行移动(下移)
		var length = basegrid.datagrid("getRows").length;
		for(var i = 0; i < selections.length; i++){
			// 从最下面的选中列判断
			var $i = selections.length-1-i;
	        var index = basegrid.datagrid('getRowIndex',selections[$i]);
	        if(index >= length-1){
	        	return;
	        }
	        // 当前行
			var todown = selections[$i];
			// 当前行的下一行,即移往的行
			var toup = basegrid.datagrid('getData').rows[index + 1];
			basegrid.datagrid('getData').rows[index + 1] = todown;
			basegrid.datagrid('getData').rows[index] = toup;
			basegrid.datagrid('refreshRow', index);
			basegrid.datagrid('refreshRow', index + 1);
			// 支持多选,因此要先取消选中之前的选中行
			basegrid.datagrid('unselectRow', index );
			basegrid.datagrid('selectRow', index + 1);
	    }
	}
	
	function saveDisplayNo() {
		$('#save_BasMenuButton').linkbutton('disable');
		// 已分配里程碑节点列表grid信息
		var rows = basegrid.datagrid('getRows');
		if(! rows.length){
			$('#save_GenPanelItem').linkbutton('enable');
			return;
		}
		var effectRow = new Object();
		effectRow["data"] = JSON.stringify(rows);

		var saveUrl = ctx + "/BasMenuButton/saveBasMenuButtonDisplayNo";
		// 所有datagrid的数据均传入后台
		// 后台根据index进行排序并保存
		$.post(saveUrl, effectRow, function(result) {
			alertInfo('保存排序成功');
			basegrid.datagrid('reload');
			// 启用按钮
			$('#save_BasMenuButton').linkbutton('enable');
		}, "JSON").error(function() {
			alertError('保存排序失败，请重试');
			// 启用按钮
			$('#save_BasMenuButton').linkbutton('enable');
		});
	}
	
	function formatmenuCss(row){
			var s = '<span style="font-weight:bold">' + row.text + '</span><br/>' +
			'<a style="display:inline-block; width:80px;height:80px" class="'+row.text+'"></a>';
            return s;
	}

function  saveBasMenuButton() {
	if(endGridEdit()&&endGridEditData()) {
		var rowspublic = basegrid_public.datagrid("getRows");
		var rowsdata = basegrid_data.datagrid("getRows");
		var rows = rowspublic.concat(rowsdata);
		if (rows.length != 0) {
			$.ajax({
				url: ctx
					+ "/BasMenuButton/saveBasMenuButtonByType",
				data: {
					rows: rows,
					size: rows.length,
					type:"public"
				},
				dataType: 'json',
				success: function (result) {
					if (result.success) {
						reloadGrid();
						$('#saveBasMenu').linkbutton('enable');
					} else {
						alertError(result.msg);
					}
				}
			});
		}
	}
}
/*
function  saveBasMenuButtondata() {
	if(endGridEditData()) {
		var rows = basegrid_data.datagrid("getRows");
		if (rows.length != 0) {
			$.ajax({
				url: ctx
					+ "/BasMenuButton/saveBasMenuButtonByType",
				data: {
					rows: rows,
					type: 'data',
					size: rows.length,
				},
				dataType: 'json',
				success: function (result) {
					if (result.success) {
						$('#saveBasMenu').linkbutton('enable');
					} else {
						alertError(result.msg);
					}
				}
			});
		}
	}
}
*/

function sleep(n) {

	var start = new Date().getTime();

	while(true) {
		if (new Date().getTime() - start > n) break
	};

}


