var basegrid=$('#BasEmpApplyEdit_datagrid');
$(function(){
     //流程状态下拉框
	$('#flow_combo').combobox({
		editable : false,
		onChange:function(newV,oldV){
			if(oldV){
				searchBasEmpApplyEdit();
			}
		}
	});
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
		// fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		cls:'md',
		height:$("body").height()-140,
		queryParams:{
			flowDone:haseasyui('#flow_combo')?$('#flow_combo').combobox('getValue'):""
		},
		toolbar:"#BasEmpApplyEdit_datagrid_tb",
	    url:ctx+'/BasEmpApplyEdit/pageBasEmpApplyEdit',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="openFormDetail('+row.id+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'applyManName',title:'申请人',width:120,align:'center',halign:'center',sortable:true},
	    {field:'applyDate',title:'申请日期',width:100,align:'center',halign:'center',sortable:true},
	    {field:'applyContent',title:'申请修改内容',width:300,align:'center',halign:'center',sortable:true},
//	    {field:'remark',title:'说明',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'createAccount',title:'创建人',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'createTime',title:'创建日期',width:100,align:'center',halign:'center',sortable:true},
	    {field:'workflowStatusText',title:'审批状态',width:100,align:'center',halign:'center',sortable:true}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			openFormDetail(row.id);
	    }
	});
    basegrid.datagrid('doCellTip');
    var pager = basegrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('BasEmpApplyEdit_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function openFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasEmpApplyEdit&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchBasEmpApplyEdit(){
	basegrid.datagrid('load',{
	    flowDone:haseasyui('#flow_combo')?$('#flow_combo').combobox('getValue'):"",
		//search:$("#searchBasEmpApplyEdit").val(),
		applyManName:$("#applyManName").val()
	});
}

//增加记录
function addBasEmpApplyEdit() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasEmpApplyEdit",
		submiturl:"/BasEmpApplyEdit/saveBasEmpApplyEdit?formcode=BasEmpApplyEdit",
		callback:reloadGrid
	});
	
}

//修改记录
function editBasEmpApplyEdit() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	    if(row.workflowStatus.toString().indexOf('1')==-1){
			alertInfo('数据已经上报过,不能修改');
			return;
		}
		var id = row.id;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=BasEmpApplyEdit&id=" + id,
			submiturl:"/BasEmpApplyEdit/saveBasEmpApplyEdit?formcode=BasEmpApplyEdit",
			//onload : "/BasEmpApplyEdit/findBasEmpApplyEdit?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delBasEmpApplyEdit() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
    if(row.workflowStatus.toString().indexOf('1')==-1){
		alertInfo('数据已经上报过,不能删除');
		return;
	}
		
	var id =row.id;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasEmpApplyEdit/delBasEmpApplyEdit",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
function doFlow(){
	var row = basegrid.datagrid('getSelected');
	if (row) {
		if(row.workflowStatus=='3'){
			alertInfo('数据已通过');
			return;
		}
		
		openFlowDialog({
    		processInstId:row.processinstid,
			businessMainId:row.id,
			formCode:"BasEmpApplyEdit",
			callback:reloadGrid
        });
	} else {
		alertInfo('请先选择一条数据信息');
	}
}

function viewFlow(){
	var row = basegrid.datagrid('getSelected');
	if (row) {
		viewFlowDialog(row.processinstid)
	} else {
		alertInfo('请先选择一条数据信息');
	}
}