var basegrid=$('#BasDicType_datagrid');
$(function(){
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#BasDicType_datagrid_tb",
	    url:ctx+'/BasDicType/pageBasDicType',
	    queryParams:{
	    	businessTypeId : businessTypeId
	    },
	    columns:[[
	    {field:'dicCode',title:'字典编码',width:120,halign:'center',hidden:businessTypeId!=''},
	    {field:'dicName',title:'字典名称',width:100,align:'left',halign:'center'},
	    {field:'dicTypeText',title:'类型',width:50,align:'center',halign:'center',hidden:businessTypeId!=''},
	    {field:'userEditText',title:'允许用户编辑',width:50,align:'center',halign:'center',hidden:businessTypeId!=''},
	    {field:'businessType',title:'字典类别',width:50,align:'center',halign:'center',hidden:businessTypeId!=''},
        {field:'usenum',title:'引用次数',width:60}
//	    {field:'DATA_ATTR',title:'dataAttr',width:100,align:'center',halign:'center'},
//	    {field:'RMK',title:'备注',width:100,align:'center',halign:'center'},
//	    {field:'FLAG_TEXT_',title:'启用',width:40,align:'center',halign:'center'},
//	    {field:'ORD_BY',title:'排序',width:40,align:'center',halign:'center'}
	    ]],
	    onClickRow : function(index, row){
			loadDicPanel(row);
		},
	    onDblClickRow:function(index, row){
			editBasDicType();
	    },
		onLoadSuccess : function(data){
			if(data.total > 0){
				basegrid.datagrid('selectRow', 0);
				var row = data.rows[0];
				loadDicPanel(row);
			}
		}
	});
	function loadDicPanel(row){
		var panel = $("#easyuiLayout").layout('panel', 'center');
		var userEdit="Y";
		if(businessTypeId!=""){
			userEdit=row.userEdit;
		}
		panel.panel("refresh", ctx+"/view/base/basdic?userEdit="+userEdit+"&type="+row.dicType);
	}
    basegrid.datagrid('doCellTip');
    var pager = basegrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('BasDicType_datagrid',"title");   
	        }    
	    }]   
	});
}
//重新加载表格
function reloadTypeGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchBasDicType(){
	basegrid.datagrid('load',{
		search:$("#searchBasDicType").val(),
		businessTypeId : businessTypeId
	});
}

//增加记录
function addBasDicType() {
	openSaveDialog({
		title:"添加记录",
//		maximized : true,
//		contenturl:"/GenForm/form?formcode=BasDicType_Form",
//		submiturl:"/BasDicType/saveBasDicType?formcode=BasDicType_Form",
		height:460,
		contenturl:"/view/base/BasDicTypeform",
		submiturl:"/BasDicType/saveBasDicType",
		callback:reloadTypeGrid,
		onload:function(){
			$("#flag").combobox("setValue",'Y');
			$("#userEdit").combobox("setValue",'N');
		}
	});
	
}

//修改记录
function editBasDicType() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.id;
		openSaveDialog({
			title : "修改记录",
			height:460,
//			maximized : true,
//			contenturl:"/GenForm/form?formcode=BasDicType_Form&id=" + id,
//			submiturl:"/BasDicType/saveBasDicType?formcode=BasDicType_Form",
			contenturl : "/view/base/BasDicTypeform",
			submiturl : "/BasDicType/saveBasDicType",
			onload : "/BasDicType/findBasDicType?id=" + id,
			callback : reloadTypeGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delBasDicType() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.id;
		if(row.dicType =='S'){
			alertInfo('系统字典，禁止删除！');
			return;
		}else if(row.usenum >0){
			alertInfo('字典被引用，禁止删除！');
			return;
		}
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasDicType/delBasDicType",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							loadDicPanel(row);
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
