var peoplegrid=$('#BasContactPeople_datagrid');

/****************************初始化***********************************/
$(function(){
	initContactPeople();
});

/*********************************联系人信息*************************************/
function initContactPeople(){
	peoplegrid.datagrid({
//		fit:true,
		height : '400px',
		border:false,
		singleSelect:true,
		rownumbers:true,
//		fitColumns:true,
		pagination:true,
		toolbar:"#BasContactPeople_datagrid_tb",
	    url:ctx+'/BasContactPeople/pageBasContactPeople',
	    queryParams: {
	    	search:$("#searchBasContactPeople").val(),
			contactOrgId : contactOrgId
		},
	    columns:[[
	    {field:'CONTACT_PEOPLE_ID',title:'主键',width:100,align:'center',halign:'center',hidden:true},
	    {field:'CONTACT_ORG_ID',title:'往来单位主键',width:100,align:'center',halign:'center',hidden:true},
	    {field:'PEOPLE_NAME',title:'姓名',width:100,align:'center',halign:'center'},
	    {field:'PEOPLE_TEL',title:'电话',width:100,align:'center',halign:'center'},
	    {field:'STATUS_TEXT_',title:'状态',width:100,align:'center',halign:'center'},
	    {field:'MEMO',title:'备注',width:100,align:'center',halign:'center'}
	    ]],
	    onDblClickRow : editBasContactPeople
	});
}

function reloadPeopleGrid(){
	peoplegrid.datagrid('reload');
}

function searchBasContactPeople(contactOrgId){
	peoplegrid.datagrid('load',{
		search:$("#searchBasContactPeople").val(),
		contactOrgId : contactOrgId
	});
}

function initPeopleForm(){
	$('#pcontactOrgId').val(contactOrgId);
}

//增加
function addBasContactPeople() {
	openSaveDialog({
		title:"添加联系人信息",
		contenturl:"/view/base/BasContactPeopleform",
		submiturl:"/BasContactPeople/saveBasContactPeople",
		submitbtn : 'BasContactPeople_Form',
		onload : initPeopleForm,
		callback:reloadPeopleGrid
	});
}

//修改
function editBasContactPeople() {
	var row = peoplegrid.datagrid('getSelected');
	if (row) {
		var id = row.CONTACT_PEOPLE_ID;
		openSaveDialog({
			title : "修改联系人信息",
			contenturl : "/view/base/BasContactPeopleform",
			submiturl : "/BasContactPeople/saveBasContactPeople",
			onload : "/BasContactPeople/findBasContactPeople?id=" + id,
			submitbtn : 'BasContactPeople_Form',
			callback : reloadPeopleGrid
		});
	} else {
		alertInfo('请选择一条联系人信息进行修改');
	}
}

//删除
function delBasContactPeople() {
	var row = peoplegrid.datagrid('getSelected');
	if (row) {
	var id =row.CONTACT_PEOPLE_ID;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasContactPeople/delBasContactPeople",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							peoplegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的');
	}
}
