var basetree=$('#BasBusinessProcess_tree');
var baseform=$('#BasBusinessProcess_form');
$(function(){
	initTree();
});
//初始化左侧树
function initTree(){
	basetree.tree({
		url : ctx + '/BasBusinessProcess/treeBasBusinessProcessWithRoot',
		onSelect : function(node) {
			openNode(node);
		},
		onLoadSuccess : function(node, data) {
			// 默认显示根节点信息
			var root = $(this).tree('getRoot');
			if(node){
				$(this).tree('select', node.target);
			}else{
				$(this).tree('collapseAll');
				$(this).tree('expand',root.target);
				$(this).tree('select', root.target);
			}
		}
	});
}
//控制按钮的可用状态 如果选中的是虚拟的根节点择会禁用对应按钮
function controlBtn(isable){
	if(isable){
		$('#delBasBusinessProcess').linkbutton('enable'); //删除
		$('#saveBasBusinessProcess').linkbutton('enable'); //保存
	}else{
		$('#delBasBusinessProcess').linkbutton('disable');
		$('#saveBasBusinessProcess').linkbutton('disable');
	}
}
//加载节点信息,对根节点进行了特殊处理===表示值和类型都匹配
function openNode(node) {
	if(node.id==="0"){
		baseform.form('clear');
		$('.editForm tr').hide();
		$('.show_colum').show();
		controlBtn(false);
	}else{
		var businessType=findBusinessType(node.id).businessType;
		if(businessType=="1"||businessType=="2"){
			$('.editForm tr').hide();
			$('.show_colum').show();
		}else if(businessType=="3"){
			$('.editForm tr').hide();
			$('.show_colum').show();
			$('.table_uses').show();
			/**/
		}else if(businessType=="4"){
			$('.editForm tr').show();
		}else {
			$('.editForm tr').hide();
			$('.show_colum').show();
		}
		baseform.form('load',ctx+"/BasBusinessProcess/findBasBusinessProcess?id="+node.id);
		baseform.form({onLoadSuccess:setFileName});
		controlBtn(true);
	}
}

function changeShow(businessType,oldType){
	if(businessType==oldType){
		return true;
	}
	var node = basetree.tree('getSelected');
	var pid=null;
	var entity=findBusinessType(node.id);
	if(entity!=null){
		pid=entity.businessPid;
	}
	if(pid!=null && pid!=0){
		var pidType=findBusinessType(pid).businessType;
		if(pidType>=businessType){
			alertInfo("请选择正确的业务类别");
			$('#businessType').combobox('clear');
			return true;
		}
	}
	if(businessType=="1"||businessType=="2"){
		$('.editForm tr').hide();
		$('.show_colum').show();
	}else if(businessType=="3"){
		$('.editForm tr').hide();
		$('.show_colum').show();
		$('.table_uses').show();
		/**/
	}else if(businessType=="4"){
		$('.editForm tr').show();
	}else {
		$('.editForm tr').hide();
		$('.show_colum').show();
	}
}

function setFileName(){
	var node = basetree.tree('getSelected');
	var imageUrl=findBusinessType(node.id).imageUrl;
	$("#fileId").textbox('setText',imageUrl);
}

function findBusinessType(id){
	var businessType=null;
	$.ajax({
		dataType : 'json',
		async : false,
		url : ctx + "/BasBusinessProcess/findBusinessById?id=" + id,
		success : function(result) {
			if (result.success) {
				businessType= result.o;
			}
		},
		error:function(){
			alertError("查找数据失败!");
		}
		
	});
	return businessType;
}

function expandNode(){
	basetree.tree('expandAll');
}

function resetBasBusinessProcess(){
	//form本身的reset方法会清空表单
	var node = basetree.tree('getSelected');
	openNode(node);
}
//增加
function addBasBusinessProcess() {
	// 清除当前界面信息
	baseform.form('clear');	
	var node = basetree.tree('getSelected');
	var businessType=null;
	var entity=findBusinessType(node.id);
	if(entity!=null){
		businessType=entity.businessType;
	}
	if(businessType==null || businessType==''){
		$('#businessType').combobox('setValue',1);
		$('.editForm tr').hide();
		$('.show_colum').show();
	}else if(businessType=="1"){
		$('#businessType').combobox('setValue','2');
	}
		$('#businessPid').combotree('setValue',node.id);
	$('#saveBasBusinessProcess').linkbutton('enable');
}

//删除
function delBasBusinessProcess() {
	var node = basetree.tree('getSelected');
	if (node) {
		if(node.id==="0"){
			alertInfo('根节点不可删除!');
			return;
		}
		alertConfirm('将删除该节点及下级所有节点,确定?', function(r) {
			if (r) {
				$.ajax({
					type : 'post',
					dataType : 'json',
					url : ctx + "/BasBusinessProcess/delBasBusinessProcessAndChild?id=" + node.id,
					success : function(result) {
						if (result.success) {
							var pnode = basetree.tree('getParent',node.target);
							if(pnode){
								basetree.tree('select', pnode.target);
							}
							basetree.tree('remove', node.target);
							alertInfo(result.msg);
						}else {
							alertError(result.msg);
						}
					},error:function(){
						alertError("删除失败!");
					}
				});
			}
		});
	} else {
		alertInfo('请选择一个节点');
	}
}

function saveBasBusinessProcess(){
	var selectnode = basetree.tree('getSelected');
	if (selectnode) {
		baseform.form('submit', {
			url : ctx + "/BasBusinessProcess/saveBasBusinessProcess",
			onSubmit : function() {
				if ($(this).form('validate')) {
					// 防止重复发送
					$('#saveBasBusinessProcess').linkbutton('disable');
					return true;
				} else {
					return false;
				}
			},
			success : function(result) {
				result = jQuery.parseJSON(result);
				if (result.success) {
					$('#businessPid').combotree('reload');
					// 获取选中的节点
					var resultnode = basetree.tree('find',result.o.businessId);
					if (resultnode) {// 通过节点上是否有该节点判断 新增还是修改
						basetree.tree('update', {
									target : selectnode.target,
									text : result.o.businessName
									
								});
					} else {
						basetree.tree('append', {
									parent : selectnode.target,
									data : [{
id:result.o.businessId,
text:result.o.businessName
											}]
								});
					}
					alertInfo(result.msg);
					var newnode = basetree.tree('find',result.o.businessId);
					basetree.tree('select', newnode.target);
					newnode.attributes=result.o;
					$('#saveBasBusinessProcess').linkbutton('enable');
				} else {
					alertError(result.msg);
					$('#saveBasBusinessProcess').linkbutton('enable');
				}
			}
		});
	} else {
		alertInfo('请选择一个节点');
	}
}

function setAddress(node) {
	$.ajax({
		type : 'post',
		dataType : 'json',
		url : ctx + "/BasMenu/findBasMenuByBusiness?id=" + node.id,
		success : function(result) {
			if (result.success) {
				$("#pageAddress").textbox('setValue',result.o.menuAddr);
			}else {
				$("#menuId").combotree('setValue','');
				alertError(result.msg);
			}
		},error:function(){
			alertError("加载失败!");
		}
	});
	
}