var basetree=$('#BasBank_tree');
var baseform=$('#BasBank_form');
var basetreemenu=$('#BasBank_menu');
var basegrid=$('#BasBankAccount_datagrid');
$(function(){

	initTree();
	initGrid();
});
//初始化左侧树
function initTree(){
	basetree.tree({
		url : ctx + '/BasBank/treeBasBankWithRoot',
		onSelect : function(node) {
			reloadGrid();
		},
		onContextMenu: function (e, node) {
            e.preventDefault();
        	//右击后选择树
            var selectnode = basetree.tree('getSelected');
            if(selectnode !=node){
                basetree.tree('select',node.target);
            }
            
            basetreemenu.empty();
            basetreemenu.menu('appendItem', {
				text: '新增银行信息',
				iconCls : 'icon-add iconfont blue',
				onclick: function(){
					addBasBank();
				}
			});
            basetreemenu.menu('appendItem', {
				text: '修改银行信息',
				iconCls : 'icon-edit iconfont green',
				onclick: function(){
					editBasBank();
				}
			});
            basetreemenu.menu('appendItem', {
				text: '删除银行信息',
				iconCls : 'icon-del iconfont red2',
				onclick: function(){
					delBasBank();
				}
			});
            basetreemenu.menu('show', {
				left : e.pageX,
				top : e.pageY
			});
        },
		onLoadSuccess : function(node, data) {
			// 默认显示根节点信息
			var root = $(this).tree('getRoot');
			if(node){
				$(this).tree('select', node.target);
			}else{
				$(this).tree('collapseAll');
				$(this).tree('expand',root.target);
				$(this).tree('select', root.target);
			}
		}
	});
}
//控制按钮的可用状态 如果选中的是虚拟的根节点择会禁用对应按钮
function controlBtn(isable){
	if(isable){
		$('#delBasBank').linkbutton('enable'); //删除
		$('#saveBasBank').linkbutton('enable'); //保存
	}else{
		$('#delBasBank').linkbutton('disable');
		$('#saveBasBank').linkbutton('disable');
	}
}
//加载节点信息,对根节点进行了特殊处理===表示值和类型都匹配
function openNode(node) {
	if(node.id==="0"){
		baseform.form('clear');
		controlBtn(false);
	}else{
		baseform.form('load',ctx+"/BasBank/findBasBank?id="+node.id);
		controlBtn(true);
	}
}
//增加
function addBasBank() {
	var node = basetree.tree('getSelected');
	openSaveDialog({
		title:"添加银行信息",
		contenturl:"/view/base/BasBankform",
		submiturl:"/BasBank/saveBasBank",
		onload:function(){
			$("#bankPid").combotree("setValue",node.id);
		},callback:function(){
			basetree.tree('reload')
		}
	});
}
//增加
function editBasBank() {
	var node = basetree.tree('getSelected');
	openSaveDialog({
		title:"添加银行信息",
		contenturl:"/view/base/BasBankform",
		submiturl:"/BasBank/saveBasBank",
		onload:"/BasBank/findBasBank?id="+node.id,
		callback:function(){
			basetree.tree('reload')
		}
	});
}

//删除
function delBasBank() {
	var node = basetree.tree('getSelected');
	if (node) {
		if(node.id==="0"){
			alertInfo('根节点不可删除!');
			return;
		}
		alertConfirm('将删除该节点及下级所有节点,确定?', function(r) {
			if (r) {
				$.ajax({
					type : 'post',
					dataType : 'json',
					url : ctx + "/BasBank/delBasBankAndChild?id=" + node.id,
					success : function(result) {
						if (result.success) {
							var pnode = basetree.tree('getParent',node.target);
							if(pnode){
								basetree.tree('select', pnode.target);
							}
							basetree.tree('remove', node.target);
							alertInfo(result.msg);
						}else {
							alertError(result.msg);
						}
					},error:function(){
						alertError("删除失败!");
					}
				});
			}
		});
	} else {
		alertInfo('请选择一个节点');
	}
}

function initGrid(){
	basegrid.datagrid({
		// fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		pagination:true,
		cls:'md',
		height:$("body").height()-140,
		toolbar:"#BasBankAccount_datagrid_tb",
	    url:ctx+'/BasBankAccount/pageBasBankAccount',
	    columns:[[
	    {field:'bankAccountId',title:'银行账号ID',hidden:true},
	    {field:'bankId',title:'银行ID',hidden:true},
	    {field:'orgId',title:'财务组织',hidden:true},
	    {field:'abbr',title:'财务组织',width:60,align:'left',halign:'center'},
	    {field:'bankName',title:'银行名称',width:150,align:'left',halign:'center'},
	    {field:'accountName',title:'账号名称',width:250,align:'left',halign:'center'},
	    {field:'accountNo',title:'银行账号',width:180,align:'right',halign:'center'},
	    {field:'accountDate',title:'开户日期',width:100,align:'center',halign:'center'},
	    {field:'initMoney',title:'初始化金额(元)',width:100,formatter:formatterMoney,align:'center',halign:'center'},
	     {field:'accountUseText',title:'账户类型',width:100,align:'center',halign:'center'},
	    {field:'remark',title:'备注',width:100,align:'center',halign:'center'}
	    ]],
	    onDblClickRow : editBasBankAccount
	});
	basegrid.datagrid('doCellTip');
	var pager = basegrid.datagrid('getPager');    // 得到datagrid的pager对象  
	pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('BasBankAccount_datagrid',"银行信息");   
	        }    
	    }]   
	}); 
}
//重新加载表格
function reloadGrid(){
	var node=basetree.tree('getSelected');
	var orgid=$("#orgId").combobox('getValue');
	var bankid="";
	if(node){
		bankid=node.id;
	}
	basegrid.datagrid('reload',{
		bankid:bankid,
		orgid:orgid,
		search:$("#searchBasBankAccount").val()
	});
}

//查询表格
function searchBasBankAccount(){
	reloadGrid();
}

//增加记录
function addBasBankAccount() {
	var node = basetree.tree('getSelected');
	if(node&&node.id!=="0"){
		openSaveDialog({
		title:"添加账号信息",
		width:600,
		height:400,
		contenturl:"/GenForm/form?formcode=BasBankAccount",
		submiturl:"/BasBankAccount/saveBasBankAccount",
	    //onsubmit:onBankSubmit,
		onload:function(){
			$("#bankId").val(node.id);
			$("#bankId_TEXT_").textbox("setValue",node.text);
			
		},
		callback:reloadGrid
	});
	}else{
		alertInfo('请在左侧树上选择一个银行进行操作');
	}
	
	
}
function expandNode(){
	basetree.tree('expandAll');
}
//修改记录
function editBasBankAccount() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.bankAccountId;
		openSaveDialog({
			title : "修改账号信息",
			width:600,
			height:400,
			contenturl : "/GenForm/form?formcode=BasBankAccount&id=" + id,
			submiturl : "/BasBankAccount/saveBasBankAccount",
			//onsubmit:onBankSubmit,
			onload : "/BasBankAccount/findBasBankAccount?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}
function onBankSubmit(params){
	endEditBankAccountData();
	var updated = $baccount_grid.datagrid('getRows');
	params.updated=JSON.stringify(updated);
	return true;
}
//删除记录
function delBasBankAccount() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.bankAccountId;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasBankAccount/delBasBankAccount",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}

function pushBasBankAccount(){
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id =row.bankAccountId;
		alertConfirmYes('您是否要推送当前银行账户信息到财务系统？', function (r) {
			if (r) {
				var loadIndex = layer.msg('数据同步中...', {
					icon: 16,
					shade: 0.3, time: 0
				});
				$.ajax({
					type: 'post',
					url: ctx + "/eassync/synBankAccount",
					data: {
						id: id
					},
					dataType: 'json',
					success: function (result) {
						layer.close(loadIndex);
						if (result.success) {
							alertInfo(result.msg);
						} else {
							alertError(result.msg);
						}
					},
					error: function () {
						layer.close(loadIndex);
						alertInfo("数据同步出错");
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要推送的数据');
	}
}