var BasAppVersionDataGrid=$('#BasAppVersion_datagrid');
$(function(){
	initBasAppVersionGrid();
});

function initBasAppVersionGrid(){
	BasAppVersionDataGrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#BasAppVersion_datagrid_tb",
	    url:ctx+'/BasAppVersion/pageBasAppVersion',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="BasAppVersionFormDetail('+row.appVersionId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    //{field:'appVersionId',title:'主键',width:100,align:'center',halign:'center'},
	    //{field:'appName',title:'app名称',width:100,align:'center',halign:'center'},
		{field:'appIdText',title:'APP_ID',width:100,align:'center',halign:'center'},
	    {field:'appVersion',title:'版本号',width:100,align:'center',halign:'center'},
	    {field:'apkVersionId_TEXT_',title:'APK附件',width:100,align:'center',halign:'center',
			formatter:function (value, row, index) {
	    		return row.apkVersionId ? ("<a href='#' onclick='downloadAppFile("+ row.apkVersionId +")'>"+ value +"</a>") : "";
			}
		},
	    {field:'wgtVersionId_TEXT_',title:'WGT附件',width:100,align:'center',halign:'center',
			formatter:function (value, row, index) {
				return row.wgtVersionId ? ("<a href='#' onclick='downloadAppFile("+ row.wgtVersionId +")'>"+ value +"</a>") : "";
			}
		},
	    {field:'appId',hidden:true},
	    {field:'createTime',title:'创建时间',width:100,align:'center',halign:'center'}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			openFormDetail(row.appVersionId);
	    }
	});
    BasAppVersionDataGrid.datagrid('doCellTip');
    var pager = BasAppVersionDataGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('BasAppVersion_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function BasAppVersionFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasAppVersion&isdetail=true&id="+id
	});
}

function downloadAppFile(versionId){
	downloadFile({versionid: versionId});
}

//重新加载表格
function reloadBasAppVersion(){
	BasAppVersionDataGrid.datagrid('reload');
}
//查询表格
function searchBasAppVersion(){
	BasAppVersionDataGrid.datagrid('load',{
		search:$("#searchBasAppVersion").val()
	});
}

//增加记录
function addBasAppVersion() {
	openSaveDialog({
		title:"添加记录",
		maximized : false,
		contenturl:"/GenForm/form?formcode=BasAppVersion",
		submiturl:"/BasAppVersion/saveBasAppVersion?formcode=BasAppVersion",
//		contenturl:"/view/base/BasAppVersion",
//		submiturl:"/BasAppVersion/saveBasAppVersion",
		callback:reloadBasAppVersion
	});
	
}

//修改记录
function editBasAppVersion() {
	var row = BasAppVersionDataGrid.datagrid('getSelected');
	if (row) {
		var id = row.appVersionId;
		openSaveDialog({
			title : "修改记录",
			maximized : false,
			contenturl:"/GenForm/form?formcode=BasAppVersion&id=" + id,
			submiturl:"/BasAppVersion/saveBasAppVersion?formcode=BasAppVersion",
//			contenturl : "/view/base/BasAppVersion",
//			submiturl : "/BasAppVersion/saveBasAppVersion",
//			onload : "/BasAppVersion/findBasAppVersion?id=" + id,
			callback : reloadBasAppVersion
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delBasAppVersion() {
	var row = BasAppVersionDataGrid.datagrid('getSelected');
	if (row) {
	var id =row.appVersionId;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasAppVersion/delBasAppVersion",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							BasAppVersionDataGrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
