package ${table.bizpack}.service;

import java.util.*;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Sort.Order;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import com.ustc.base.common.util.ComBoxTreeNode;
import com.ustc.base.common.util.CommTreeUtils;
import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.PageObject;
import ${table.bizpack}.dao.${table.entityName}Dao;
import ${table.bizpack}.entity.${table.entityName};

/**   
 * @Title: Service
 * @Description: ${table.description}
 * @author sys
 * @date ${table.date}
 * @version V1.0   
 *
 */
@Component
@Transactional
public class ${table.entityName}Service{
	
	@Autowired
	private BeetlSQLHelper bSqlHelper;
	@Autowired
	private ${table.entityName}Dao ${table.entityName?uncap_first}Dao;
	
	//根据ID查找实体bean
	public ${table.entityName} find${table.entityName}(Long id){
		${table.entityName} entity=${table.entityName?uncap_first}Dao.findById(id).get();
		return entity;
	}
	
	//持久化实体bean
	public void save${table.entityName}(${table.entityName} entity){
		${table.entityName?uncap_first}Dao.save(entity);
	}
	//删除实体bean  一般情况下不应该直接删除
	public void del${table.entityName}(Long id){
	//TODO 一般情况不应该直接物理删除数据
		${table.entityName?uncap_first}Dao.deleteById(id);
	}
	
	public PageObject PageAll(String search,int page,int rows){
		Map<String, Object> params =  new HashMap<String, Object>();
		if(!StringUtils.isEmpty(search)){
			params.put("search", search);
		}
		return bSqlHelper.serachPage("${table.bizpack?replace('com.ustc.','')}.${table.entityName}.PageAll", params);
	}
	
	//选中树节点删除节点及下级节点
	public void del${table.entityName}AndChild(Long id){
		Map<String, Object> params =  new HashMap<String, Object>();
		params.put("id", id);
		bSqlHelper.updateOrDelete("${table.bizpack?replace('com.ustc.','')}.${table.entityName}.del${table.entityName}AndChild", params);
	}
	
	/**
	 * 
	 * 构造同步加载树
	 * 
	 */
	public List<ComBoxTreeNode> tree${table.entityName}(Long pid) {
		Map<String, Object> params =  new HashMap<String, Object>();
		params.put("pid", pid);
		List list = bSqlHelper.getMapList("${table.bizpack?replace('com.ustc.','')}.${table.entityName}.select", params);
		return CommTreeUtils.buildTreeNode(list);
	}
}