var ${table.entityName}DataGrid=$('#${table.entityName}_datagrid');
$(function(){
     //流程状态下拉框
	$('#flow_combo').combobox({
		editable : false,
		onChange:function(newV,oldV){
			if(oldV){
				search${table.entityName}();
			}
		}
	});
	init${table.entityName}Grid();
});

function init${table.entityName}Grid(){
	${table.entityName}DataGrid.datagrid({
		height:$("body").height()-200,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		cls:'md',
		queryParams:{
			flowDone:haseasyui('#flow_combo')?$('#flow_combo').combobox('getValue'):"",
			startDate:$('#sDate').datebox('getValue'),
			endDate:$('#eDate').datebox('getValue')
		},
		toolbar:"#${table.entityName}_datagrid_tb",
	    url:ctx+'/${table.entityName}/page${table.entityName}',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="${table.entityName}FormDetail('+row.${table.pkHump}+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    <#list table.columns as po>
	    <#if (po.fieldDic?exists)>
	    {field:'${po.fieldName}',hidden:true},
	    {field:'${po.fieldName}Text',title:'${po.fieldTitle?default(po.fieldName)}',width:100,align:'center',halign:'center',sortable:true}<#if po_has_next >,</#if>
	    <#else>
	    {field:'${po.fieldName}',title:'${po.fieldTitle?default(po.fieldName)}',width:100,align:'center',halign:'center',sortable:true}<#if po_has_next >,</#if>
	    </#if>
	    </#list>
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			${table.entityName}FormDetail(row.${table.pkHump});
	    }
	});
    ${table.entityName}DataGrid.datagrid('doCellTip');
    var pager = ${table.entityName}DataGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('${table.entityName}_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function ${table.entityName}FormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=${table.entityName}&isdetail=true&id="+id
	});
}
//重新加载表格
function reload${table.entityName}(){
	${table.entityName}DataGrid.datagrid('reload');
}
//查询表格
function search${table.entityName}(){
	${table.entityName}DataGrid.datagrid('load',{
	    flowDone:haseasyui('#flow_combo')?$('#flow_combo').combobox('getValue'):"",
		search:$("#search${table.entityName}").val(),
		startDate:$('#sDate').datebox('getValue'),
		endDate:$('#eDate').datebox('getValue'),
		applyPerson: $("#applyPerson").textbox('getValue'),
		applyDept :$("#applyDept").combobox('getValue')
	});
}

//增加记录
function add${table.entityName}() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		submitType : 'single',
		contenturl:"/GenForm/form?formcode=${table.entityName}",
		submiturl:"/${table.entityName}/save${table.entityName}?formcode=${table.entityName}",
		callback:reload${table.entityName}
	});
	
}

//修改记录
function edit${table.entityName}() {
	var row = ${table.entityName}DataGrid.datagrid('getSelected');
	if (row) {
	    if(row.workflowStatus.toString().indexOf('1')==-1){
			alertInfo('数据已经上报过,不能修改');
			return;
		}
		var id = row.${table.pkHump};
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=${table.entityName}&id=" + id,
			submiturl:"/${table.entityName}/save${table.entityName}?formcode=${table.entityName}",
			//onload : "/${table.entityName}/find${table.entityName}?id=" + id,
			callback : reload${table.entityName}
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function del${table.entityName}() {
	var row = ${table.entityName}DataGrid.datagrid('getSelected');
	if (row) {
    if(row.workflowStatus.toString().indexOf('1')==-1){
		alertInfo('数据已经上报过,不能删除');
		return;
	}
		
	var id =row.${table.pkHump};
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/${table.entityName}/del${table.entityName}",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							${table.entityName}DataGrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
function doFlow(){
	var row = ${table.entityName}DataGrid.datagrid('getSelected');
	if (row) {
		if(row.workflowStatus=='3'){
			alertInfo('数据已通过');
			return;
		}
		if(row.workflowStatus=='1'){//起草中,直接调用修改方法
			edit${table.entityName}();
			return ;
		}
		//有消息记录时,利用gotoDetail参数,调用待办审批页面
		openFlowDialog({
    		processInstId:row.processinstid,
			businessMainId:row.${table.pkHump},
			formCode:"${table.entityName}",
			callback:reload${table.entityName},
			gotoDetail:true
        });
	} else {
		alertInfo('请先选择一条数据信息');
	}
}

function viewFlow(){
	var row = ${table.entityName}DataGrid.datagrid('getSelected');
	if (row) {
		viewFlowDialog(row.processinstid)
	} else {
		alertInfo('请先选择一条数据信息');
	}
}