package ${table.bizpack}.controller;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ustc.base.common.exception.GEPSBisException;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.controller.BaseController;
import com.ustc.base.common.util.SysContent;

import ${table.bizpack}.entity.${table.entityName};
import ${table.bizpack}.service.${table.entityName}Service;


/**   
 * @Title: Controller
 * @Description: ${table.description}
 * @author sys
 * @date ${table.date}
 * @version V1.0   
 *
 */
@Controller
@RequestMapping("/${table.entityName}")
public class ${table.entityName}Controller extends BaseController {

	@Autowired
	private ${table.entityName}Service ${table.entityName?uncap_first}Service;

	/**
	 * 分页查询数据,带分页和模糊搜索
	 */
	@RequestMapping(value="/page${table.entityName}",method = RequestMethod.POST)
	@ResponseBody
	public Object page${table.entityName}(HttpServletRequest request,Long flowDone,
	@RequestParam(value="search",defaultValue="") String search,
	@RequestParam(value="page",defaultValue="1") int page,
	@RequestParam(value="rows",defaultValue="50")  int rows,String sort,String order) {
		return ${table.entityName?uncap_first}Service.PageAll(flowDone,search,page,rows,sort,order);
	}

	/**
	 * 查找单条数据
	 */
	@RequestMapping(value = "/find${table.entityName}")
	@ResponseBody
	public Object find${table.entityName}( Long id) {
	    ${table.entityName} entity=${table.entityName?uncap_first}Service.find${table.entityName}(id);
		return entity;
	}


	/**
	 * 保存数据
	 */
	@RequestMapping(value = "/save${table.entityName}")
	@ResponseBody
	public Object save${table.entityName}(HttpServletRequest request,${table.entityName} entity) throws GEPSBisException {
		JsonMsg msg=new JsonMsg();
		entity.setModifyAccount(getLoginUser(request).getAccountid());
		entity.setModifyTime(new Date());
		entity.setIsUse(SysContent.IS_USE_Y);
		if(entity.get${table.pkHump?cap_first}()==null){
			entity.setCreateAccount(getLoginUser(request).getAccountid());
			entity.setCreateTime(new Date());
		}
		${table.entityName?uncap_first}Service.save${table.entityName}(entity);
		
		msg.setO(entity);
		return msg;
	}
	
	
	/**
	 * 删除数据
	 */
	@RequestMapping(value = "/del${table.entityName}")
	@ResponseBody
	public Object del${table.entityName}(Long id) {
		${table.entityName?uncap_first}Service.del${table.entityName}(id);//直接删除
		return new JsonMsg();
		
	}
	/**
	 * 可编辑表格
	 */
	@RequestMapping(value = "/edit${table.entityName}")
	public Object edit${table.entityName}(Model model,Long id) {
		if(id!=null){
			List<Map<String,Object>> list=${table.entityName?uncap_first}Service.findByForeignId(id);//主表ID
			if(list!=null&&list.size()>0){
				model.addAttribute("dataList", list);
			}else{
				model.addAttribute("dataList", null);
			}
		}else{
			model.addAttribute("dataList", null);
		}
		
		return "/${table.bizpack?replace('com.ustc.','')?replace('.','/')}/${table.entityName}";
	}
	
}
