PageAll
===
select @pageTag(){
				a.RES_ID,
				a.BUSINESS_TYPE_ID,
				a.DESIGN_NAME,
				a.DESIGN_NAME as d_name,
				a.MEMO,
				a.MEMO2,
				a.RES_CREATE_DATE,
				a.RES_CREATOR,
				a.RES_EDIT_DATE,
				a.RES_EDITOR,
				a.FLOW_NAME,
				a.TYPE,
				t.name businessTypeName,
				case when a.APPLY_ORGS is null then '公用' else  GETORGNAME(a.APPLY_ORGS) end APPLY_ORGS_name,
				case when a.type='subflow' then '子流程' when a.type='flow' then '主流程' end typeName,
				GETDICNAME('STF_SHARE_TYPE',a.SHARE_TYPE) SHARE_TYPE_TEXT
		
@}
from STF_BUSINESS_PROCESS a left join STF_BUSINESS_type t on t.res_id=a.business_type_id
@where(){ 
	@if(!isEmpty(businessTypeId)){
			and (a.BUSINESS_TYPE_ID=#businessTypeId# or
            a.BUSINESS_TYPE_ID in
           ( with recursive temp 
           as( 
           select ot.* from STF_BUSINESS_type ot where ot.PARENT_ID =#businessTypeId#
           union all 
           select ot.* from STF_BUSINESS_type ot,temp t where t.RES_ID=ot.PARENT_ID
           )
           SELECT RES_ID FROM temp t))
	@}
	@if(!isEmpty(type)){
			and a.type=#type#
	@}
@if(!isEmpty(orgSql)){
#text(orgSql)#
@}
@if(!isEmpty(search)){
and(
 upper(a.RES_ID) like #search#  or 
 upper(a.BUSINESS_TYPE_ID) like #search#  or
 upper(a.DESIGN_NAME) like #search#  or 
 upper(a.MEMO) like #search#  or 
 upper(a.RES_CREATE_DATE) like #search#  or 
 upper(a.RES_CREATOR) like #search#  or 
 upper(a.RES_EDIT_DATE) like #search#  or 
 upper(a.RES_EDITOR) like #search#  or 
 upper(a.FLOW_NAME) like #search#  or 
 upper(a.TYPE) like #search#
)@}
@}
@pageIgnoreTag(){
 order by a.display_no 
@}

findStfBusinessProcess
===
select @pageTag(){
				   t.processdefid,
			       t.processdefname,
			       t.processchname,
			       t.description,
			       t.currentstate,
			       case  t.currentstate when 0 then '未发布' when 3 then '已发布' else '修改中' end currentstateText,
			       t.versionsign,
			       t.limittime,
			       t.createtime,
			       t.creator,
			       t.updatetime,
			       t.updator,
			       '系统管理员' createName
		@}
  from WF_PROCESSDEFINE t
@where(){
	@if(!isEmpty(processdefname)){
			and t.processdefname=#processdefname#
	@}
@}

select
===
with recursive temp as(
	 select a.* from STF_BUSINESS_TYPE a where  a.PARENT_ID = #pid#  
	 union all
	 select a.* from STF_BUSINESS_TYPE a,temp t where t.RES_ID=a.PARENT_ID  )
SELECT
	t.RES_ID id,
	T.PARENT_ID PID,
	t.NAME text 
FROM
	temp t 
ORDER BY
	t.order_index
 
getflowByFlowCatId
===
select t.design_name as id,
       t.design_name as value,
     	concat(t.design_name , '(' , GETORGNAME ( t.APPLY_ORGS ) , t.flow_name , ')') AS text 
  from STF_BUSINESS_PROCESS t
 where (t.BUSINESS_TYPE_ID = #flowCatId#
    or t.BUSINESS_TYPE_ID in
    ( with recursive tmp as 
(select o1.RES_ID from STF_BUSINESS_type o1 where o1.PARENT_ID =#flowCatId#
UNION ALL 
select o2.RES_ID id from STF_BUSINESS_type o2,tmp t  where t.RES_ID = o2.PARENT_ID) 
select *  from tmp p))
@if(!isEmpty(orgId)){
AND ( t.APPLY_ORGS IS NULL OR concat( ',' , t.APPLY_ORGS , ',') LIKE concat( '%,',#orgId#,',%' ))
@}

findWorkFlowPublicVersion
=== 
select p.memo,t.processdefid,
                 t.PROCESSDEFCONTENT,
                 t.processdefname, 
                 t.processchname, 
                 t.description, 
                 t.currentstate, 
		       case  t.currentstate when 0 then '未发布' when 3 then '已发布' else '修改中' end currentstateText,
                 t.versionsign, 
                 t.limittime, 
                 t.createtime, 
                 t.creator, 
                 t.updatetime, 
                 t.updator, 
                 '系统管理员' createName 
            from WF_PROCESSDEFINE t
           left join stf_business_process p on p.design_name=t.processdefname
            where t.processdefname =#processDefName#  and t.currentstate='3'
            
getPList
===
select s.res_id, s.parent_id, s.name, s.order_index,
s.RES_COLOR,s.RES_ICO
  from STF_BUSINESS_TYPE s
 where s.parent_id = #pId#
order by s.order_index asc

commonlyUsedFlow
===
with temp as
 (select a.*, \@rownum:=\@rownum+1 as num
    from (select t.processdefname, count(*)
            from WF_PROCESSDEFINE_PROCESSINST t
           where t.creator = #loginuser.accountid#
           group by t.processdefname
           order by count(*) desc) a,(select \@rownum:=0)x
   limit 10)
select nvl(ff.FORM_CODE, f.FORM_CODE) FORM_CODE,
       nvl(ff.FORM_NAME, f.FORM_NAME) FORM_NAME,
       t.processdefname
  from temp t
  left join gen_form f
    on f.flow_code = t.processdefname
   and f.is_use = 'Y'
  left join gen_form_flow o
    on o.flow_code = t.processdefname
   and o.apply_orgs = #loginuser.orgid#
   and o.is_use = 'Y'
  left join gen_form ff
    on o.form_id = ff.id
 order by t.num

getFormList
===
with a as
 (select p1.org_id
    from bas_emp_account e2, bas_emp e3, hr_emp e1, hr_dept_post p1
   where e2.emp_id = e3.emp_id
     AND e2.is_use = 'Y'
     AND e3.is_use = 'Y'
     and e1.emp_id = e3.hr_emp_id
     AND e1.is_use = 'Y'
     and p1.is_use = 'Y'
     and instr(concat(',' , e1.vice_station , ','), concat(',' , p1.dept_post_id , ',')) != 0
     and e2.account_id = #loginuser.accountid#)
select o.*
  from (select distinct null TEMP_ID,'' EDOC_TYPE,
                        b.form_code,
                        f.form_name,
                        e.menu_ico,
                        y.name pname,
                        y.porder_index,
                        yp.order_index,
                        y.order_index order_index2,
                        ifnull(p2.memo,p.memo) memo,
                        p.display_no order_index3,
                        case when(select count(1)
                                 from BAS_FORM_LINK l
                                where l.form_code = b.form_code
                                  and l.is_use = 'Y'
                                  and l.create_account = #loginuser.accountid#)= 0 then 0 else  1 end link,
                        (
                        with recursive temp as(
								 select a.* from bas_menu a where  a.menu_id =e.menu_id
							 union all
							 select a.* from bas_menu a,temp t where t.menu_id=a.pmenu_id  )
						SELECT t.menu_name  FROM temp t   where T.pmenu_id = 0) pmenuname
          from bas_menu_button b
          left join bas_menu e
            on e.menu_id = b.menu_id
          left join gen_form f
            on f.form_code = b.form_code
           and f.is_use = 'Y'
          left join stf_business_process p
            on p.design_name = f.flow_code
          left join gen_form_flow o
            on o.form_id = f.id
           and comparestr(o.apply_orgs, #loginuser.orgid#) > 0
          left join stf_business_process p2
            on p2.design_name = o.flow_code
          left join (select s.res_id,
                           s.parent_id,
                           s.name,
                           s.order_index,
                            (with recursive temp as( select a.* from STF_BUSINESS_TYPE a where a.res_id=s.res_id union all select a.* from STF_BUSINESS_TYPE a,temp t where a.RES_ID=t.PARENT_ID  )
						SELECT t.order_index FROM temp t where t.parent_id=0) porder_index,
                    (with recursive temp as( select a.* from STF_BUSINESS_TYPE a where a.res_id=s.res_id union all select a.* from STF_BUSINESS_TYPE a,temp t where a.RES_ID=t.PARENT_ID  )
						SELECT t.name FROM temp t where t.parent_id in (select uu.res_id from STF_BUSINESS_TYPE uu where uu.parent_id = 0)) two_name
                      from STF_BUSINESS_TYPE s) y
            on ifnull(p2.business_type_id, p.business_type_id) = y.res_id
          left join STF_BUSINESS_TYPE yp
            on yp.res_id = y.parent_id
         where (b.is_control = 'N' or
               b.button_id in
               (select m.button_id
                   from bas_roles_menu m
                  where m.role_id in
                        (select b.role_Id
                           from Bas_Roles_Account b
                          where b.account_Id = #loginuser.accountid#
                            and ifnull(b.org_id, -99999) = ifnull(m.org_id, -99999)
                            and ifnull(b.dept_id, -99999) =
                            ifnull(m.dept_id, -99999))
                    and m.button_id is not null))
           and b.form_code is not null
           and (f.flow_code is not null or exists
                (select 1
                   from gen_form_flow o
                  where o.form_id = f.id
                    and o.org_id = #loginuser.orgid#
                    and o.is_use = 'Y'))
           and e.is_use = 'Y'
           and e.enable = 'Y'
           @if(!isEmpty(resId)){
           and y.res_id in
               (with recursive temp as(
	 select a.* from STF_BUSINESS_TYPE a where  a.res_id = #resId#
	 union all
	 select a.* from STF_BUSINESS_TYPE a,temp t where t.RES_ID=a.PARENT_ID  )
SELECT t.RES_ID  FROM temp t   )
           @}
           and y.name is not null
           union
        SELECT t.ID TEMP_ID,
               t.template_type,
               'edocApply',
               t.TEMPLATE_NAME FORM_NAME,
               'icon-book' menu_ico,
               y.name pname,
               y.porder_index,
               yp.order_index,
               y.order_index order_index2,
               p.memo memo,
               p.display_no,
              case (select count(1)
                        from BAS_FORM_LINK l
                       where l.form_code = 'edocApply'
                         and l.temp_id = t.id
                         and l.doc_type = t.TEMPLATE_TYPE
                         and l.is_use = 'Y'
                         and l.create_account = #loginuser.accountid#) when 
                       0 then   0 else 1 end link,
               '' pmenuname
          FROM EDOC_TEMPLATE T
          left join stf_business_process p
            on p.design_name = t.flow_code
          left join (select s.res_id,
                            s.parent_id,
                            s.name,
                            s.order_index,
                             (with recursive temp as( select a.* from STF_BUSINESS_TYPE a where a.res_id=s.res_id union all select a.* from STF_BUSINESS_TYPE a,temp t where a.RES_ID=t.PARENT_ID  )
						SELECT t.order_index FROM temp t where t.parent_id=0) porder_index,
                    (with recursive temp as( select a.* from STF_BUSINESS_TYPE a where a.res_id=s.res_id union all select a.* from STF_BUSINESS_TYPE a,temp t where a.RES_ID=t.PARENT_ID  )
						SELECT t.name FROM temp t where t.parent_id in (select uu.res_id from STF_BUSINESS_TYPE uu where uu.parent_id = 0)) two_name
                       from STF_BUSINESS_TYPE s) y
            on p.business_type_id = y.res_id
          left join STF_BUSINESS_TYPE yp
            on yp.res_id = y.parent_id
         WHERE t.IS_USE = 'Y'
           and t.IS_ENABLE = '1'
           and (t.id in
               (select distinct s.main_table_id
                   from EDOC_SCOPE s
                  where s.table_name = 'EDOC_TEMPLATE'
                    and ((s.user_type = 'user' and s.user_id = #loginuser.accountid#) or
                        (s.user_type = 'dept' and s.user_id = #loginuser.deptid#) or
                        (s.user_type = 'org' and s.user_id = #loginuser.orgid#))) or
               t.GRANT_ORGS = #loginuser.orgid# or
               t.GRANT_ORGS in (select a.org_id from a))
           @if(!isEmpty(resId)){
           and y.res_id in
               (with recursive temp as(
	 select a.* from STF_BUSINESS_TYPE a where  a.res_id = #resId#
	 union all
	 select a.* from STF_BUSINESS_TYPE a,temp t where t.RES_ID=a.PARENT_ID  )
SELECT t.RES_ID  FROM temp t   )
           @}
           ) o
 order by o.porder_index, o.order_index, o.order_index2, order_index3
 
findAll
===
SELECT @pageTag(){
	RES_ID as id, FLOW_NAME as text 
@} 
FROM STF_BUSINESS_PROCESS where 1=1
@if(!isEmpty(fuzzy)){
	and flow_name like #fuzzy#
@}
 
 
getFormListNew
===
with a as
 (select p1.org_id
    from bas_emp_account e2, bas_emp e3, hr_emp e1, hr_dept_post p1
   where e2.emp_id = e3.emp_id
     AND e2.is_use = 'Y'
     AND e3.is_use = 'Y'
     and e1.emp_id = e3.hr_emp_id
     AND e1.is_use = 'Y'
     and p1.is_use = 'Y'
     and instr(concat(',' , e1.vice_station , ','), concat(',' , p1.dept_post_id , ',')) != 0
     and e2.account_id = #loginuser.accountid#)
select o.*
  from (select distinct null TEMP_ID,'' EDOC_TYPE,
                        b.form_code,
                        f.form_name,
                        e.menu_ico,
                        y.name pname,
                        y.porder_index,
                        yp.order_index,
                        y.order_index order_index2,
                        ifnull(p2.memo,p.memo) memo,
                        p.display_no order_index3,
                        case when(select count(1)
                                 from BAS_FORM_LINK l
                                where l.form_code = b.form_code
                                  and l.is_use = 'Y'
                                  and l.create_account = #loginuser.accountid#)= 0 then 0 else  1 end link,
                        (with recursive temp as( select a.*,1 lev from STF_BUSINESS_TYPE a where a.res_id=p.BUSINESS_TYPE_ID union all select a.*,t.lev+1 lev from STF_BUSINESS_TYPE a,temp t where a.RES_ID=t.PARENT_ID  )
						SELECT group_concat(t.RES_ID order by t.lev desc) FROM temp t ) pids
          from bas_menu_button b
          left join bas_menu e
            on e.menu_id = b.menu_id
          left join gen_form f
            on f.form_code = b.form_code
           and f.is_use = 'Y'
          left join stf_business_process p
            on p.design_name = f.flow_code
          left join gen_form_flow o
            on o.form_id = f.id
           and comparestr(o.apply_orgs, #loginuser.orgid#) > 0
          left join stf_business_process p2
            on p2.design_name = o.flow_code
          left join (select s.res_id,
                           s.parent_id,
                           s.name,
                           s.order_index,
                            (with recursive temp as( select a.* from STF_BUSINESS_TYPE a where a.res_id=s.res_id union all select a.* from STF_BUSINESS_TYPE a,temp t where a.RES_ID=t.PARENT_ID  )
						SELECT t.order_index FROM temp t where t.parent_id=0) porder_index
                      from STF_BUSINESS_TYPE s) y
            on ifnull(p2.business_type_id, p.business_type_id) = y.res_id
          left join STF_BUSINESS_TYPE yp
            on yp.res_id = y.parent_id
         where (b.is_control = 'N' or
               b.button_id in
               (select m.button_id
                   from bas_roles_menu m
                  where m.role_id in
                        (select b.role_Id
                           from Bas_Roles_Account b
                          where b.account_Id = #loginuser.accountid#
                            and ifnull(b.org_id, -99999) = ifnull(m.org_id, -99999)
                            and ifnull(b.dept_id, -99999) =
                            ifnull(m.dept_id, -99999))
                    and m.button_id is not null))
           and b.form_code is not null
           and (f.flow_code is not null or exists
                (select 1
                   from gen_form_flow o
                  where o.form_id = f.id
                    and o.org_id = #loginuser.orgid#
                    and o.is_use = 'Y'))
           and e.is_use = 'Y'
           and e.enable = 'Y'
           and y.name is not null
  union
        SELECT t.ID TEMP_ID,
               t.template_type,
               'edocApply',
               t.TEMPLATE_NAME FORM_NAME,
               'icon-book' menu_ico,
               y.name pname,
               y.porder_index,
               yp.order_index,
               y.order_index order_index2,
               p.memo memo,
               p.display_no,
              case (select count(1)
                        from BAS_FORM_LINK l
                       where l.form_code = 'edocApply'
                         and l.temp_id = t.id
                         and l.doc_type = t.TEMPLATE_TYPE
                         and l.is_use = 'Y'
                         and l.create_account = #loginuser.accountid#) when 
                       0 then   0 else 1 end link,
                        (with recursive temp as( select a.*,1 lev from STF_BUSINESS_TYPE a where a.res_id=p.BUSINESS_TYPE_ID union all select a.*,t.lev+1 lev from STF_BUSINESS_TYPE a,temp t where a.RES_ID=t.PARENT_ID  )
						SELECT group_concat(t.RES_ID order by t.lev desc) FROM temp t ) pids
          FROM EDOC_TEMPLATE T
          left join stf_business_process p
            on p.design_name = t.flow_code
          left join (select s.res_id,
                            s.parent_id,
                            s.name,
                            s.order_index,
                             (with recursive temp as
                             	( select a.* from STF_BUSINESS_TYPE a where a.res_id=s.res_id 
                             	union all select a.* from STF_BUSINESS_TYPE a,temp t where a.RES_ID=t.PARENT_ID  )
						SELECT t.order_index FROM temp t where t.parent_id=0) porder_index
                       from STF_BUSINESS_TYPE s) y
            on p.business_type_id = y.res_id
          left join STF_BUSINESS_TYPE yp
            on yp.res_id = y.parent_id
         WHERE t.IS_USE = 'Y'
           and t.IS_ENABLE = '1'
           and (t.id in
               (select  s.main_table_id
                   from EDOC_SCOPE s
                  where s.table_name = 'EDOC_TEMPLATE'
                    and ((s.user_type = 'user' and s.user_id = #loginuser.accountid#) or
                        (s.user_type = 'dept' and s.user_id = #loginuser.deptid#) or
                        (s.user_type = 'org' and s.user_id = #loginuser.orgid#))) 
                        )) o
 order by o.porder_index, o.order_index, o.order_index2, order_index3

 
getFlowType        
===
select t.res_id id,
       t.res_id value,
       t.name text
  from STF_BUSINESS_TYPE t
  left join STF_BUSINESS_TYPE p
    on p.res_id = t.parent_id
 where not exists
 (select 1 from STF_BUSINESS_TYPE y where t.res_id = y.parent_id)
 and t.parent_id>0
 order by nvl(p.order_index, t.order_index)
 
findAll
===
SELECT @pageTag(){
	RES_ID as id, FLOW_NAME as text ,DESIGN_NAME as code
@} 
FROM STF_BUSINESS_PROCESS where 1=1
@if(!isEmpty(fuzzy)){
	and flow_name like #fuzzy#
@}

 