findEmpByAccountId
===
select c.*
  from bas_emp_account a, bas_emp b, hr_emp c
 where a.is_use = 'Y'
   and b.is_use = 'Y'
   and c.is_use = 'Y'
   and a.account_id = #accountId#
   and a.emp_id = b.emp_id
   and b.hr_emp_id = c.emp_id
   
queryHrEmpLeaderList
===
SELECT
	a.ACCOUNT_ID AS value,
	a.ACCOUNT_NAME AS text 
FROM
	BAS_EMP_ACCOUNT a 
WHERE
	a.ACCOUNT_ID IN (
	SELECT DISTINCT
		REGEXP_SUBSTR( t.my_leader, '[^,]+', 1, LEVEL ) AS ACCOUNT_ID 
	FROM
		HR_EMP t 
	WHERE
	t.EMP_ID =#empId# CONNECT BY REGEXP_SUBSTR( t.my_leader, '[^,]+', 1, LEVEL ) IS NOT NULL 
	)


getAllContacts
===
select 
t.* ,
e.emp_id bas_emp_id,
CASE
		
WHEN t.MOBILEPHONE IS NOT NULL 
		AND t.is_protect = 'Y' AND #loginuser.accountid# NOT IN ( SELECT
	USER_ID 
FROM
	HR_PROTECT_SCOPT 
WHERE
	USER_TYPE = 'user' 
	AND IS_USE = 'Y' AND EMP_ID=t.EMP_ID UNION
	SELECT ACCOUNT_ID as USER_ID  FROM BAS_EMP_ACCOUNT WHERE DEPT_ID IN(
SELECT
	USER_ID 
FROM
	HR_PROTECT_SCOPT WHERE USER_TYPE = 'dept' 
	AND IS_USE = 'Y' AND  EMP_ID=t.EMP_ID ) UNION 
	SELECT ACCOUNT_ID as USER_ID  FROM BAS_EMP_ACCOUNT WHERE ORG_ID IN(
SELECT
	USER_ID 
FROM
	HR_PROTECT_SCOPT WHERE USER_TYPE = 'org' 
	AND IS_USE = 'Y' AND EMP_ID=t.EMP_ID  ) ) THEN
			concat(substr( t.MOBILEPHONE, 0, 7 ),'****') ELSE t.MOBILEPHONE 
		END MOBILEPHONE_TEXT
from HR_EMP t
left join bas_emp e on e.hr_emp_id=t.emp_id
where t.IS_USE='Y' and t.IS_VISUAL !='Y'
@if(!isEmpty(orgId)){
   and t.ORG_ID=#orgId# or t.DEPT_ID=#orgId#
@}
@if(!isEmpty(userInfo)){
and(
 upper(t.EMP_NAME) like #userInfo#  ESCAPE '/'  or 
 upper(GETDEPTNAME(t.DEPT_ID)) like #userInfo#  ESCAPE '/'  or 
 upper(GETDEPTNAME(t.ORG_ID)) like #userInfo#  ESCAPE '/' 
)@}
order by t.display_no

getAllContacts1
===
SELECT
	t.* ,
CASE
		
WHEN t.MOBILEPHONE IS NOT NULL 
		AND t.is_protect = 'Y' AND #loginuser.accountid# NOT IN ( SELECT
	USER_ID 
FROM
	HR_PROTECT_SCOPT 
WHERE
	USER_TYPE = 'user' 
	AND IS_USE = 'Y' AND EMP_ID=t.EMP_ID UNION
	SELECT ACCOUNT_ID as USER_ID  FROM BAS_EMP_ACCOUNT WHERE DEPT_ID IN(
SELECT
	USER_ID 
FROM
	HR_PROTECT_SCOPT WHERE USER_TYPE = 'dept' 
	AND IS_USE = 'Y' AND  EMP_ID=t.EMP_ID ) UNION 
	SELECT ACCOUNT_ID as USER_ID  FROM BAS_EMP_ACCOUNT WHERE ORG_ID IN(
SELECT
	USER_ID 
FROM
	HR_PROTECT_SCOPT WHERE USER_TYPE = 'org' 
	AND IS_USE = 'Y' AND EMP_ID=t.EMP_ID  ) ) THEN
			concat(substr( t.MOBILEPHONE, 0, 7 ),'****') ELSE t.MOBILEPHONE 
		END MOBILEPHONE_TEXT
FROM
	HR_EMP t
WHERE
	t.IS_USE = 'Y' 
	and  nvl(t.is_visual,'N') = 'N' 
ORDER BY
	t.display_no

findByEmpId
===
select 
t.* ,

CASE
		
WHEN t.MOBILEPHONE IS NOT NULL 
		AND t.is_protect = 'Y' AND #loginuser.accountid# NOT IN ( SELECT
	USER_ID 
FROM
	HR_PROTECT_SCOPT 
WHERE
	USER_TYPE = 'user' 
	AND IS_USE = 'Y' AND EMP_ID=t.EMP_ID UNION
	SELECT ACCOUNT_ID as USER_ID  FROM BAS_EMP_ACCOUNT WHERE DEPT_ID IN(
SELECT
	USER_ID 
FROM
	HR_PROTECT_SCOPT WHERE USER_TYPE = 'dept' 
	AND IS_USE = 'Y' AND  EMP_ID=t.EMP_ID ) UNION 
	SELECT ACCOUNT_ID as USER_ID  FROM BAS_EMP_ACCOUNT WHERE ORG_ID IN(
SELECT
	USER_ID 
FROM
	HR_PROTECT_SCOPT WHERE USER_TYPE = 'org' 
	AND IS_USE = 'Y' AND EMP_ID=t.EMP_ID  ) ) THEN
			concat(substr( t.MOBILEPHONE, 0, 7 ),'****') ELSE t.MOBILEPHONE 
		END MOBILEPHONE_TEXT,
GETDICNAME('EMP_TYPE',t.EMP_TYPE) EMP_TYPE_TEXT,
GETDICNAME('SEX',t.SEX) SEX_TEXT,
b.ABBR,
getdeptname(t.DEPT_ID) dept_name,
getdeptname(t.org_ID) org_name,
e.emp_id bas_emp_id
from HR_EMP t 
left join bas_emp e on e.hr_emp_id=t.emp_id
left join BAS_DEPT b on t.DEPT_ID=b.DEPT_ID
where t.IS_USE='Y' and t.EMP_ID=#empId#
order by t.EMP_NAME

fineByDeptId
===
select t.* ,
SUBSTR(t.EMP_NAME,length(t.EMP_NAME)-1,2) NAME,
getdeptname(t.dept_id) dept_name,
getdeptname(t.org_id) org_name
from HR_EMP t 
where t.IS_USE='Y' and t.DEPT_ID=#deptid#

getMySubColleagues
===
select distinct l.emp_name,l.mobilephone,
getdeptname(l.dept_id) dept_name,
getdeptname(l.org_id) org_name
  from view_emp_leader l
 start with l.leader_account_id = #loginuser.accountid#
connect by nocycle prior l.emp_id = l.leader_emp_id

findEmpById
===
select t.*,
DATE_FORMAT(t.JOIN_ORG_TIME,'%Y-%m-%d') as JOIN_TIME,
DATE_FORMAT(T.WORK_TIME,'%Y-%m-%d') as WORK_DATE,
GETDICNAME('SEX',t.SEX) SEX_TEXT,
DATE_FORMAT(t.TECHNICAL_DAT,'%Y-%m-%d') as TECHNICAL_TIME,
GETDICNAME('MARITAL_STATU',t.MARITAL_STATU) MARITAL_STATU_TEXT,
GETDICNAME('TOP_EDUCATION',t.TOP_EDUCATION) TOP_EDUCATION_TEXT,
DATE_FORMAT(t.BIRTHDAY,'%Y-%m-%d') BIRTHDAY_DATE,
getdicname('NATION',t.`NATION`) NATION_TEXT
from HR_EMP t where t.EMP_ID=#empId#

findEmpByIds
===
select t.*,
getdeptname(t.dept_id) dept_name,
getdeptname(t.org_ID) org_name,
DATE_FORMAT(t.JOIN_ORG_TIME,'%Y-%m-%d') as JOIN_TIME,
DATE_FORMAT(T.WORK_TIME,'%Y-%m-%d') as WORK_DATE,
GETDICNAME('SEX',t.SEX) SEX_TEXT,
DATE_FORMAT(t.TECHNICAL_DAT,'%Y-%m-%d') as TECHNICAL_TIME,
GETDICNAME('MARITAL_STATU',t.MARITAL_STATU) MARITAL_STATU_TEXT,
GETDICNAME('TOP_EDUCATION',t.TOP_EDUCATION) TOP_EDUCATION_TEXT,
DATE_FORMAT(t.BIRTHDAY,'%Y-%m-%d') BIRTHDAY_DATE,
getdicname('NATION',t.`NATION`) NATION_TEXT,
replace((select GROUP_CONCAT(concat(DATE_FORMAT(a.START_TIME,'%Y.%m'),'--',DATE_FORMAT(a.END_TIME,'%Y.%m'),a.graduate_College,a.profession)) from HR_EDUCATION_LIVE a where a.is_use='Y' and a.emp_id=t.emp_id),',',concat('/n','/r')) HR_EDU_DETAIL,
replace((select GROUP_CONCAT(concat(DATE_FORMAT(b.START_TIME,'%Y.%m'),'--',nvl(DATE_FORMAT(b.END_TIME,'%Y.%m'),'至今'),b.work_unit,b.dept_name)) from HR_WORK_LIVE b where b.is_use='Y' and b.emp_id=t.emp_id),',',concat('/n','/r')) HR_WORK_DETAIL,
replace((select GROUP_CONCAT(concat(DATE_FORMAT(c.START_TIME,'%Y.%m'),'--',DATE_FORMAT(c.END_TIME,'%Y.%m'),c.training_org,c.training_content)) from HR_TRAINING_LIVE c where c.is_use='Y' and c.emp_id=t.emp_id ),',',concat('/n','/r')) HR_TRA_DETAIL,
replace((select GROUP_CONCAT(concat(d.member_name,'(',d.relationship,')出生年月:',DATE_FORMAT(d.BIRTHDAY,'%Y.%m'),' 电话:',d.telephone,' 工作单位:',d.company)) from HR_FAMILY_MEMBER d where d.is_use='Y' and d.emp_id=t.emp_id),',',concat('/n','/r')) HR_FAMILY_DETAIL
from HR_EMP t 
left join bas_dept u on u.dept_id=t.dept_id
where t.is_use = 'Y'and t.is_visual is not null
and t.emp_id<>0 and t.emp_name not like '%办公室%'
@if(!isEmpty(empIds)){
and concat(',',#empIds#,',' like '%,',t.emp_id,',%')
@}
@if(!isEmpty(orgName)){
and getdeptname(t.org_ID) = #orgName#
@}
order by u.display_no,t.display_no,t.emp_id
 
findByIdToDetials
===
select t.*,DATE_FORMAT(t.START_TIME,'%Y.%m') START_DATE,DATE_FORMAT(T.END_TIME,'%Y.%m') END_DATE from HR_EDUCATION_LIVE t where t.emp_id=#empId#  and is_use='Y' order by t.START_TIME 

findByIdToTrain
===
select t.*,DATE_FORMAT(t.START_TIME,'%Y.%m') START_DATE,DATE_FORMAT(T.END_TIME,'%Y.%m') END_DATE from HR_TRAINING_LIVE t where t.emp_id=#empId#  and is_use='Y' order by t.START_TIME 

findByIdToWork
===
select t.*,DATE_FORMAT(t.START_TIME,'%Y.%m') START_DATE,DATE_FORMAT(T.END_TIME,'%Y.%m') END_DATE from HR_WORK_LIVE t where t.emp_id=#empId# and is_use='Y' order by t.START_TIME 

findByFamilyDetail
===
select t.*,DATE_FORMAT(BIRTHDAY,'%Y.%m') as BIRTHDAY_DATE from HR_FAMILY_MEMBER t where t.emp_id=#empId#  and is_use='Y'

isHaveTodo
===
SELECT
	COUNT( * ) 
FROM
	BAS_MESSAGE_RECEIVE T
	RIGHT JOIN BAS_MESSAGE A ON T.MSG_ID = A.MSG_ID 
	AND a.is_use = 'Y' 
	AND MSG_TYPE = 1 
WHERE
	T.IS_DEAL = 'N' 
	AND ACCOUNT_ID =#accountId1#

getEmpMobile
===
select t.mobilephone
  from HR_EMP t, bas_emp e, bas_emp_account a
 where e.emp_id = a.emp_id
   and e.hr_emp_id = t.emp_id
   and t.mobilephone is not null
   and a.account_id in ( #join(accountIds)#)
   
getUndoEmpMobileByProcessinstId
===
select t.mobilephone,s.msg_title,s.form_Code,a.account_name,getdeptname(a.dept_id) dept_name,a.account_id
  from HR_EMP              t,
       bas_emp             e,
       bas_emp_account     a,
       bas_message         s,
       bas_message_receive r,
       wf_workitem         w
 where e.emp_id = a.emp_id
   and e.hr_emp_id = t.emp_id
   and s.msg_id = r.msg_id
   and r.account_id = a.account_id
   and w.workitemid = s.workitemid
   and t.mobilephone is not null
   and r.is_deal = 'N'
   and w.activitydefid = #actId#
   and w.processinstid = #processInstId#
 
getCurMonthBirth   
===
select TRUNC((DATE_FORMAT(sysdate, '%Y%m%d') -
             DATE_FORMAT(t.birthday, '%Y%m%d')) / 10000) as age,
       u.client_id,
       a.account_id,
       t.*
  from hr_emp t,
       BAS_EMP E,
       BAS_EMP_ACCOUNT A,
       (select u.account_id,
               u.client_id， rank() over(partition by u.account_id order by u.id desc) rn
          from bas_device_user u) u
 where DATE_FORMAT(t.birthday, '%m-%d') = DATE_FORMAT(sysdate, '%m-%d')
   and t.emp_id = e.hr_emp_id
   and e.emp_id = a.emp_id
   and u.account_id = a.account_id
   AND E.IS_USE = 'Y'
   and a.is_use = 'Y'
   and t.is_use = 'Y'
   and u.rn = 1

getCurMonthEntry
===
select TRUNC((DATE_FORMAT(sysdate, '%Y%m%d') -
             DATE_FORMAT(t.entry_Time, '%Y%m%d')) / 10000) as age,
       u.client_id,
       a.account_id,
       t.*
  from hr_emp t,
       BAS_EMP E,
       BAS_EMP_ACCOUNT A,
       (select u.account_id,
               u.client_id， rank() over(partition by u.account_id order by u.id desc) rn
          from bas_device_user u) u
 where DATE_FORMAT(t.entry_Time, '%m-%d') = DATE_FORMAT(sysdate, '%m-%d')
   and t.emp_id = e.hr_emp_id
   and e.emp_id = a.emp_id
   and u.account_id = a.account_id
   AND E.IS_USE = 'Y'
   and a.is_use = 'Y'
   and t.is_use = 'Y'
   and u.rn = 1
   
findByEmpName
===
select count(1) from hr_emp t where t.is_use='Y'  
AND T.EMP_NAME=#empName#

findByEmpName1
===
select t.* from hr_emp t,bas_dept a  where t.is_use='Y'  AND T.EMP_NAME=#empName#  and  t.dept_id=a.dept_id   
@if(!isEmpty(deptName)){
    AND  a.dept_name=#deptName#
@}
 and limit 0,1

findAccountId
===
select account_id from bas_emp_account where is_use='Y' AND  EMP_ID  in( #join(empIds)#) 

findEmpByAccountIds
===
SELECT t1.account_id,
        t.emp_id,
       t.dept_id,
       getdeptname(t.dept_id) dept_id_text,
       t.emp_code,
       t.emp_level,
       t1.account_name,
       t.emp_name,
       t.emp_type,
       t.emp_property,
       t.id_card,
       t.org_id,
       (SELECT bo.abbr FROM bas_org bo WHERE bo.org_id = t.org_id) org_id_text,
       t.remark,
       t.`status`,
       t.native_place,
       t.marital_statu,
       t.domicile_place,
       t.home_addr,
       t.birth_palce,
       t.political_stat,
       t.top_education,
       t.graduate_coll,
       t.profession,
       t.passport_no,
       t.entry_time,
       t.emp_no,
       t.postive_time,
       t.mobilephone,
       t.telephone,
       t.spare_phone,
       t.email,
       t.postal_code,
       t.org_job,
       t.present_job,
       t.serving_time,
       t.station,
       t.technical_dat,
       t.technical,
       t.vice_station,
       t.social_securit,
       t.wage_card,
       t.internal_tel,
       t.level_change,
       t.station_level,
       t.photo_version_id,
       t.rank,
       t.is_visual,
       t.bank_name,
       t.bank_code,
       t.archives_room,
       t.archives_no,
       t.contact_org_id,
       t.is_edit,
       t.display_no,
       t.is_use,
       t.create_account,
       t.create_time,
       t.modify_account,
       t.modify_time,
       t.processinstid,
       t.workflow_status,
       t.my_leader,
       t.is_protect,
       t.record_id,
       t.join_org_time,
       DATE_FORMAT(t.join_org_time, '%Y-%m-%d %T') AS join_time,
       t.work_time,
       DATE_FORMAT(t.work_time, '%Y-%m-%d %T') AS work_date,
       t.sex,
       getdicname('SEX', t.sex) sex_text,
       t.birthday,
       DATE_FORMAT(t.birthday, '%Y-%m-%d %T') birthday_date,
       t.`nation`,
       getdicname('NATION', t.`nation`) nation_text
FROM  bas_emp_account t1
LEFT   JOIN bas_emp e
ON     e.emp_id = t1.emp_id
       AND e.is_use = 'Y'
LEFT   JOIN hr_emp t
ON     t.emp_id = e.hr_emp_id
       AND t.is_use = 'Y'
WHERE t1.is_use = 'Y'  

@if(!isEmpty(accountIds)){
    AND  t1.account_id IN (#join(accountIds)# )
@}




getMaxJobLevel
===
select
	ifnull(min(ifnull(if( length(trim(p.JOB_LEVEL))>0,p.JOB_LEVEL,null),'4')),4)
from
	hr_emp e,
	hr_post p,
	bas_emp b,
	bas_emp_account a 
where a.account_id=#accountId#
	and e.EMP_ID = b.HR_EMP_ID 
	and a.emp_id = b.emp_id 
	and concat(',', e.PRESENT_JOB, ',') like concat('%,', p.POST_ID, ',%')
	and p.JOB_LEVEL is not null  
