select
===
with tmp as
 (select TT.TYPE_ID,
         group_concat(concat(tt.user_type,':',tt.user_id) ORDER BY tt.type_id) user_id,
         group_concat((case
                   when tt.user_type = 'dept' then
                    getdeptname(tt.user_id)
                   when tt.user_type = 'org' then
                    getbaseabbr(tt.user_id)
                   when tt.user_type = 'user' then
                    getaccountname(tt.user_id)
                 end) ORDER BY tt.type_id) user_name
    from GM_INFO_TYPE_MANAGERS tt
   where tt.is_use = 'Y'
   @if(!isEmpty(type)){
    and ((tt.user_type = 'org' and tt.user_id = #org#) or
         (tt.user_type = 'dept' and tt.user_id = #dept#) or
         (tt.user_type = 'user' and tt.user_id = #accountid#))
   @}
   group by tt.type_id)
select @pageTag(){
				t.TYPE_ID,
		t.TYPE_NAME,
		t.IS_APPROVAL,
		GETDICNAME('IS_OR_NOT',t.IS_APPROVAL) IS_APPROVAL_TEXT,
		t.FLOW_CODE,
		t.REMIND_DAY,
		t.PRINT_SETUP,
		GETDICNAME('GM_PRINT_SETUP',t.PRINT_SETUP) PRINT_SETUP_TEXT,
		t.IS_READING_PEOPLE,
		GETDICNAME('IS_OR_NOT',t.IS_READING_PEOPLE) IS_READING_PEOPLE_TEXT,
		t.IS_RELEASE_PEOPLE,
		GETDICNAME('IS_OR_NOT',t.IS_RELEASE_PEOPLE) IS_RELEASE_PEOPLE_TEXT,
		t.TOP_NUMBER,
		t.INFO_TYPE,
		GETDICNAME('GM_INFO_TYPE',t.INFO_TYPE) INFO_TYPE_TEXT,
		GETBASEABBR(t.ORG_ID)ORG_ID_name,
		GETDICNAME('IS_OR_NOT',t.SYSTEM_PRESET) SYSTEM_PRESET_TEXT,
		t.SYSTEM_PRESET,
		t.CREATE_ACCOUNT,
		t.CREATE_TIME,
		t.MODIFY_ACCOUNT,
		t.MODIFY_TIME,
		t.IS_USE,
       p.user_id,
       p.user_name
	 @}
from GM_INFO_TYPE t, tmp p
 where t.is_use = 'Y' and t.type_id = p.type_id
  @if(isEmpty(orgId)){
 	  @if(isEmpty(isAdmin)){
          and ((t.INFO_TYPE='2' and t.ORG_ID=#org#) or t.INFO_TYPE='1') 
 	  @}
  @}
  @if(!isEmpty(orgIdVal)){
   	 and t.ORG_ID = #orgIdVal#
    @}

@if(!isEmpty(search)){
and(
 upper(t.TYPE_NAME) like #search# ESCAPE '/'   or 
 upper(t.FLOW_CODE) like #search# ESCAPE '/'   or 
 upper(t.REMIND_DAY) like #search# ESCAPE '/'   or 
 upper(GETDICNAME('GM_PRINT_SETUP',t.PRINT_SETUP)) like #search# ESCAPE '/'   or 
 upper(t.TOP_NUMBER) like #search# ESCAPE '/'   or 
 upper(GETDICNAME('GM_INFO_TYPE',t.INFO_TYPE)) like #search# ESCAPE '/'   or 
 upper(GETBASEABBR(t.ORG_ID)) like #search# ESCAPE '/'   or 
 upper(t.SYSTEM_PRESET) like #search# ESCAPE '/' 
)@}
@if(!isEmpty(flowsql)){
#text(flowsql)#
@}
@pageIgnoreTag(){
	@if(isEmpty(sort)){
   	 order by t.TYPE_ID desc
    @}
    @if(!isEmpty(sort)){
   	 order by #text(sort)# #text(order)#
    @}
@}


infoTypeTree
===
SELECT 	t.TYPE_ID id, 
     	t.TYPE_NAME text 
 FROM 	GM_INFO_TYPE t
 where t.is_use = 'Y'


getInfoTypeListForSearch
===
select t.TYPE_ID,
       t.TYPE_NAME,
       t.IS_APPROVAL,
       GETDICNAME('IS_OR_NOT', t.IS_APPROVAL) IS_APPROVAL_TEXT,
       t.FLOW_CODE,
       t.REMIND_DAY,
       t.PRINT_SETUP,
       GETDICNAME('GM_PRINT_SETUP', t.PRINT_SETUP) PRINT_SETUP_TEXT,
       t.IS_READING_PEOPLE,
       GETDICNAME('IS_OR_NOT', t.IS_READING_PEOPLE) IS_READING_PEOPLE_TEXT,
       t.IS_RELEASE_PEOPLE,
       GETDICNAME('IS_OR_NOT', t.IS_RELEASE_PEOPLE) IS_RELEASE_PEOPLE_TEXT,
       t.TOP_NUMBER,
       t.INFO_TYPE,
       GETDICNAME('GM_INFO_TYPE', t.INFO_TYPE) INFO_TYPE_TEXT,
       t.ORG_ID,
       GETBASEABBR(t.ORG_ID) ORG_ID_name,
       GETDICNAME('IS_OR_NOT', t.SYSTEM_PRESET) SYSTEM_PRESET_TEXT,
       t.SYSTEM_PRESET,
       t.CREATE_ACCOUNT,
       t.CREATE_TIME,
       t.MODIFY_ACCOUNT,
       t.MODIFY_TIME,
       t.IS_USE
 from GM_INFO_TYPE t
  where t.is_use = 'Y'
 @if(isEmpty(isAdmin)){
    and ((t.INFO_TYPE='2' and t.ORG_ID=#orgId#) or t.INFO_TYPE='1')
 @}

getInfoTypeList
===
with tmp as
 (select TT.TYPE_ID,
          group_concat(concat(tt.user_type , ':' , tt.user_id), ',' ORDER BY tt.type_id) user_id,
          group_concat((case
                   when tt.user_type = 'dept' then
                    getdeptname(tt.user_id)
                   when tt.user_type = 'org' then
                    getbaseabbr(tt.user_id)
                   when tt.user_type = 'user' then
                    getaccountname(tt.user_id)
                 end) ORDER BY tt.type_id) user_name
    from GM_INFO_TYPE_MANAGERS tt
   where tt.is_use = 'Y'
     and ((tt.user_type = 'org' and tt.user_id in (with recursive temp as( select a.* from view_bas_org_bizdept a where  a.id = #org# union all select a.* from view_bas_org_bizdept a,temp t where t.id=a.pid)SELECT id FROM temp t )) or
         (tt.user_type = 'dept' and tt.user_id in (with recursive temp as( select a.* from view_bas_org_bizdept a where  a.id = #dept# union all select a.* from view_bas_org_bizdept a,temp t where t.id=a.pid)SELECT id FROM temp t )) or
         (tt.user_type = 'user' and tt.user_id = #accountid#))
   group by tt.type_id)
select t.TYPE_ID,
       t.TYPE_NAME,
       t.IS_APPROVAL,
       GETDICNAME('IS_OR_NOT', t.IS_APPROVAL) IS_APPROVAL_TEXT,
       t.FLOW_CODE,
       t.REMIND_DAY,
       t.PRINT_SETUP,
       GETDICNAME('GM_PRINT_SETUP', t.PRINT_SETUP) PRINT_SETUP_TEXT,
       t.IS_READING_PEOPLE,
       GETDICNAME('IS_OR_NOT', t.IS_READING_PEOPLE) IS_READING_PEOPLE_TEXT,
       t.IS_RELEASE_PEOPLE,
       GETDICNAME('IS_OR_NOT', t.IS_RELEASE_PEOPLE) IS_RELEASE_PEOPLE_TEXT,
       t.TOP_NUMBER,
       t.INFO_TYPE,
       GETDICNAME('GM_INFO_TYPE', t.INFO_TYPE) INFO_TYPE_TEXT,
       GETBASEABBR(t.ORG_ID) ORG_ID_name,
       GETDICNAME('IS_OR_NOT', t.SYSTEM_PRESET) SYSTEM_PRESET_TEXT,
       t.SYSTEM_PRESET,
       t.CREATE_ACCOUNT,
       t.CREATE_TIME,
       t.MODIFY_ACCOUNT,
       t.MODIFY_TIME,
       t.IS_USE,
       p.user_id,
       p.user_name,
       CASE
			WHEN p.user_id = '' THEN
			'N' when p.user_id is null then 'N'  ELSE 'Y' 
		END is_add 
  from GM_INFO_TYPE t
  left join tmp p
    on t.type_id = p.type_id
 where t.is_use = 'Y'
 @if(!isEmpty(typeId)){
    and t.type_id=#typeId#
 @}
 @if(isEmpty(isAdmin)){
    and ((t.INFO_TYPE='2' and t.ORG_ID=#org#) or t.INFO_TYPE='1')
 @}