/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.workflow.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.ComBoxTreeNode;
import com.ustc.base.common.util.ComboxNode;
import com.ustc.base.common.util.ComboxUtils;
import com.ustc.base.common.util.CommTreeUtils;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.service.BasMenuService;
import com.ustc.workflow.dao.StfBusinessProcessDao;
import com.ustc.workflow.entity.StfBusinessProcess;
import com.ustc.workflow.entity.WfProcessDefine;
import com.ustc.workflow.entity.WfProcessdefineProcessinst;
import com.ustc.workflow.service.FlowUtilService;
import com.ustcsoft.usiflow.core.util.PrimaryKeyUtil;
import com.ustcsoft.usiflow.engine.model.ProcessDefine;
import com.ustcsoft.usiflow.engine.service.IProcessDefineService;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class StfBusinessProcessService {
    private static final Logger logger = Logger.getLogger(StfBusinessProcessService.class);
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private StfBusinessProcessDao dao;
    @Autowired
    private FlowUtilService flowUtilservice;
    @Autowired
    private BasMenuService basMenuService;

    public StfBusinessProcess save(StfBusinessProcess stf) {
        stf = (StfBusinessProcess)this.dao.save(stf);
        return stf;
    }

    public StfBusinessProcess update(StfBusinessProcess stf) {
        stf = (StfBusinessProcess)this.dao.save(stf);
        return stf;
    }

    public void delete(StfBusinessProcess stf) {
        this.dao.deleteById(stf.getBusinessTypeId());
    }

    public StfBusinessProcess find(Long id) {
        return (StfBusinessProcess)this.dao.findById(id).get();
    }

    public List<StfBusinessProcess> findByText(String text) {
        return this.dao.findByText(text);
    }

    public List<StfBusinessProcess> findByDesignName(String designName) {
        return this.dao.findByDesignName(designName);
    }

    public List<StfBusinessProcess> findByBusinessTypeId(Object businessTypeId) {
        return this.dao.findByBusinessTypeId(Long.parseLong(businessTypeId.toString()));
    }

    public List<StfBusinessProcess> findAll(String flowName, String designName, String type, String levels) {
        StringBuilder sqlStr = new StringBuilder("SELECT a.*,t.name businessTypeName,decode(a.type,'subflow','\u5b50\u6d41\u7a0b','flow','\u4e3b\u6d41\u7a0b') typeName FROM STF_BUSINESS_PROCESS A ");
        sqlStr.append("left join STF_BUSINESS_type t on t.res_id=a.business_type_id where 1=1");
        if (flowName != null && !"".equals(flowName)) {
            sqlStr.append(" and a.flow_name like '%" + flowName + "%' ");
        }
        if (designName != null && !"".equals(designName)) {
            sqlStr.append(" and a.design_name like '%" + designName + "%' ");
        }
        if (designName != null && !"".equals(designName)) {
            sqlStr.append(" and a.type=" + type);
        }
        if (StringUtils.isNotBlank((CharSequence)levels)) {
            sqlStr.append(" and t.levels=" + levels);
        }
        sqlStr.append(" order by a.res_id asc");
        return this.sqlHelper.queryByNativeSQL(sqlStr.toString(), StfBusinessProcess.class, new int[0]);
    }

    public StfBusinessProcess getCurrentInfo() {
        StfBusinessProcess businessProcess = null;
        try {
            String sql = "select max(res_id) from STF_BUSINESS_PROCESS";
            Object ob = this.sqlHelper.getSingal(sql);
            if (ob != null) {
                Long maxid = Long.valueOf(ob.toString());
                businessProcess = (StfBusinessProcess)this.dao.findById(maxid).get();
            }
        }
        catch (Exception re) {
            logger.error((Object)"\u83b7\u53d6\u5f53\u524d\u4fe1\u606f\u9519\u8bef!", (Throwable)re);
        }
        return businessProcess;
    }

    public String queryFlowContent(Long id, Long processinstid) {
        if (processinstid != null) {
            String queryString = "select * from WF_PROCESSDEFINE_PROCESSINST t where t.processinstid=?1\n";
            WfProcessdefineProcessinst wf = (WfProcessdefineProcessinst)this.sqlHelper.getSingal(queryString, new Object[]{processinstid}, WfProcessdefineProcessinst.class);
            return StringUtils.isNotBlank((CharSequence)wf.getOriprocessdefcontent()) ? wf.getOriprocessdefcontent() : wf.getProcessdefcontent();
        }
        String sql = "select * from WF_PROCESSDEFINE where processdefid = ?1";
        WfProcessDefine wf = (WfProcessDefine)this.sqlHelper.getSingal(sql, new Object[]{id}, WfProcessDefine.class);
        return wf.getProcessDefContent();
    }

    public String queryBaseFlowContent(Long id, Long processinstid) {
        if (processinstid != null) {
            String queryString = "select t.* from WF_PROCESSDEFINE t where t.processdefid = (select a.processdefid from WF_PROCESSINST a where a.processinstid=?1)";
            WfProcessDefine wf = (WfProcessDefine)this.sqlHelper.getSingal(queryString, new Object[]{processinstid}, WfProcessDefine.class);
            return wf.getProcessDefContent();
        }
        String sql = "select * from WF_PROCESSDEFINE where processdefid = ?1 ";
        WfProcessDefine wf = (WfProcessDefine)this.sqlHelper.getSingal(sql, new Object[]{id}, WfProcessDefine.class);
        return wf.getProcessDefContent();
    }

    public List<?> queryWorkFlowVersion(String processDefName) {
        String sql = "select t.processdefid,\n       t.processdefname,\n       t.processchname,\n       t.description,\n       t.currentstate,\n       case when t.currentstate=0 then '\u672a\u53d1\u5e03' when t.currentstate=3 then '\u5df2\u53d1\u5e03' else '\u4fee\u6539\u4e2d' end currentstateText,\n       t.versionsign,\n       t.limittime,\n       t.createtime,\n       t.creator,\n       t.updatetime,\n       t.updator,\n       '\u7cfb\u7edf\u7ba1\u7406\u5458' createName\n  from WF_PROCESSDEFINE t\n  where t.processdefname = ?1";
        return this.sqlHelper.queryByNativeSQL(sql, new Object[]{processDefName}, new int[0]);
    }

    public Map queryWorkFlowPublicVersion(String processDefName) {
        String sql = "select p.memo,t.processdefid,\n       t.processdefname,\n       t.processchname,\n       t.description,\n       t.currentstate,\n       case when t.currentstate=0 then '\u672a\u53d1\u5e03' when t.currentstate=3 then '\u5df2\u53d1\u5e03' else '\u4fee\u6539\u4e2d' end currentstateText,\n       t.versionsign,\n       t.limittime,\n       t.createtime,\n       t.creator,\n       t.updatetime,\n       t.updator,\n       '\u7cfb\u7edf\u7ba1\u7406\u5458' createName\n  from WF_PROCESSDEFINE t\n left join stf_business_process p on p.design_name=t.processdefname\n  where t.processdefname = ?1 and t.currentstate='3' ";
        List list = this.sqlHelper.queryByNativeSQL(sql, new Object[]{processDefName}, new int[0]);
        if (list.isEmpty()) {
            return null;
        }
        return (Map)list.get(0);
    }

    public List<ProcessDefine> findWorkFlowPublicVersion(String processDefName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((CharSequence)processDefName)) {
            params.put("processDefName", processDefName);
        }
        return this.bSqlHelper.getList("workflow.StfBusinessProcess.findWorkFlowPublicVersion", params, ProcessDefine.class);
    }

    public List<Map<String, Object>> queryWorkFlowVersion(String nodeType, Long typeId) {
        String sql = "select t.processdefid id,\n       t.processdefname process_Def_Name,\n       t.processchname,\n       t.description,\n       t.currentstate current_State,\n       case when t.currentstate =0 then '\u672a\u53d1\u5e03' when t.currentstate=3 then '\u5df2\u53d1\u5e03' else '\u4fee\u6539\u4e2d' end currentstateText,\n       t.versionsign version_Sign,\n       t.limittime,\n       t.createtime,\n       t.creator,\n       t.updatetime,\n       t.updator,\n       '\u7cfb\u7edf\u7ba1\u7406\u5458' createName\n  from WF_PROCESSDEFINE t\n  where t.processdefname = ?1 order by t.processdefid ";
        return this.sqlHelper.queryByNativeSQL(sql, new Object[]{nodeType + "." + typeId}, new int[0]);
    }

    List<StfBusinessProcess> findByBusinessTypeId(Long businessTypeId) {
        return this.dao.findByBusinessTypeId(businessTypeId);
    }

    public String getFlowNameByProcessInstId(Long processInstId) {
        String sql = "SELECT t.flow_name\n  FROM stf_business_process t,\n       wf_processinst       p,\n       wf_processdefine     d\n WHERE p.processinstid = " + processInstId + "\n   AND d.processdefid = p.processdefid\n   AND d.processdefname = t.design_name";
        String flowName = null;
        Object ob = this.sqlHelper.getSingal(sql);
        if (ob != null) {
            flowName = this.sqlHelper.getSingal(sql).toString();
        }
        return flowName;
    }

    public PageObject PageAll(String businessTypeId, String search, String type, int page, int rows) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((CharSequence)businessTypeId)) {
            params.put("businessTypeId", businessTypeId);
        }
        if (!StringUtils.isEmpty((CharSequence)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((CharSequence)type)) {
            params.put("type", type);
        }
        params.put("orgSql", SysUtils.getCreateConnectSql("a.RES_CREATOR"));
        return this.bSqlHelper.serachPage("workflow.StfBusinessProcess.PageAll", params);
    }

    public void saveStfBusinessProcess(StfBusinessProcess entity) {
        this.dao.save(entity);
    }

    public void delStfBusinessProcess(Long id) {
        this.dao.deleteById(id);
    }

    public List<ComBoxTreeNode> treeStfBusinessType(Long pid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pid", pid);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("workflow.StfBusinessProcess.select", params);
        return CommTreeUtils.buildTreeNode(list);
    }

    public void delProcessDefine(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("PROCESSDEFID", id);
        this.bSqlHelper.updateOrDelete("workflow.ProcessDefine.del", params);
    }

    public void pubProcessDefine(Long id, String flowCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("flowCode", flowCode);
        this.bSqlHelper.updateOrDelete("workflow.ProcessDefine.pubbefore", params);
        params.put("PROCESSDEFID", id);
        this.bSqlHelper.updateOrDelete("workflow.ProcessDefine.pub", params);
    }

    public void cancelProcessDefine(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("PROCESSDEFID", id);
        this.bSqlHelper.updateOrDelete("workflow.ProcessDefine.cancel", params);
    }

    public List<ComboxNode> getflowByFlowCatId(Long flowCatId, String orgId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("flowCatId", flowCatId);
        if (StringUtils.isNotBlank((CharSequence)orgId)) {
            params.put("orgId", orgId);
        }
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("workflow.StfBusinessProcess.getflowByFlowCatId", params);
        return ComboxUtils.buildComboxNodes(list);
    }

    public List<Map<String, Object>> getFlowFormItem(String flowCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("flowCode", flowCode);
        return this.bSqlHelper.getMapList("workflow.flow.getFlowFormItem", params);
    }

    public StfBusinessProcess copyStfBusinessProcess(Long id) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException, ParseException {
        StfBusinessProcess newEntity = new StfBusinessProcess();
        if (id != null) {
            StfBusinessProcess entity = (StfBusinessProcess)this.dao.findById(id).get();
            BeanUtils.copyProperties((Object)entity, (Object)newEntity, (String[])new String[]{"id", "text", "designName"});
            this.dao.save(newEntity);
            newEntity.setDesignName(entity.getType() + "." + String.valueOf(newEntity.getId()));
            newEntity.setText(entity.getText() + String.valueOf(newEntity.getId()));
            this.update(newEntity);
            List<ProcessDefine> details = this.findWorkFlowPublicVersion(entity.getDesignName());
            if (details != null && details.size() > 0) {
                for (ProcessDefine detail : details) {
                    ProcessDefine ProcessDefine2 = new ProcessDefine();
                    BeanUtils.copyProperties((Object)detail, (Object)ProcessDefine2, (String[])new String[]{"processDefId", "processCHName", "processDefName"});
                    ProcessDefine2.setProcessDefId(PrimaryKeyUtil.getPrimaryKey((String)"BusinessUsiFlow").longValue());
                    ProcessDefine2.setProcessDefContent(detail.getProcessDefContent());
                    ProcessDefine2.setProcessCHName(newEntity.getText());
                    ProcessDefine2.setProcessDefName(newEntity.getType() + "." + String.valueOf(newEntity.getId()));
                    IProcessDefineService iProcessDefineService = this.flowUtilservice.getProcessEngine().getProcessDefineService();
                    iProcessDefineService.insertProcessDefine(ProcessDefine2);
                }
            }
        }
        return newEntity;
    }

    public List<Map<String, Object>> getPList() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pId", 0);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("workflow.StfBusinessProcess.getPList", params);
        List<Map<String, Object>> formlist = this.bSqlHelper.getMapList("workflow.StfBusinessProcess.getFormListNew", params);
        HashMap level2map = new HashMap();
        formlist.stream().forEach(map -> {
            if (map.get("pids") != null) {
                String[] pids = map.get("pids").toString().split(",");
                String level2Id = null;
                if (pids.length >= 2) {
                    level2Id = pids[1];
                    if (level2map.get(level2Id) == null) {
                        level2map.put(level2Id, new ArrayList());
                    }
                    ((List)level2map.get(level2Id)).add(map);
                }
            }
        });
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> map2 = list.get(i);
            params.put("pId", map2.get("resId"));
            List<Map<String, Object>> dtlList = this.bSqlHelper.getMapList("workflow.StfBusinessProcess.getPList", params);
            if (dtlList.size() > 0) {
                for (int j = 0; j < dtlList.size(); ++j) {
                    Map<String, Object> map1 = dtlList.get(j);
                    if (map1.get("resId") == null) continue;
                    List formList = (List)level2map.get(map1.get("resId").toString());
                    if (formList != null && formList.size() > 0) {
                        map1.put("dtlList", formList);
                        continue;
                    }
                    dtlList.remove(j--);
                }
            } else {
                HashMap<String, Object> map1 = new HashMap<String, Object>();
                map1.put("resId", map2.get("resId").toString());
                map1.put("name", map2.get("name").toString());
                params.put("resId", map2.get("resId"));
                List<Map<String, Object>> dtlList1 = this.bSqlHelper.getMapList("workflow.StfBusinessProcess.getFormList", params);
                if (dtlList1.size() > 0) {
                    map1.put("dtlList", dtlList1);
                    dtlList.add(map1);
                } else {
                    list.remove(i--);
                }
            }
            if ("\u5408\u540c\u7ba1\u7406\u7c7b".equals(map2.get("name"))) {
                Map<Object, Object> conlist = null;
                for (Map<String, Object> conmap : dtlList) {
                    if (!"\u5408\u540c\u7b7e\u8ba2".equals(map2.get("name"))) continue;
                    conlist = conmap;
                }
                if (conlist == null) {
                    conlist = new HashMap<String, String>();
                    conlist.put("name", "\u5408\u540c\u7b7e\u8ba2");
                }
                ArrayList conlistdetail = new ArrayList(3);
                Subject currentUser = SecurityUtils.getSubject();
                if (currentUser.isPermitted("/PmPmconType/findPmPmconFormIcons")) {
                    HashMap<String, String> consign = new HashMap<String, String>();
                    consign.put("formName", "\u5408\u540c\u5f55\u5165");
                    consign.put("formCode", "&pmSign&");
                    consign.put("url", "/PmPmconType/findPmPmconFormIcons");
                    consign.put("memo", "\u5408\u540c\u5f55\u5165");
                    conlistdetail.add(consign);
                }
                if (currentUser.isPermitted("/PmPmconType/findPmPmconFormIconsAlt")) {
                    HashMap<String, String> conchange = new HashMap<String, String>();
                    conchange.put("formName", "\u5408\u540c\u53d8\u66f4");
                    conchange.put("formCode", "&pmChange&");
                    conchange.put("url", "/PmPmconType/findPmPmconFormIconsAlt");
                    conchange.put("memo", "\u5408\u540c\u53d8\u66f4");
                    conlistdetail.add(conchange);
                }
                if (!conlistdetail.isEmpty()) {
                    dtlList.add(0, conlist);
                }
                conlist.put("dtlList", conlistdetail);
            }
            map2.put("dtlList", dtlList);
        }
        return list;
    }

    public List<Map<String, Object>> commonlyUsedFlow() {
        return this.bSqlHelper.getMapList("workflow.StfBusinessProcess.commonlyUsedFlow", new HashMap<String, Object>());
    }

    public Object findAll(String fuzzy, int page, int rows) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((CharSequence)fuzzy)) {
            params.put("fuzzy", "%" + fuzzy + "%");
        }
        return this.bSqlHelper.serachPage("workflow.StfBusinessProcess.findAll", params, PageRequest.of((int)page, (int)rows));
    }
}

