/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.sys.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.service.BasMessageService;
import com.ustc.doc.entity.FormFileBean;
import com.ustc.doc.service.DocFormFileService;
import com.ustc.gen.util.DBPropertyUtil;
import com.ustc.sys.dao.SysExternalAccountApplyDao;
import com.ustc.sys.entity.SysExternalAccountApply;
import com.ustc.workflow.service.FlowUtilService;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class SysExternalAccountApplyService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasMessageService msgService;
    @Autowired
    private SysExternalAccountApplyDao sysexternalaccountapplyDao;
    @Autowired
    private DocFormFileService docFormFileService;
    @Autowired
    private FlowUtilService flowUtilService;

    public SysExternalAccountApply findSysExternalAccountApply(Long id) {
        SysExternalAccountApply entity = (SysExternalAccountApply)this.sysexternalaccountapplyDao.getOne(id);
        return entity;
    }

    public void saveSysExternalAccountApply(SysExternalAccountApply entity) {
        this.sysexternalaccountapplyDao.save(entity);
    }

    public void saveSysExternalAccountApply(SysExternalAccountApply entity, FormFileBean formfile) {
        this.sysexternalaccountapplyDao.save(entity);
        if (formfile != null) {
            formfile.setPrimaryKey(entity.getExternalAccountApplyId());
            formfile.setAccountid(entity.getModifyAccount());
            this.docFormFileService.SaveFormFileBean(formfile);
        }
    }

    public void delSysExternalAccountApply(Long id) {
        SysExternalAccountApply entity = (SysExternalAccountApply)this.sysexternalaccountapplyDao.getOne(id);
        entity.setIsUse("N");
        entity.setModifyTime(new Date());
        this.sysexternalaccountapplyDao.save(entity);
        this.msgService.delMydealByProcessinstid(entity.getProcessinstid(), id.toString());
    }

    public PageObject PageAll(Long flowDone, String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (flowDone != null) {
            params.put("flowsql", " and t.processinstid in (" + this.flowUtilService.queryDealedProcess(flowDone) + ") \n");
        } else {
            params.put("flowsql", " and t.workflow_status='3' \n");
        }
        return this.bSqlHelper.searchPage("sys.SysExternalAccountApply.select", params, PageRequest.of((int)page, (int)rows));
    }

    public Map<String, Object> findOneById(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (id != null) {
            params.put("id", id);
        }
        return this.bSqlHelper.getMap("sys.SysExternalAccountApply.findOneById", params);
    }
}

