/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.sys.service;

import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.service.CommonService;
import com.ustc.sys.dao.BasCourtDao;
import com.ustc.sys.entity.BasCourt;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasCourtService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasCourtDao bascourtDao;

    public BasCourt findBasCourt(Long id) {
        BasCourt entity = (BasCourt)this.bascourtDao.findById(id).get();
        return entity;
    }

    public void saveBasCourt(BasCourt entity) {
        this.bascourtDao.save(entity);
    }

    public void delBasCourt(Long id) {
        this.bascourtDao.deleteById(id);
    }

    public PageObject PageAll(String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        String sql = "select t.*,DATE_FORMAT(t.Modify_Time,'%Y-%m-%d %H:%i:%s') Modify_Time_F,r.region_name, \n (SELECT a.ACCOUNT_NAME \n          FROM BAS_EMP_ACCOUNT a \n         WHERE a.account_id = t.modify_account) AS MODIFY_ACCOUNT_NAME \n from BAS_COURT t\n  left join BAS_REGION r\n    on t.region_id = r.region_id \n where t.is_use = 'Y' order by t.DISPLAY_NO,t.COURT_ID \n";
        if (!StringUtils.isEmpty((String)search)) {
            sql = "select t.*,DATE_FORMAT(t.Modify_Time,'%Y-%m-%d %H:%i:%s') Modify_Time_F,r.region_name, \n (SELECT a.ACCOUNT_NAME \n          FROM BAS_EMP_ACCOUNT a \n         WHERE a.account_id = t.modify_account) AS MODIFY_ACCOUNT_NAME \n from BAS_COURT t\n  left join BAS_REGION r\n    on t.region_id = r.region_id \n where t.is_use = 'Y' and  (upper(t.COURT_ID) like ?1  or upper(t.COURT_NAME) like ?1  or upper(t.REGION_ID) like ?1  or upper(t.COURT_ADDR) like ?1  or upper(t.CONTACT_MAN) like ?1  or upper(t.CONTACT_NUMBER) like ?1  or upper(t.DISPLAY_NO) like ?1  or upper(t.STATUS) like ?1  or upper(t.MODIFY_ACCOUNT) like ?1  or upper(t.MODIFY_TIME) like ?1  or upper(t.IS_USE) like ?1)  order by t.DISPLAY_NO,t.COURT_ID";
            pageobject = this.sqlHelper.pagerNativeSQL(sql, new Object[]{"%" + search.toUpperCase() + "%"}, page, rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql, page, rows);
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("STATUS", "DATA_STATUS");
        dicmapper.put("IS_USE", "IS_USE");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }
}

