/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.sys.controller;

import com.ustc.base.common.util.ComBoxTreeNode;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.LoginUser;
import com.ustc.base.controller.BaseController;
import com.ustc.sys.entity.BasRegion;
import com.ustc.sys.service.BasRegionService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/BasRegion"})
public class BasRegionController
extends BaseController {
    @Autowired
    private BasRegionService basregionService;

    @RequestMapping(value={"/pageBasRegion"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageBasRegion(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows) {
        return this.basregionService.PageAll(search, page, rows);
    }

    @RequestMapping(value={"/findBasRegion"})
    @ResponseBody
    public Object findBasRegion(Long id) {
        return this.basregionService.findBasRegion(id);
    }

    @RequestMapping(value={"/saveBasRegion"})
    @ResponseBody
    public Object saveBasRegion(HttpServletRequest request, BasRegion entity) {
        LoginUser user = this.getLoginUser(request);
        JsonMsg msg = new JsonMsg();
        entity.setModifyAccount(user.getAccountid());
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        this.basregionService.saveBasRegion(entity);
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/delBasRegion"})
    @ResponseBody
    public Object delBasRegion(Long id) {
        BasRegion entity = this.basregionService.findBasRegion(id);
        this.basregionService.delBasRegion(id);
        this.basregionService.saveBasRegion(entity);
        return new JsonMsg();
    }

    @RequestMapping(value={"/treeBasRegionWithRoot"})
    @ResponseBody
    public Object treeBasRegionWithRoot(@RequestParam(value="pid", defaultValue="0") Long pid, Long detailId) {
        ComBoxTreeNode root = new ComBoxTreeNode();
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        if (detailId != null) {
            BasRegion basRegion = this.basregionService.findBasRegion(detailId);
            root.setId(detailId.toString());
            root.setText(basRegion.getRegionName());
            root.setChecked(true);
            list.add(root);
            return list;
        }
        List<ComBoxTreeNode> treelist = this.basregionService.treeBasRegion(pid);
        root.setId("0");
        root.setText("\u5730\u533a");
        root.setChecked(false);
        root.setChildren(treelist);
        list.add(root);
        return list;
    }

    @RequestMapping(value={"/treeBasRegionAndMaHouseBuilding"})
    @ResponseBody
    public Object treeBasRegionAndMaHouseBuilding(@RequestParam(value="pid", defaultValue="0") Long pid) {
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        ComBoxTreeNode root = new ComBoxTreeNode();
        List<ComBoxTreeNode> treelist = this.basregionService.treeBasRegionAndMaHouseBuilding(pid);
        root.setId("0");
        root.setText("\u5730\u533a\u53ca\u697c\u5b87");
        root.setChecked(false);
        root.setChildren(treelist);
        list.add(root);
        return list;
    }

    @RequestMapping(value={"/treeBasRegion"})
    @ResponseBody
    public Object treeBasRegion(@RequestParam(value="pid", defaultValue="0") Long pid, String detailId) {
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        ComBoxTreeNode root = new ComBoxTreeNode();
        if (StringUtils.isNotEmpty((String)detailId) && !detailId.equals("null")) {
            String regionName = this.basregionService.getRegionNameByIds(detailId);
            root.setId(detailId.toString());
            root.setText(regionName);
            root.setChecked(true);
            list.add(root);
            return list;
        }
        return this.basregionService.treeBasRegion(pid);
    }

    @RequestMapping(value={"/delBasRegionAndChild"})
    @ResponseBody
    public Object delBasRegionAndChild(Long id) {
        this.basregionService.delBasRegionAndChild(id);
        return new JsonMsg();
    }
}

