/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.sys.controller;

import com.ustc.base.common.util.ComBoxTreeNode;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.LoginUser;
import com.ustc.base.controller.BaseController;
import com.ustc.sys.entity.BasFundSource;
import com.ustc.sys.service.BasFundSourceService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/BasFundSource"})
public class BasFundSourceController
extends BaseController {
    @Autowired
    private BasFundSourceService basfundsourceService;

    @RequestMapping(value={"/pageBasFundSource"})
    @ResponseBody
    public Object pageBasFundSource(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows) {
        return this.basfundsourceService.PageAll(search, page, rows);
    }

    @RequestMapping(value={"/findBasFundSource"})
    @ResponseBody
    public Object findBasFundSource(Long id) {
        return this.basfundsourceService.findBasFundSource(id);
    }

    @RequestMapping(value={"/saveBasFundSource"})
    @ResponseBody
    public Object saveBasFundSource(HttpServletRequest request, BasFundSource entity) {
        LoginUser user = this.getLoginUser(request);
        JsonMsg msg = new JsonMsg();
        entity.setModifyAccount(user.getAccountid());
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        this.basfundsourceService.saveBasFundSource(entity);
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/delBasFundSource"})
    @ResponseBody
    public Object delBasFundSource(Long id, Long userId) {
        BasFundSource entity = this.basfundsourceService.findBasFundSource(id);
        entity.setIsUse("N");
        entity.setModifyAccount(userId);
        entity.setModifyTime(new Date());
        this.basfundsourceService.saveBasFundSource(entity);
        return new JsonMsg();
    }

    @RequestMapping(value={"/treeBasFundSourceWithRoot"})
    @ResponseBody
    public Object treeBasFundSourceWithRoot(@RequestParam(value="pid", defaultValue="0") Long pid, String isRepay) {
        List<ComBoxTreeNode> treelist = this.basfundsourceService.treeBasFundSource(pid, isRepay, null);
        ComBoxTreeNode root = new ComBoxTreeNode();
        root.setId("0");
        root.setText("\u6839\u8282\u70b9");
        root.setChecked(false);
        root.setChildren(treelist);
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        list.add(root);
        return list;
    }

    @RequestMapping(value={"/treeBasFundSourceWithRootPart"})
    @ResponseBody
    public Object treeBasFundSourceWithRootPart(@RequestParam(value="pid", defaultValue="0") Long pid, String pids) {
        List<ComBoxTreeNode> treelist = this.basfundsourceService.treeBasFundSourcePart(pids);
        ComBoxTreeNode root = new ComBoxTreeNode();
        root.setId("0");
        root.setText("\u6839\u8282\u70b9");
        root.setChecked(false);
        root.setChildren(treelist);
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        list.add(root);
        return list;
    }

    @RequestMapping(value={"/treeBasFundSource"})
    @ResponseBody
    public Object treeBasFundSource(@RequestParam(value="pid", defaultValue="0") Long pid, String isRepay, String pids, Long detailId) {
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        ComBoxTreeNode root = new ComBoxTreeNode();
        if (detailId != null) {
            BasFundSource fundSource = this.basfundsourceService.findBasFundSource(detailId);
            root.setId(detailId.toString());
            root.setText(fundSource.getFundSource());
            root.setChecked(true);
            list.add(root);
            return list;
        }
        return this.basfundsourceService.treeBasFundSource(pid, isRepay, pids);
    }

    @RequestMapping(value={"/getBasFundSourceComb"})
    @ResponseBody
    public Object getBasFundSourceComb(String isRepay, String fundSourceType, String isdetail) {
        return this.basfundsourceService.getBasFundSourceComb(isRepay, fundSourceType, isdetail);
    }

    @RequestMapping(value={"/delBasFundSourceAndChild"})
    @ResponseBody
    public Object delBasFundSourceAndChild(Long id) {
        this.basfundsourceService.delBasFundSourceAndChild(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/treeBasFundSourceAllot"})
    @ResponseBody
    public Object treeBasFundSourceAllot(@RequestParam(value="orgid", defaultValue="0") Long orgid) {
        return this.basfundsourceService.treeBasFundSourceAllot(orgid);
    }

    @RequestMapping(value={"/queryFundSourceMonth"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryFundSourceMonth(HttpServletRequest request, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, Long orgId, String month) {
        return this.basfundsourceService.queryFundSourceMonth(orgId, month, search, page, rows);
    }

    @RequestMapping(value={"/countFundSourceMonth"}, method={RequestMethod.POST})
    @ResponseBody
    public Object countFundSourceMonth(HttpServletRequest request, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, Long orgId, String month) {
        return this.basfundsourceService.countFundSourceMonth(orgId, month, search, page, rows);
    }
}

