/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.sys.controller;

import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.LoginUser;
import com.ustc.base.controller.BaseController;
import com.ustc.sys.entity.BasCourt;
import com.ustc.sys.entity.BasRegion;
import com.ustc.sys.service.BasCourtService;
import com.ustc.sys.service.BasRegionService;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/BasCourt"})
public class BasCourtController
extends BaseController {
    @Autowired
    private BasCourtService bascourtService;
    @Autowired
    private BasRegionService basregionService;

    @RequestMapping(value={"/pageBasCourt"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageBasCourt(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows) {
        return this.bascourtService.PageAll(search, page, rows);
    }

    @RequestMapping(value={"/findBasCourt"})
    @ResponseBody
    public Object findBasCourt(Long id) {
        BasCourt court = this.bascourtService.findBasCourt(id);
        BasRegion region = this.basregionService.findBasRegion(court.getRegionId());
        court.setRegionId(region.getRegionId());
        court.setRegionName(region.getRegionName());
        return court;
    }

    @RequestMapping(value={"/saveBasCourt"})
    @ResponseBody
    public Object saveBasCourt(HttpServletRequest request, BasCourt entity) {
        LoginUser user = this.getLoginUser(request);
        JsonMsg msg = new JsonMsg();
        entity.setModifyAccount(user.getAccountid());
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        this.bascourtService.saveBasCourt(entity);
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/delBasCourt"})
    @ResponseBody
    public Object delBasCourt(Long id, Long userId) {
        BasCourt entity = this.bascourtService.findBasCourt(id);
        entity.setIsUse("N");
        entity.setModifyAccount(userId);
        entity.setModifyTime(new Date());
        this.bascourtService.saveBasCourt(entity);
        return new JsonMsg();
    }
}

