/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.report.service;

import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.service.CommonService;
import com.ustc.report.dao.ReportBaseChartDao;
import com.ustc.report.entity.ReportBaseChart;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class ReportBaseChartService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private ReportBaseChartDao reportbasechartDao;

    public ReportBaseChart findReportBaseChart(Long id) {
        ReportBaseChart entity = (ReportBaseChart)this.reportbasechartDao.findById(id).get();
        return entity;
    }

    public void saveReportBaseChart(ReportBaseChart entity) {
        this.reportbasechartDao.save(entity);
    }

    public void delReportBaseChart(Long id) {
        ReportBaseChart entity = (ReportBaseChart)this.reportbasechartDao.findById(id).get();
        entity.setIsUse("N");
        this.reportbasechartDao.save(entity);
    }

    public PageObject PageAll(Long reportId, String search, int page, int rows, String sort, String order) {
        PageObject pageobject = new PageObject();
        if (reportId == null) {
            return pageobject;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select t.*,d.ds_name ds_id_TEXT_  ");
        sql.append(" from REPORT_BASE_CHART t  ");
        sql.append(" left join  REPORT_BASE_DS d on d.id=t.ds_id  ");
        sql.append(" where t.is_use=:isUse ");
        sql.append(" and t.report_Id=:reportId ");
        params.put("isUse", "Y");
        params.put("reportId", reportId);
        if (!StringUtils.isEmpty((String)search)) {
            sql.append(" and  (");
            sql.append("  upper(t.CHART_TYPE) like :search ");
            sql.append(" or upper(t.CLASS_FIELD) like :search ");
            sql.append(" or upper(t.NAME_FIELD) like :search ");
            sql.append(" or upper(t.VALUE_FIELD) like :search ");
            sql.append(" or upper(t.CHART_TILE) like :search ");
            sql.append(" or upper(t.LABEL_FORMATTER) like :search ");
            sql.append(" or upper(t.LABEL_ALIGN) like :search ");
            sql.append(" or upper(t.CHART_OPTIONS) like :search ");
            sql.append(") ");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.ID");
        if (StrKit.notBlank(sort)) {
            String exesql = "select * from (" + sql.toString() + ") " + SysUtils.genOrderBy(sort, order);
            pageobject = this.sqlHelper.pagerNativeSQL(exesql, params, (Integer)page, (Integer)rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("CHART_TYPE", "chartType");
        dicmapper.put("IS_STACK", "IS_OR_NOT");
        dicmapper.put("IS_3D", "IS_OR_NOT");
        dicmapper.put("LEGEND_ALIGN", "align");
        dicmapper.put("LABEL_ALIGN", "align");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }
}

