/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.pub.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.service.BasMessageService;
import com.ustc.doc.entity.FormFileBean;
import com.ustc.doc.service.DocFormFileService;
import com.ustc.gen.util.DBPropertyUtil;
import com.ustc.pub.dao.PubContractDao;
import com.ustc.pub.entity.PubContract;
import com.ustc.pub.service.PubContactOrgService;
import com.ustc.workflow.service.FlowUtilService;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class PubContractService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasMessageService msgService;
    @Autowired
    private PubContractDao pubcontractDao;
    @Autowired
    private DocFormFileService docFormFileService;
    @Autowired
    private FlowUtilService flowUtilService;
    @Autowired
    private PubContactOrgService pubContactOrgService;

    public PubContract findPubContract(Long id) {
        PubContract entity = (PubContract)this.pubcontractDao.findById(id).get();
        entity.setOtherCompanysText(this.pubContactOrgService.getOtherPartsText(entity.getOtherCompanys()));
        return entity;
    }

    public void savePubContract(PubContract entity) {
        this.pubcontractDao.save(entity);
    }

    public void savePubContract(PubContract entity, FormFileBean formfile) {
        this.pubcontractDao.save(entity);
        if (formfile != null) {
            formfile.setPrimaryKey(entity.getId());
            formfile.setAccountid(entity.getModifyAccount());
            this.docFormFileService.SaveFormFileBean(formfile);
        }
    }

    public void delPubContract(Long id) {
        PubContract entity = (PubContract)this.pubcontractDao.findById(id).get();
        entity.setIsUse("N");
        entity.setModifyTime(new Date());
        this.pubcontractDao.save(entity);
        this.msgService.delMydealByProcessinstid(entity.getProcessinstid(), id.toString());
    }

    public PageObject PageAll(String isAdd, Long flowDone, String search, int page, int rows, String sort, String order, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)isAdd)) {
            params.put("isAdd", isAdd);
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (flowDone != null) {
            params.put("flowsql", " and t.processinstid in (" + this.flowUtilService.queryDealedProcess(flowDone) + ") \n");
        } else {
            params.put("flowsql", " and t.workflow_status='3' \n");
        }
        if (!StringUtils.isEmpty((String)type)) {
            params.put("type", type);
        }
        return this.bSqlHelper.serachPage("pub.PubContract.select", params, PageRequest.of((int)page, (int)rows));
    }
}

