/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.pub.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.service.BasMessageService;
import com.ustc.doc.entity.FormFileBean;
import com.ustc.doc.service.DocFormFileService;
import com.ustc.gen.util.DBPropertyUtil;
import com.ustc.pub.dao.PubContactOrgBlockDao;
import com.ustc.pub.entity.PubContactOrg;
import com.ustc.pub.entity.PubContactOrgBlock;
import com.ustc.pub.service.PubContactOrgService;
import com.ustc.workflow.service.FlowUtilService;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class PubContactOrgBlockService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasMessageService msgService;
    @Autowired
    private PubContactOrgBlockDao pubcontactorgblockDao;
    @Autowired
    private DocFormFileService docFormFileService;
    @Autowired
    private FlowUtilService flowUtilService;
    @Autowired
    private PubContactOrgService pubContactOrgService;

    public PubContactOrgBlock findPubContactOrgBlock(Long id) {
        PubContactOrgBlock entity = (PubContactOrgBlock)this.pubcontactorgblockDao.findById(id).get();
        return entity;
    }

    public void savePubContactOrgBlock(PubContactOrgBlock entity) {
        this.pubcontactorgblockDao.save(entity);
    }

    public void savePubContactOrgBlock(PubContactOrgBlock entity, FormFileBean formfile) {
        this.pubcontactorgblockDao.save(entity);
        if (formfile != null) {
            formfile.setPrimaryKey(entity.getContactOrgBlockId());
            formfile.setAccountid(entity.getModifyAccount());
            this.docFormFileService.SaveFormFileBean(formfile);
        }
    }

    public void delPubContactOrgBlock(Long id) {
        PubContactOrgBlock entity = (PubContactOrgBlock)this.pubcontactorgblockDao.findById(id).get();
        entity.setIsUse("N");
        entity.setModifyTime(new Date());
        this.pubcontactorgblockDao.save(entity);
        this.msgService.delMydealByProcessinstid(entity.getProcessinstid(), id.toString());
    }

    public PageObject PageAll(Long flowDone, String search, int page, int rows, String sort, String order, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (!StringUtils.isEmpty((String)type)) {
            if ("1".equals(type)) {
                params.put("operateType", "1");
                params.put("type", "1");
            } else if ("2".equals(type)) {
                params.put("operateType", "1");
                params.put("type", "2");
            } else if ("3".equals(type)) {
                params.put("operateType", "2");
                params.put("type", "1");
            } else if ("4".equals(type)) {
                params.put("operateType", "2");
                params.put("type", "2");
            }
        }
        if (flowDone != null) {
            params.put("flowsql", " and t.processinstid in (" + this.flowUtilService.queryDealedProcess(flowDone) + ") \n");
        } else {
            params.put("flowsql", " and t.workflow_status='3' \n");
        }
        return this.bSqlHelper.serachPage("pub.PubContactOrgBlock.select", params, PageRequest.of((int)page, (int)rows));
    }

    public void writeContactTypeBack(Long processinstid) throws IllegalAccessException, InvocationTargetException {
        List<PubContactOrgBlock> list = this.pubcontactorgblockDao.findByProcessinstid(processinstid);
        if (list.isEmpty()) {
            return;
        }
        PubContactOrgBlock altEntity = list.get(0);
        if (altEntity.getContactOrgId() == null) {
            return;
        }
        PubContactOrg entity = this.pubContactOrgService.findPubContactOrg(altEntity.getContactOrgId());
    }
}

