/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.pub.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.service.BasMessageService;
import com.ustc.doc.entity.FormFileBean;
import com.ustc.doc.service.DocFormFileService;
import com.ustc.gen.util.DBPropertyUtil;
import com.ustc.pub.dao.PubAdviceFeedbackDao;
import com.ustc.pub.entity.PubAdviceFeedback;
import com.ustc.workflow.service.FlowUtilService;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class PubAdviceFeedbackService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasMessageService msgService;
    @Autowired
    private PubAdviceFeedbackDao pubadvicefeedbackDao;
    @Autowired
    private DocFormFileService docFormFileService;
    @Autowired
    private FlowUtilService flowUtilService;

    public PubAdviceFeedback findPubAdviceFeedback(Long id) {
        PubAdviceFeedback entity = (PubAdviceFeedback)this.pubadvicefeedbackDao.findById(id).get();
        return entity;
    }

    public void savePubAdviceFeedback(PubAdviceFeedback entity) {
        this.pubadvicefeedbackDao.save(entity);
    }

    public void savePubAdviceFeedback(PubAdviceFeedback entity, FormFileBean formfile) {
        this.pubadvicefeedbackDao.save(entity);
        if (formfile != null) {
            formfile.setPrimaryKey(entity.getAdviceFeedbackId());
            formfile.setAccountid(entity.getModifyAccount());
            this.docFormFileService.SaveFormFileBean(formfile);
        }
    }

    public void delPubAdviceFeedback(Long id) {
        PubAdviceFeedback entity = (PubAdviceFeedback)this.pubadvicefeedbackDao.findById(id).get();
        entity.setIsUse("N");
        entity.setModifyTime(new Date());
        this.pubadvicefeedbackDao.save(entity);
        this.msgService.delMydealByProcessinstid(entity.getProcessinstid(), id.toString());
    }

    public PageObject PageAll(Long flowDone, String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (flowDone != null) {
            params.put("flowsql", " and t.processinstid in (" + this.flowUtilService.queryDealedProcess(flowDone) + ") \n");
        }
        return this.bSqlHelper.serachPage("pub.PubAdviceFeedback.select", params, PageRequest.of((int)page, (int)rows));
    }
}

