/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.pub.controller;

import com.ustc.base.common.exception.GEPSBisException;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.LoginUser;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysContent;
import com.ustc.base.controller.BaseController;
import com.ustc.doc.entity.FormFileBean;
import com.ustc.pub.dao.PubContactDao;
import com.ustc.pub.dao.PubContactOrgAccountDao;
import com.ustc.pub.dao.PubContactOrgDao;
import com.ustc.pub.entity.PubArea;
import com.ustc.pub.entity.PubContactOrg;
import com.ustc.pub.entity.PubContactOrgAccount;
import com.ustc.pub.entity.PubContactOrgType;
import com.ustc.pub.service.PubAreaService;
import com.ustc.pub.service.PubContactOrgService;
import com.ustc.pub.service.PubContactOrgTypeService;
import com.ustc.workflow.service.FlowUtilService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/PubContactOrg"})
public class PubContactOrgController
extends BaseController {
    @Autowired
    private PubContactOrgService pubContactOrgService;
    @Autowired
    private FlowUtilService flowUtilService;
    @Autowired
    private PubContactOrgTypeService pubContactOrgTypeService;
    @Autowired
    private PubAreaService pubareaService;
    @Autowired
    private PubContactDao pubContactDao;
    @Autowired
    private PubContactOrgAccountDao pubContactOrgAccountDao;
    @Autowired
    private PubContactOrgDao pubContactOrgDao;

    @RequestMapping(value={"/pagePubContactOrg"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pagePubContactOrg(HttpServletRequest request, Long flowDone, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String sort, String order, Long contactOrgTypeId, String type, String contactType) {
        return this.pubContactOrgService.PageAll(flowDone, search, page, rows, sort, order, contactOrgTypeId, type, contactType);
    }

    @RequestMapping(value={"/findPubContactOrg"})
    @ResponseBody
    public Object findPubContactOrg(Long id) {
        PubContactOrg entity = this.pubContactOrgService.findPubContactOrg(id);
        if (entity != null) {
            PubArea area;
            PubContactOrgType type;
            if (entity.getContactOrgTypeId() != null && (type = this.pubContactOrgTypeService.findPubContactOrgType(entity.getContactOrgTypeId())) != null) {
                entity.setContactOrgTypeId_TEXT_(type.getContactOrgTypeName());
            }
            if (entity.getAreaId() != null && (area = this.pubareaService.findPubArea(entity.getAreaId())) != null) {
                entity.setAreaId_TEXT_(area.getAreaFullName());
            }
        }
        return entity;
    }

    @RequestMapping(value={"/toOrgAccountPage"})
    public String toOrgAccountPage(Long id, Model model) {
        if (id != null) {
            List<Map<String, Object>> dataPCOAList = this.pubContactOrgService.findByContactOrgId(id);
            model.addAttribute("dataPCOAList", dataPCOAList);
        }
        return "business/pm/PubContactOrgAccount";
    }

    @RequestMapping(value={"/savePubContactOrg"})
    @ResponseBody
    public Object savePubContactOrg(HttpServletRequest request, PubContactOrg entity, FormFileBean formfile, String formcode) throws GEPSBisException {
        LoginUser user = this.getLoginUser(request);
        Long id = entity.getContactOrgId();
        entity.setContactOrgName(StrKit.replaceAllBlank(entity.getContactOrgName()));
        entity.setContactOrgName(StrKit.replaceChSign(entity.getContactOrgName()));
        JsonMsg msg = this.pubContactOrgService.checkrepeat(entity);
        if (!msg.isSuccess()) {
            return msg;
        }
        entity.setModifyAccount(user.getAccountid());
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        entity = this.pubContactOrgService.savePubContactOrg(entity, formfile);
        if (id == null || entity.getProcessinstid() == null) {
            Long processinstid = this.flowUtilService.createAndStartProcess(user.getAccountid(), formcode, entity.getContactOrgId());
            entity.setProcessinstid(processinstid);
        }
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/delPubContactOrg"})
    @ResponseBody
    public Object delPubContactOrg(Long id) {
        this.pubContactOrgService.delPubContactOrg(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/pullPubContactOrg"})
    @ResponseBody
    public Object pullPubContactOrg(HttpServletRequest request, Long id, String formcode) throws GEPSBisException {
        LoginUser user = this.getLoginUser(request);
        JsonMsg msg = new JsonMsg();
        if (id != null) {
            this.flowUtilService.createAndStartProcess(this.getLoginUser(request).getAccountid(), formcode, id);
            PubContactOrg entity = this.pubContactOrgService.findPubContactOrg(id);
            msg.setO(entity);
        } else {
            msg.setMsg("\u8bf7\u5148\u9009\u62e9\u6765\u5f80\u5355\u4f4d\u6570\u636e");
            msg.setSuccess(false);
        }
        return msg;
    }

    @RequestMapping(value={"/initFLow"})
    @ResponseBody
    public Object initFLow(HttpServletRequest request, Long contactOrgId, String formcode) throws GEPSBisException {
        LoginUser user = this.getLoginUser(request);
        JsonMsg msg = new JsonMsg();
        if (contactOrgId != null) {
            PubContactOrg entity = this.pubContactOrgService.findPubContactOrg(contactOrgId);
            if (entity.getProcessinstid() == null || SysContent.DEFAULT_STATUS.equals(entity.getWorkflowStatus())) {
                this.flowUtilService.createAndStartProcess(user.getAccountid(), formcode, entity.getContactOrgId());
            }
            entity = this.pubContactOrgService.findPubContactOrg(contactOrgId);
            msg.setO(entity);
        } else {
            msg.setMsg("\u8bf7\u5148\u9009\u62e9\u5f80\u6765\u5355\u4f4d\u6570\u636e");
            msg.setSuccess(false);
        }
        return msg;
    }

    @RequestMapping(value={"/pagePubContactOrgSelWin"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pagePubContactOrgSelWin(HttpServletRequest request, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="type", defaultValue="1") String type, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="100") int rows, @RequestParam(value="pubContactOrgIds", defaultValue="") String pubContactOrgIds, String sort, String order, Long contactOrgTypeId, Long contactOrgTypeCode) {
        return this.pubContactOrgService.PageAllSelWin(type, pubContactOrgIds, search, page, rows, sort, order, contactOrgTypeId, contactOrgTypeCode);
    }

    @RequestMapping(value={"/pagePubContactBlockSelWin"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pagePubContactBlockSelWin(HttpServletRequest request, String contactOrgTypeId, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="type", defaultValue="1") String type, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="100") int rows, String sort, String order) {
        return this.pubContactOrgService.pagePubContactBlockSelWin(contactOrgTypeId, type, search, page, rows, sort, order);
    }

    @RequestMapping(value={"/findPubContactOrgTypeByPubContactOrgId"})
    @ResponseBody
    public PubContactOrgType findPubContactOrgTypeByPubContactOrgId(Long id) {
        return this.pubContactOrgService.findPubContactOrgTypeByPubContactOrgId(id);
    }

    @RequestMapping(value={"/pageContactOrg"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageContactOrg(HttpServletRequest request, Long conId, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String sort, String order) {
        return this.pubContactOrgService.pageContactOrg(conId, search, page, rows, sort, order);
    }

    @RequestMapping(value={"/judgeContact"})
    @ResponseBody
    public Object judgeContact(Long id) {
        JsonMsg msg = new JsonMsg();
        PubContactOrg entity = (PubContactOrg)this.pubContactOrgDao.findById(id).get();
        List<PubContactOrgAccount> contacts = this.pubContactOrgAccountDao.findByContactOrgIdAndIsUseAndWorkflowStatus(id, "Y", SysContent.PASS_STATUS);
        if (contacts != null && contacts.size() > 0) {
            Long count = this.pubContactOrgService.countContact(id);
            if (count > 0L) {
                if ("Y".equals(entity.getIsDefaultLoaded())) {
                    msg.setSuccess(true);
                } else {
                    msg.setSuccess(false);
                    msg.setMsg("\u672c\u8bb0\u5f55\u5df2\u88ab\u5408\u540c\u9009\u7528\uff0c\u5f53\u62a5\u8d26\u65f6\uff0c\u662f\u5426\u9ed8\u8ba4\u52a0\u8f7d\u6b64\u8bb0\u5f55\u4e2d\u7684\u8d26\u53f7\uff1f");
                }
            } else {
                msg.setSuccess(true);
            }
        }
        return msg;
    }

    @RequestMapping(value={"/checkContactOrgData"})
    @ResponseBody
    public Object checkContactOrgData(HttpServletRequest request, String orgName, String contactOrgCode, String type, Long contactOrgId) throws GEPSBisException {
        orgName = StrKit.replaceAllBlank(orgName);
        contactOrgCode = StrKit.replaceChSign(contactOrgCode);
        JsonMsg msg = this.pubContactOrgService.checkContactOrgData(orgName, contactOrgCode, type, contactOrgId);
        return msg;
    }

    @RequestMapping(value={"/getContractOrgByCon"}, method={RequestMethod.POST})
    @ResponseBody
    public Object gegContractOrgByCon(HttpServletRequest request, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="100") int rows, String sort, String order, String currentLat, String currentLng, String distance, String type) {
        return this.pubContactOrgService.getContractOrgByCon(currentLat, currentLng, distance, type, search, page, rows, sort, order);
    }
}

