/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.gen.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.ComboxNode;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.StrKit;
import com.ustc.gen.dao.GenPanelGroupDao;
import com.ustc.gen.entity.GenPanelGroup;
import com.ustc.gen.entity.GenPanelItem;
import com.ustc.gen.service.GenPanelItemService;
import com.ustc.gen.util.DBPropertyUtil;
import com.ustc.sys.util.ListUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class GenPanelGroupService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private GenPanelGroupDao genPanelGroupDao;
    @Autowired
    private GenPanelItemService genpanelitemService;

    public GenPanelGroup findGenPanelGroup(String id) {
        GenPanelGroup entity = (GenPanelGroup)this.genPanelGroupDao.findById(id).get();
        return entity;
    }

    public List<GenPanelGroup> findByPanelId(String panelId) {
        return this.genPanelGroupDao.findByPanelIdAndIsUseOrderByDisplayNo(panelId, "Y");
    }

    public void saveGenPanelGroup(GenPanelGroup entity) {
        this.genPanelGroupDao.save(entity);
    }

    public void saveGenPanelGroup(GenPanelGroup entity, String groupItems) {
        entity = (GenPanelGroup)this.genPanelGroupDao.save(entity);
        if (StrKit.notNull(groupItems)) {
            String groupId = entity.getGroupId();
            JSONArray rows = JSON.parseArray((String)groupItems);
            for (Object o : rows) {
                Map row = (Map)o;
                if (!StrKit.notNull(new Object[0])) continue;
                GenPanelItem item = this.genpanelitemService.findGenPanelItem(row.get("itemId").toString());
                item.setGroupId(groupId);
                this.genpanelitemService.saveGenPanelItem(item);
            }
        }
    }

    public void delGenPanelGroup(String id) {
        GenPanelGroup entity = (GenPanelGroup)this.genPanelGroupDao.findById(id).get();
        entity.setIsUse("N");
        this.genPanelGroupDao.save(entity);
    }

    public PageObject PageAll(String panelId, String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (!StrKit.notNull(panelId)) {
            return new PageObject();
        }
        params.put("panelId", panelId);
        return this.bSqlHelper.serachPage("gen.GenPanelGroup.select", params, PageRequest.of((int)page, (int)rows));
    }

    public List<ComboxNode> getGroupCombo(String panelId) {
        List<GenPanelGroup> grouplist = this.genPanelGroupDao.findByPanelIdAndIsUseOrderByDisplayNo(panelId, "Y");
        ArrayList<ComboxNode> list = new ArrayList<ComboxNode>();
        for (GenPanelGroup group : grouplist) {
            ComboxNode node = new ComboxNode();
            node.setText(group.getGroupTitle());
            node.setValue(group.getGroupId().toString());
            list.add(node);
        }
        return list;
    }

    public PageObject pageGourpItem(String groupId, String panelId, String search) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StrKit.notNull(groupId, panelId)) {
            return new PageObject();
        }
        params.put("groupId", groupId);
        params.put("panelId", panelId);
        return this.bSqlHelper.serachPage("gen.GenPanelGroup.pageGourpItem", params);
    }

    public PageObject searchItemList(String panelId, String fiterItems, String search) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StrKit.notNull(fiterItems)) {
            params.put("fiterItems", ListUtils.stringToListWithLong(fiterItems));
        }
        if (!StrKit.notNull(panelId)) {
            return new PageObject();
        }
        params.put("panelId", panelId);
        return this.bSqlHelper.serachPage("gen.GenPanelGroup.searchItemList", params);
    }

    public void removeItemId(String itemIds) {
        List<GenPanelItem> itemList = this.genpanelitemService.findByItemIdIn(ListUtils.stringToList(itemIds));
        for (GenPanelItem item : itemList) {
            item.setGroupId(null);
        }
        this.genpanelitemService.saveGenPanelItem(itemList);
    }
}

