/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.doc.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysContent;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.service.CommonService;
import com.ustc.doc.dao.DocFileVersionDao;
import com.ustc.doc.dao.DocFormFileDao;
import com.ustc.doc.entity.DocFileVersion;
import com.ustc.doc.entity.DocFormFile;
import com.ustc.doc.entity.FormFileBean;
import com.ustc.gen.entity.GenForm;
import com.ustc.gen.service.GenFormService;
import com.ustc.gen.util.DBPropertyUtil;
import com.ustc.sys.util.ListUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class DocFormFileService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private DocFormFileDao docformfileDao;
    @Autowired
    private DocFileVersionDao docfileversionDao;
    @Autowired
    private GenFormService genFormService;

    public DocFormFile findDocFormFile(Long id) {
        DocFormFile entity = (DocFormFile)this.docformfileDao.findById(id).get();
        return entity;
    }

    public void saveDocFormFile(DocFormFile entity) {
        this.docformfileDao.save(entity);
    }

    public void delDocFormFile(Long id) {
        this.docformfileDao.deleteById(id);
    }

    public void delDocFormFile(String ids) {
        ListUtils.stringToListWithLong(ids).forEach(id -> {
            DocFormFile entity = (DocFormFile)this.docformfileDao.findById(id).get();
            entity.setIsUse("N");
            this.docformfileDao.save(entity);
        });
    }

    public PageObject PageAll(String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        String sql = "select * from DOC_FORM_FILE t  order by t.FORM_FILE_ID";
        if (!StringUtils.isEmpty((String)search)) {
            sql = "select * from DOC_FORM_FILE t where   upper(t.FORM_FILE_ID) like ?1  or upper(t.FORM_ID) like ?1  or upper(t.FILE_TYPE_ID) like ?1  or upper(t.FILE_VERSION_ID) like ?1  or upper(t.PRIMARY_KEY) like ?1  or upper(t.DISPLAY_NO) like ?1  or upper(t.IS_USE) like ?1  or upper(t.PROJECT_ID) like ?1  or upper(t.FILE_NO) like ?1  or upper(t.FILE_NAME) like ?1  or upper(t.MEMO) like ?1  order by t.FORM_FILE_ID";
            pageobject = this.sqlHelper.pagerNativeSQL(sql, new Object[]{"%" + search.toUpperCase() + "%"}, page, rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql, page, rows);
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public PageObject PageAllDocFormFile(Long archivesTypeId, String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select t.archive_file_id,b.file_name,e.account_name as ARCHIVES_ACCOUNT_TEXT_, \t\t(select listagg(x.position_name,'/') within GROUP (order by level desc) from B_ARCHIVES_POSITION x \n\t\t         start with x.POSITION_ID = a.archives_room \n\t\t        CONNECT BY PRIOR x.POSITION_PID = x.POSITION_ID  ) as ARCHIVES_ROOM_TEXT_, \n\t\t(select listagg(x.archives_type_name,'/') within GROUP (order by level desc) from B_ARCHIVES_TYPE x \n\t\t         start with x.archives_type_id = a.archives_type \n\t\t        CONNECT BY PRIOR x.archives_type_pid = x.archives_type_id  ) as ARCHIVES_TYPE_TEXT_, \n a.*\n            from b_archive_file t\n            left join doc_file_version a\n              on t.file_version_id = a.version_id\n              left join doc_form_file b\n              on t.form_file_id=b.form_file_id \n");
        sql.append(" LEFT JOIN BAS_EMP_ACCOUNT e on e.account_id=a.ARCHIVES_ACCOUNT \n");
        sql.append("    WHERE t.is_use = :isUse and a.IS_ARCHIVES = :isArchives and a.ARCHIVES_TYPE is not null \n");
        params.put("isUse", Character.valueOf('Y'));
        params.put("isArchives", SysContent.PASS_STATUS);
        if (archivesTypeId != null && archivesTypeId != 0L) {
            sql.append(" and a.ARCHIVES_TYPE in (select ARCHIVES_TYPE_ID from B_ARCHIVES_TYPE start with ARCHIVES_TYPE_ID=:archivesTypeId\tconnect  by ARCHIVES_TYPE_PID= prior ARCHIVES_TYPE_ID) ");
            params.put("archivesTypeId", archivesTypeId);
        }
        if (!StringUtils.isEmpty((String)search)) {
            sql.append(" and  (");
            sql.append(" upper(a.ARCHIVES_ROOM) like :search ");
            sql.append(" or upper(a.BOX_NO) like :search ");
            sql.append(" or upper(a.ARCHIVES_TYPE) like :search ");
            sql.append(" or upper(a.SAVETERM) like :search ");
            sql.append(" or upper(a.ARCHIVES_NO) like :search ");
            sql.append(" or upper(a.IS_ARCHIVES) like :search ");
            sql.append(" or upper(a.ARCHIVES_ACCOUNT) like :search ");
            sql.append(" or upper(a.ARCHIVES_TIME) like :search ");
            sql.append(" or upper(a.ARCHIVES_TYPE_NAME) like :search ");
            sql.append(")");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by a.ARCHIVES_TIME DESC");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("IS_PAPER", "IS_PAPER");
        dicmapper.put("SAVETERM", "SAVE_TERM");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public PageObject PageAllDocFormFileEdit(Long accountId, Long archivesTypeId, String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select a.file_name,\nreplace(n.theme_name,'\u7684\u5f52\u6863\u7533\u8bf7','') as theme_name,\n       e.account_name as ARCHIVES_ACCOUNT_TEXT_,\n       (select listagg\n\n               (x.position_name, '/') within GROUP(order by level desc)\n          from B_ARCHIVES_POSITION x\n         start with x.POSITION_ID = t.archives_room\n        CONNECT BY PRIOR x.POSITION_PID = x.POSITION_ID) as ARCHIVES_ROOM_TEXT_,\n       (select listagg(x.archives_type_name, '/') within GROUP(order by level desc)\n          from B_ARCHIVES_TYPE x\n         start with x.archives_type_id=t.archives_type\n        CONNECT BY PRIOR x.archives_type_pid = x.archives_type_id) as ARCHIVES_TYPE_TEXT_,t.*\n  from doc_file_version t\n  left join doc_file a\n    on a.file_id = t.file_id\n LEFT JOIN b_archive_file m on t.version_id=m.file_version_id and m.is_use='Y' \n   LEFT JOIN B_ARCHIVE N on m.archive_id=n.archive_id and n.is_use='Y' \n   LEFT JOIN BAS_EMP_ACCOUNT e\n    on e.account_id = t.ARCHIVES_ACCOUNT");
        sql.append("    WHERE a.is_use = :isUse and t.IS_ARCHIVES = :isArchives and t.ARCHIVES_TYPE is not null \n");
        params.put("isUse", Character.valueOf('Y'));
        params.put("isArchives", SysContent.PASS_STATUS);
        sql.append(" and t.ARCHIVES_TYPE in\n       (select tp.ARCHIVES_TYPE_ID\n          from B_ARCHIVES_TYPE tp\n          left join B_ARCHIVES_TYPE_ACCOUNT a\n            on tp.archives_type_id = a.archives_type_id\n         where a.account_id = :accountId\n");
        params.put("accountId", accountId);
        if (archivesTypeId != null && archivesTypeId != 0L) {
            sql.append("         start with tp.ARCHIVES_TYPE_ID = :archivesTypeId\n        connect by tp.ARCHIVES_TYPE_PID = prior tp.ARCHIVES_TYPE_ID \n");
            params.put("archivesTypeId", archivesTypeId);
        }
        sql.append(") \n");
        if (!StringUtils.isEmpty((String)search)) {
            sql.append(" and  (");
            sql.append(" upper(t.ARCHIVES_ROOM) like :search ");
            sql.append(" or upper(t.BOX_NO) like :search ");
            sql.append(" or upper(t.ARCHIVES_TYPE) like :search ");
            sql.append(" or upper(t.SAVETERM) like :search ");
            sql.append(" or upper(t.ARCHIVES_NO) like :search ");
            sql.append(" or upper(n.theme_name) like :search ");
            sql.append(" or upper(t.IS_ARCHIVES) like :search ");
            sql.append(" or upper(t.ARCHIVES_ACCOUNT) like :search ");
            sql.append(" or upper(t.ARCHIVES_TIME) like :search ");
            sql.append(" or upper(t.ARCHIVES_TYPE_NAME) like :search ");
            sql.append(")");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.ARCHIVES_TIME DESC");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("IS_PAPER", "IS_PAPER");
        dicmapper.put("SAVETERM", "SAVE_TERM");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public void SaveFormFileBean(FormFileBean bean) {
        Long index = 1L;
        for (DocFormFile formfile : bean.getPanelfilelist()) {
            if (formfile == null || StrKit.isBlank(formfile.getFileNo()) && StrKit.isBlank(formfile.getFileName()) && formfile.getFileVersionId() == null) continue;
            formfile.setPrimaryKey(String.valueOf(bean.getPrimaryKey()));
            formfile.setProjectId(bean.getProjectId());
            formfile.setDisplayNo(index);
            formfile.setModifyAccount(bean.getAccountid());
            formfile.setModifyTime(new Date());
            if (formfile.getFormFileId() == null && bean.getWorkitemid() != null && formfile.getWorkitemid() == null) {
                formfile.setWorkitemid(bean.getWorkitemid());
            }
            this.docformfileDao.save(formfile);
            Long l = index;
            Long l2 = index = Long.valueOf(index + 1L);
        }
    }

    public List<DocFormFile> listFormFileByPK(String formid, String fileTypeId, List<String> PKS, Boolean isArchive) {
        List<DocFormFile> list = this.docformfileDao.findByFormIdAndFileTypeIdAndPrimaryKeyInAndIsUseOrderByDisplayNo(formid, fileTypeId, PKS, "Y");
        ArrayList<DocFormFile> returnlist = new ArrayList<DocFormFile>();
        Map<String, String> dicmap = this.commonService.getDicMap("INVOICE_TYPE");
        Map<String, String> dicmap1 = this.commonService.getDicMap("BILL_CATEGORY");
        for (DocFormFile file : list) {
            if (StringUtils.isNotBlank((String)file.getBillType())) {
                file.setBillTypeName(dicmap.get(file.getBillType()));
            }
            if (StringUtils.isNotBlank((String)file.getBillCategory())) {
                file.setBillCategoryName(dicmap1.get(file.getBillCategory()));
            }
            if (file.getFileVersionId() == null) continue;
            DocFileVersion version = (DocFileVersion)this.docfileversionDao.findById(file.getFileVersionId()).get();
            if (version != null) {
                file.setOriginalName(version == null ? "" : version.getOriginalName());
                file.setIsArchives(version.getIsArchives());
                if (isArchive == null) {
                    returnlist.add(file);
                    continue;
                }
                if (isArchive.booleanValue() && SysContent.PASS_STATUS.toString().equals(version.getIsArchives())) {
                    returnlist.add(file);
                    continue;
                }
                if (isArchive.booleanValue() || !"0".equals(version.getIsArchives()) && !"31".equals(version.getIsArchives())) continue;
                returnlist.add(file);
                continue;
            }
            returnlist.add(file);
        }
        return returnlist;
    }

    public List<DocFormFile> listFormFileByPK(String formid, String fileTypeId, String PK) {
        return this.listFormFileByPK(formid, fileTypeId, Arrays.asList(PK), null);
    }

    public List<DocFormFile> getProjectFileList(String fileTypeId, Long projectId) {
        List<DocFormFile> list = this.docformfileDao.findByFileTypeIdAndProjectIdAndIsUseOrderByDisplayNo(fileTypeId, (long)projectId, "Y");
        ArrayList<DocFormFile> returnlist = new ArrayList<DocFormFile>();
        Map<String, String> dicmap = this.commonService.getDicMap("invoiceType");
        Map<String, String> dicmap1 = this.commonService.getDicMap("BILL_CATEGORY");
        for (DocFormFile file : list) {
            if (StringUtils.isNotBlank((String)file.getBillType())) {
                file.setBillTypeName(dicmap.get(file.getBillType()));
            }
            if (StringUtils.isNotBlank((String)file.getBillCategory())) {
                file.setBillCategoryName(dicmap1.get(file.getBillCategory()));
            }
            if (file.getFileVersionId() == null) continue;
            DocFileVersion version = (DocFileVersion)this.docfileversionDao.findById(file.getFileVersionId()).get();
            if (version != null) {
                file.setOriginalName(version == null ? "" : version.getOriginalName());
                file.setIsArchives(version.getIsArchives());
                returnlist.add(file);
                continue;
            }
            returnlist.add(file);
        }
        return returnlist;
    }

    public List<DocFormFile> listFormFileByPK(String formid, String fileTypeId, List<String> PKS) {
        return this.listFormFileByPK(formid, fileTypeId, PKS, null);
    }

    public List<DocFormFile> findByFormCodeAndPrimaryKey(String formcode, String primaryKey) {
        GenForm form = this.genFormService.findGenFormByCode(formcode);
        if (form != null) {
            return this.docformfileDao.findByFormIdAndPrimaryKeyAndIsUseOrderByDisplayNo(form.getId(), primaryKey, "Y");
        }
        return null;
    }

    public List findArchiveByFormFileIds(String formfileids) {
        StringBuffer sb = new StringBuffer();
        sb.append("select T.*,b.FILE_TYPE_NAME \n  from doc_form_file t\n  LEFT JOIN DOC_FILE_VERSION A ON T.FILE_VERSION_ID=A.VERSION_ID\n                LEFT JOIN DOC_FILE_TYPE B ON T.FILE_TYPE_ID=B.FILE_TYPE_ID where  t.is_use = ?1 \n   and t.form_file_id in (?2) \n   AND (A.IS_ARCHIVES in ('0','31') ) ORDER BY T.DISPLAY_NO");
        List list = this.sqlHelper.queryByNativeSQL(sb.toString(), new Object[]{"Y", ListUtils.stringToListWithLong(formfileids)}, new int[0]);
        return list;
    }

    public List findArchiveByFormFileIds1(String formfileids) {
        StringBuffer sql = new StringBuffer();
        HashMap<String, Object> params = new HashMap<String, Object>();
        formfileids = "(" + formfileids + ")";
        params.put("formfileids", formfileids);
        sql.append("select T.*,b.FILE_TYPE_NAME\n       from doc_form_file t\n       LEFT JOIN DOC_FILE_VERSION a ON t.FILE_VERSION_ID=a.VERSION_ID\n       LEFT JOIN DOC_FILE_TYPE b ON t.FILE_TYPE_ID=b.FILE_TYPE_ID\n       where  t.is_use ='Y'\n       and (A.IS_ARCHIVES in ('0','31') )\n       @if(!isEmpty(formfileids)){\n        and t.form_file_id in #text(formfileids)#\n       @}\n       ORDER BY T.DISPLAY_NO");
        List<Map<String, Object>> formFileList = this.bSqlHelper.serachBySql(sql.toString(), params);
        return formFileList;
    }

    public PageObject pageAllArchiveByFormCodeAndPrimaryKey(Long flag, String formcode, Long primaryKey, String search, int page, int rows, String sort, String order) {
        GenForm form = this.genFormService.findGenFormByCode(formcode);
        PageObject pageobject = new PageObject();
        if (form != null) {
            StringBuffer sb = new StringBuffer();
            HashMap<String, Object> params = new HashMap<String, Object>();
            sb.append("select T.FORM_FILE_ID,B.FILE_TYPE_NAME,T.FILE_NAME,E.ACCOUNT_NAME as ARCHIVES_ACCOUNT_TEXT_,A.*\n                from doc_form_file t\n                LEFT JOIN DOC_FILE_VERSION A ON T.FILE_VERSION_ID=A.VERSION_ID\n                LEFT JOIN DOC_FILE_TYPE B ON T.FILE_TYPE_ID=B.FILE_TYPE_ID \t\t\t\t\tLEFT JOIN BAS_EMP_ACCOUNT e on e.account_id=a.ARCHIVES_ACCOUNT \n where 1=1 ");
            if (formcode.equals("BPmProjectDoc_form")) {
                sb.append("and t.form_id in (1360,1361,1362,1363,1364,1365,1366,1367,1368)\n   and t.project_id = :pk \n");
                params.put("pk", primaryKey);
            } else {
                sb.append("and t.form_id =:formid\n   and t.primary_key = :pk \n");
                params.put("formid", form.getId());
                params.put("pk", primaryKey);
            }
            sb.append("   and t.is_use = :isuse \n");
            if (flag != null) {
                if (flag == 1L) {
                    sb.append("   AND a.IS_ARCHIVES=:workflowStatus ");
                    params.put("workflowStatus", SysContent.PASS_STATUS.toString());
                } else if (flag == 0L) {
                    sb.append("   AND (A.IS_ARCHIVES in('0','31')) ");
                }
            }
            if (!StringUtils.isEmpty((String)search)) {
                sb.append("and  (");
                sb.append(" upper(t.FILE_NAME) like :search ");
                sb.append(" upper(a.ARCHIVES_ROOM) like :search ");
                sb.append(" or upper(a.BOX_NO) like :search ");
                sb.append(" or upper(a.ARCHIVES_TYPE) like :search ");
                sb.append(" or upper(a.SAVETERM) like :search ");
                sb.append(" or upper(a.ARCHIVES_NO) like :search ");
                sb.append(" or upper(a.IS_ARCHIVES) like :search ");
                sb.append(" or upper(a.ARCHIVES_ACCOUNT) like :search ");
                sb.append(" or upper(a.ARCHIVES_TIME) like :search ");
                sb.append(" or upper(a.ARCHIVES_TYPE_NAME) like :search ");
                sb.append(") ");
                params.put("search", "%" + search.toUpperCase() + "%");
            }
            sb.append("    ORDER BY A.IS_ARCHIVES ");
            params.put("isuse", "Y");
            if (StrKit.notBlank(sort)) {
                String exesql = "select * from (" + sb.toString() + ") " + SysUtils.genOrderBy(sort, order);
                pageobject = this.sqlHelper.pagerNativeSQL(exesql, params, (Integer)page, (Integer)rows);
            } else {
                pageobject = this.sqlHelper.pagerNativeSQL(sb.toString(), params, (Integer)page, (Integer)rows);
            }
            HashMap<String, String> dicmapper = new HashMap<String, String>();
            dicmapper.put("IS_PAPER", "IS_PAPER");
            dicmapper.put("ARCHIVES_ROOM", "ARCHIVES_ROOM");
            dicmapper.put("SAVETERM", "SAVE_TERM");
            dicmapper.put("IS_ARCHIVES", "ARCHIVE_STATUS");
            this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        }
        return pageobject;
    }

    public DocFormFile findByFormIdAndPrimaryKeyAndFileVersionId(String formcode, String primaryKey, Long fileVersionId) {
        GenForm form = this.genFormService.findGenFormByCode(formcode);
        if (form != null) {
            List<DocFormFile> list = this.docformfileDao.findByFormIdAndPrimaryKeyAndFileVersionIdAndIsUseOrderByDisplayNo(form.getId(), primaryKey, fileVersionId, "Y");
            if (!list.isEmpty()) {
                return list.get(0);
            }
            return null;
        }
        return null;
    }

    public List<Object> findFormFileByFileVersionId(Long versionid) {
        String sql = "select t.*, a.form_code, a.form_name, b.file_type_name, c.account_name\n  from doc_form_file t\n  left join gen_form a\n    on t.form_id = a.id\n  left join doc_file_type b\n    on t.form_file_id = b.file_type_id\n  left join bas_emp_account c\n    on t.modify_account = c.account_id\n where t.file_version_id = ?1\n   and t.is_use = ?2 order by t.modify_time desc";
        return this.sqlHelper.queryByNativeSQL(sql, new Object[]{versionid, "Y"}, new int[0]);
    }

    public Boolean checkFileByFileTypeId(FormFileBean formfile, Long fileTypeId) {
        Boolean haveFile = false;
        if (fileTypeId == null || formfile == null) {
            return haveFile;
        }
        for (DocFormFile formFile : formfile.getPanelfilelist()) {
            if (!fileTypeId.equals(formFile.getFileTypeId()) || !"Y".equals(formFile.getIsUse())) continue;
            haveFile = true;
            break;
        }
        return haveFile;
    }

    public List<Map<String, Object>> getFileInfo(Long bizMainId, String formCode) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql.append("select a.*,v.is_archives\n  from doc_form_file a\n  left join DOC_FILE_VERSION v\n    on a.file_version_id = v.version_id\n  left join gen_form g\n    on g.id = a.form_id\n where a.primary_key = :bizMainId\n   and g.form_code = :formCode\n   and a.is_use = :isUse \n");
        params.put("bizMainId", bizMainId);
        params.put("formCode", formCode);
        params.put("isUse", "Y");
        List map = this.sqlHelper.queryByNativeSQL(sql.toString(), params, new int[0]);
        return map;
    }

    public List<Map<String, Object>> getFileInfoForPmPmcon(Long bizMainId, String formCode, String search, String status) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("bizMainId", bizMainId);
        params.put("formCode", formCode);
        if (StringUtils.isNotBlank((String)search)) {
            params.put("search", "%" + search + "%");
        }
        if (StringUtils.isNotBlank((String)status)) {
            params.put("status", status);
        }
        sql.append(" select  a.file_name archive_file_name,\n a.form_file_id,\n a.file_version_id,\n f.workflow_status,\n(case\n when f.WORKFLOW_STATUS is null then 1\n when f.WORKFLOW_STATUS=3 then 3\n else 2\n end) file_status,\n GETDICNAME('FILE_STATUS', (case\n when f.WORKFLOW_STATUS is null then 1\n when f.WORKFLOW_STATUS=3 then 3\n else 2\n end)) file_status_text\n from doc_form_file a\n left join DOC_FILE_VERSION v\n on a.FILE_VERSION_ID = v.VERSION_ID\n left join gen_form g\n on g.id = a.form_id\n left join ARCHIVES_ARCHIVE_FILE f\n on v.VERSION_ID=f.VERSION_ID\n where a.is_use ='Y'\n @if(!isEmpty(bizMainId)){\n     and a.primary_key=#bizMainId#\n @}\n @if(!isEmpty(formCode)){\n     and g.form_code=#formCode#\n @}\n @if(!isEmpty(search)){\n     and a.file_name like #search#\n @}\n @if(!isEmpty(status)){\n@if(status=='1'){\n     and f.WORKFLOW_STATUS =3\n@}\n@if(status=='0'){\n     and (f.WORKFLOW_STATUS <>3 or f.workflow_status is null)\n@}\n@}");
        List<Map<String, Object>> map = this.bSqlHelper.serachBySql(sql.toString(), params);
        return map;
    }

    public void delFormFileByPK(String formCode, String pk) {
        List<DocFormFile> list = this.findByFormCodeAndPrimaryKey(formCode, pk);
        if (list != null && !list.isEmpty()) {
            for (DocFormFile file : list) {
                file.setIsUse("N");
            }
            this.docformfileDao.saveAll(list);
        }
    }

    public PageObject PageAll(String fileNature, String reimbursed, String search, String startDate, String endDate, String applyPerson, String invoceType, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (!StringUtils.isEmpty((String)startDate)) {
            params.put("startDate", startDate);
        }
        if (!StringUtils.isEmpty((String)endDate)) {
            params.put("endDate", endDate);
        }
        if (!StringUtils.isEmpty((String)applyPerson)) {
            params.put("applyPerson", "%" + applyPerson.toUpperCase().replace("%", "/%") + "%");
        }
        if (!StringUtils.isEmpty((String)invoceType)) {
            params.put("invoceType", invoceType);
        }
        if (!StringUtils.isEmpty((String)fileNature)) {
            params.put("fileNature", fileNature);
        }
        if (!StringUtils.isEmpty((String)reimbursed)) {
            params.put("reimbursed", reimbursed);
        }
        return this.bSqlHelper.serachPage("doc.DocFormFile.select", params, PageRequest.of((int)page, (int)rows));
    }
}

