/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.doc.service;

import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.service.CommonService;
import com.ustc.doc.common.FileService;
import com.ustc.doc.common.util.FileStoreException;
import com.ustc.doc.dao.DocFileDao;
import com.ustc.doc.dao.DocFileVersionDao;
import com.ustc.doc.entity.DocFile;
import com.ustc.doc.entity.DocFileVersion;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class DocFileVersionService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private FileService fileService;
    @Autowired
    private DocFileVersionDao docfileversionDao;
    @Autowired
    private DocFileDao docfileDao;

    public DocFileVersion findBaseVersionByVersionid(Long versionid) {
        DocFile docfile;
        Optional optional = this.docfileversionDao.findById(versionid);
        DocFileVersion version = null;
        if (optional != null && optional.isPresent()) {
            version = (DocFileVersion)optional.get();
        }
        if (version != null && version.getFileId() != null && (docfile = (DocFile)this.docfileDao.findById(version.getFileId()).get()).getBaseVersionId() != null) {
            Optional findById = this.docfileversionDao.findById(docfile.getBaseVersionId());
            DocFileVersion baseversion = findById.isPresent() ? (DocFileVersion)findById.get() : null;
            return baseversion;
        }
        return null;
    }

    public List<Object> listVersionByFileId(Long fileId) {
        String sql = "select t.version_id,\n       t.uuid,\n       t.create_account,\n       t.create_time,\n       t.original_name,\n       t.version_no,\n       a.account_name\n  from DOC_FILE_VERSION t\n  left join bas_emp_account a\n    on t.create_account = a.account_id\n where t.file_id = ?1\n   and t.is_use = ?2\n order by t.create_time desc";
        return this.sqlHelper.queryByNativeSQL(sql, new Object[]{fileId, "Y"}, new int[0]);
    }

    public List listVersionByArchiveId(Long ArchiveId) {
        String sql = "select t.archive_file_id,b.file_name,t.remark,\t\t(select listagg(x.position_name,'/') within GROUP (order by level desc) from B_ARCHIVES_POSITION x \n\t\t         start with x.POSITION_ID = a.archives_room \n\t\t        CONNECT BY PRIOR x.POSITION_PID = x.POSITION_ID  ) as ARCHIVES_ROOM_TEXT_, \n\t\t(select listagg(x.archives_type_name,'/') within GROUP (order by level desc) from B_ARCHIVES_TYPE x \n\t\t         start with x.archives_type_id = a.archives_type \n\t\t        CONNECT BY PRIOR x.archives_type_pid = x.archives_type_id  ) as ARCHIVES_TYPE_TEXT_, \n a.*\n            from b_archive_file t\n            left join doc_file_version a\n              on t.file_version_id = a.version_id\n              left join doc_form_file b\n              on t.form_file_id=b.form_file_id\n           where t.archive_id=?1";
        List list = this.sqlHelper.queryByNativeSQL(sql, new Object[]{ArchiveId}, new int[0]);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("IS_PAPER", "IS_PAPER");
        dicmapper.put("SAVETERM", "SAVE_TERM");
        this.commonService.fmtListWithDic(list, dicmapper);
        return list;
    }

    public Object listVersionByArchiveIdEdit(Long versionid) {
        String sql = "select\n       p.file_name,\n       (select listagg(x.position_name, '/') within GROUP(order by level desc)\n          from B_ARCHIVES_POSITION x\n         start with x.POSITION_ID = t.archives_room\n        CONNECT BY PRIOR x.POSITION_PID = x.POSITION_ID) as ARCHIVES_ROOM_TEXT_,\n       (select listagg(x.archives_type_name, '/') within GROUP(order by level desc)\n          from B_ARCHIVES_TYPE x\n         start with x.archives_type_id = t.archives_type\n        CONNECT BY PRIOR x.archives_type_pid = x.archives_type_id) as ARCHIVES_TYPE_TEXT_,\n       t.*\n  from doc_file_version t\n  left join (select distinct a.file_version_id, b.file_name\n  from  b_archive_file a\n  left join doc_form_file b\n    on a.form_file_id = b.form_file_id) p on p.file_version_id=t.version_id\n    where t.version_id=?1";
        List list = this.sqlHelper.queryByNativeSQL(sql, new Object[]{versionid}, new int[0]);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("IS_PAPER", "IS_PAPER");
        dicmapper.put("SAVETERM", "SAVE_TERM");
        this.commonService.fmtListWithDic(list, dicmapper);
        return list;
    }

    public DocFile findFileByVersionId(Long versionid) {
        DocFileVersion version = (DocFileVersion)this.docfileversionDao.findById(versionid).get();
        if (version == null) {
            return null;
        }
        return (DocFile)this.docfileDao.findById(version.getFileId()).get();
    }

    public boolean hasrepeat(DocFileVersion entity) {
        if (StrKit.notBlank(entity.getArchivesRoom()) && StrKit.notBlank(entity.getBoxNo())) {
            List<DocFileVersion> list = this.docfileversionDao.findByArchivesRoomAndBoxNoAndIsUseAndVersionIdNot(entity.getArchivesRoom(), entity.getBoxNo(), "Y", entity.getVersionId());
            return list != null && list.size() > 0;
        }
        return false;
    }

    public DocFileVersion findDocFileVersion(Long id) {
        Optional optional = this.docfileversionDao.findById(id);
        DocFileVersion version = null;
        version = optional != null && optional.isPresent() ? (DocFileVersion)optional.get() : new DocFileVersion();
        return version;
    }

    public void saveDocFileVersion(DocFileVersion entity) {
        this.docfileversionDao.save(entity);
    }

    public void delDocFileVersion(Long id) {
        this.docfileversionDao.deleteById(id);
    }

    public PageObject PageAll(String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        String sql = "select * from DOC_FILE_VERSION t  order by t.FILE_ID";
        if (!StringUtils.isEmpty((String)search)) {
            sql = "select * from DOC_FILE_VERSION t where   upper(t.VERSION_ID) like ?1  or upper(t.VERSION_NO) like ?1  or upper(t.FILE_ID) like ?1  or upper(t.ORIGINAL_NAME) like ?1  or upper(t.FILE_SUFFIX) like ?1  or upper(t.CREATE_ACCOUNT) like ?1  or upper(t.CREATE_TIME) like ?1  or upper(t.IS_USE) like ?1  order by t.FILE_ID";
            pageobject = this.sqlHelper.pagerNativeSQL(sql, new Object[]{"%" + search.toUpperCase() + "%"}, page, rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql, page, rows);
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public PageObject docQuery(String searchkey, int page, int rows) throws FileStoreException {
        Map<String, String> fileServicelist = this.fileService.retrieveWithExcerpt(searchkey);
        StringBuffer sql = new StringBuffer();
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql.append("select t.file_no,\n       t.file_name,\n       a.version_id,\n       a.uuid,\n       a.original_name,\n       a.version_no,\n       a.create_account,\n       b.account_name,\n       DATE_FORMAT(a.create_time,'%Y-%m-%d %H:%i:%s') as create_time,\n       t.memo \n  from Doc_Form_File t\n  left join doc_file_version a\n    on t.file_version_id = a.version_id\n  left join bas_emp_account b \n    on a.create_account = b.account_id \n where t.is_use = 'Y' ");
        if (!StringUtils.isEmpty((String)searchkey)) {
            sql.append("and  (");
            sql.append("   upper(t.file_no) like :search ");
            sql.append("or upper(t.file_name) like :search ");
            sql.append("or upper(a.original_name) like :search ");
            sql.append("or upper(t.memo) like :search ");
            if (fileServicelist != null && fileServicelist.size() > 0) {
                sql.append("or a.uuid in (:fileserviceids) ");
                params.put("fileserviceids", fileServicelist.keySet());
            }
            sql.append(") ");
            params.put("search", "%" + searchkey.toUpperCase() + "%");
        }
        sql.append(" order by a.create_time desc");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        for (Object row : pageobject.getRows()) {
            Map rowmap = (Map)row;
            String uuid = rowmap.get("UUID") == null ? "" : rowmap.get("UUID").toString();
            if (!StrKit.notBlank(uuid) || !fileServicelist.containsKey(uuid)) continue;
            rowmap.put("EXCERPT", fileServicelist.get(uuid));
        }
        return pageobject;
    }
}

