/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.doc.common.util;

import com.ustc.doc.common.persist.FileInfo;
import com.ustc.doc.common.util.FileStoreException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionException;
import org.apache.commons.io.FilenameUtils;
import org.apache.jackrabbit.value.BinaryValue;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;
import sun.net.www.MimeTable;

public class JackrabbitHelper {
    private static final Logger logger = Logger.getLogger(JackrabbitHelper.class);

    public void initStorageNode(Session session, String storageNodeName) throws FileStoreException {
        try {
            Node root = session.getRootNode();
            Node node = root.addNode(storageNodeName, "nt:unstructured");
            node.setProperty("jcr:lastModified", new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
            String pkUUID = UUID.randomUUID().toString().replaceAll("-", "");
            node.setProperty("jcr:uuid", pkUUID);
            session.save();
        }
        catch (RepositoryException e) {
            logger.error((Object)"\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", (Throwable)e);
            throw new FileStoreException("\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", e);
        }
    }

    public Node getStorageNode(Session session, String storageNodeName) throws FileStoreException {
        Node storageNode = null;
        String xPath = "/jcr:root/" + storageNodeName;
        try {
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query query = qm.createQuery(xPath, "xpath");
            QueryResult result = query.execute();
            NodeIterator it = result.getNodes();
            while (it.hasNext()) {
                storageNode = it.nextNode();
            }
        }
        catch (RepositoryException e) {
            logger.error((Object)"\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", (Throwable)e);
            throw new FileStoreException("\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", e);
        }
        return storageNode;
    }

    public String writerBinProperty(Session session, String storageNodeName, InputStream is, FileInfo fileinfo) throws FileStoreException {
        Node storageNode = this.getStorageNode(session, storageNodeName);
        String fileUUID = "";
        try {
            String projectId = "0";
            if (fileinfo.getProjectid() != null) {
                projectId = String.valueOf(fileinfo.getProjectid());
            }
            String catalogid = String.valueOf(fileinfo.getCatalogid());
            boolean flagP = session.nodeExists("/" + storageNode.getName() + "/" + projectId);
            Node firstNode = null;
            firstNode = flagP ? storageNode.getNode(projectId) : storageNode.addNode(projectId, "nt:unstructured");
            boolean flag = session.nodeExists("/" + storageNode.getName() + "/" + projectId + "/" + catalogid);
            Node twoStorageNode = null;
            twoStorageNode = flag ? firstNode.getNode(catalogid) : firstNode.addNode(catalogid, "nt:unstructured");
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmmss");
            String currentTime = dateformat.format(new Date());
            String fileNameBefore = FilenameUtils.getBaseName((String)fileinfo.getFilename());
            String fileType = FilenameUtils.getExtension((String)fileinfo.getFilename());
            String name = fileNameBefore + "_" + currentTime + "." + fileType;
            Node fileNode = twoStorageNode.addNode(name, "nt:file");
            fileUUID = fileNode.getIdentifier();
            Node resNode = fileNode.addNode("jcr:content", "nt:resource");
            MimeTable mt = MimeTable.getDefaultTable();
            String mimeType = mt.getContentTypeFor(fileinfo.getFilename());
            if (mimeType == null) {
                mimeType = this.getMimeType(fileType);
            }
            resNode.setProperty("jcr:mimeType", mimeType);
            BinaryValue fileBinary = new BinaryValue(is);
            resNode.setProperty("jcr:data", (Value)fileBinary);
            session.save();
        }
        catch (ItemExistsException e) {
            logger.error((Object)"\u6587\u4ef6\u5df2\u5b58\u5728!", (Throwable)e);
            throw new FileStoreException("\u6587\u4ef6\u5df2\u5b58\u5728!", e);
        }
        catch (PathNotFoundException e) {
            logger.error((Object)"\u6ca1\u627e\u5230\u8def\u5f84!", (Throwable)e);
            throw new FileStoreException("\u6ca1\u627e\u5230\u8def\u5f84!", e);
        }
        catch (NoSuchNodeTypeException e) {
            logger.error((Object)"\u6ca1\u6709\u6b64\u7c7b\u8282\u70b9!", (Throwable)e);
            throw new FileStoreException("\u6ca1\u6709\u6b64\u7c7b\u8282\u70b9!", e);
        }
        catch (LockException e) {
            logger.error((Object)"\u6587\u4ef6\u88ab\u9501\u5b9a!", (Throwable)e);
            throw new FileStoreException("\u6587\u4ef6\u88ab\u9501\u5b9a!", e);
        }
        catch (VersionException e) {
            logger.error((Object)"\u7248\u672c\u5f02\u5e38!", (Throwable)e);
            throw new FileStoreException("\u7248\u672c\u5f02\u5e38!", e);
        }
        catch (ConstraintViolationException e) {
            logger.error((Object)"\u8fdd\u53cd\u7ea6\u675f!", (Throwable)e);
            throw new FileStoreException("\u8fdd\u53cd\u7ea6\u675f!", e);
        }
        catch (RepositoryException e) {
            logger.error((Object)"\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", (Throwable)e);
            throw new FileStoreException("\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", e);
        }
        return fileUUID;
    }

    private String getMimeType(String fileType) {
        String mimeType = "";
        mimeType = StringUtils.isEmpty((Object)fileType) ? "application/octet-stream" : ("doc".equalsIgnoreCase(fileType) ? "application/msword" : ("docx".equalsIgnoreCase(fileType) ? "application/vnd.openxmlformats-officedocument.wordprocessingml.document" : ("xls".equalsIgnoreCase(fileType) ? "application/vnd.ms-excel" : ("xlsx".equalsIgnoreCase(fileType) ? "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet" : ("ppt".equalsIgnoreCase(fileType) ? "application/vnd.ms-powerpoint" : ("pptx".equalsIgnoreCase(fileType) ? "application/vnd.openxmlformats-officedocument.presentationml.presentation" : ("pdf".equalsIgnoreCase(fileType) ? "application/pdf" : "application/octet-stream")))))));
        return mimeType;
    }

    public List<Node> fullTextSearchForNode(Session session, String storageNodeName, String keyword) throws FileStoreException {
        ArrayList<Node> list = new ArrayList<Node>();
        if (!"".equals(keyword)) {
            try {
                String xPath = "//element(*, nt:file)[(jcr:contains(jcr:content,\"" + keyword + "\"))]";
                Workspace ws = session.getWorkspace();
                QueryManager qm = ws.getQueryManager();
                Query query = qm.createQuery(xPath, "xpath");
                QueryResult singleStorageNode = query.execute();
                NodeIterator it = singleStorageNode.getNodes();
                while (it.hasNext()) {
                    Node node = it.nextNode();
                    list.add(node);
                }
            }
            catch (InvalidQueryException e) {
                logger.error((Object)"\u65e0\u6548\u7684\u5de5\u4f5c\u9879\u67e5\u8be2\u8bed\u53e5!", (Throwable)e);
                throw new FileStoreException("\u65e0\u6548\u7684\u5de5\u4f5c\u9879\u67e5\u8be2\u8bed\u53e5!", e);
            }
            catch (RepositoryException e) {
                logger.error((Object)"\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", (Throwable)e);
                throw new FileStoreException("\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", e);
            }
        }
        return list;
    }

    public boolean deleteNode(Session session, String pkUUID, String storageNodeName) throws FileStoreException {
        try {
            Node node = session.getNodeByIdentifier(pkUUID);
            NodeIterator it = node.getNodes();
            while (it.hasNext()) {
                Node fileNode = it.nextNode();
                fileNode.remove();
                node.remove();
                session.save();
            }
            return true;
        }
        catch (ItemNotFoundException e1) {
            logger.error((Object)"\u6587\u4ef6\u4e0d\u5b58\u5728!", (Throwable)e1);
            throw new FileStoreException("\u6587\u4ef6\u4e0d\u5b58\u5728!", e1);
        }
        catch (RepositoryException e1) {
            logger.error((Object)"\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", (Throwable)e1);
            throw new FileStoreException("\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", e1);
        }
    }

    public void replaceFile(Session session, String pkUUID, String storageNodeName, InputStream is, String fileName) throws FileStoreException {
        String xPath = "//" + storageNodeName + "/*[@jcr:uuid= '" + pkUUID + "']";
        Workspace ws = session.getWorkspace();
        MimeTable mt = MimeTable.getDefaultTable();
        String mimeType = mt.getContentTypeFor(fileName);
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        String newName = fileName.substring(0, fileName.lastIndexOf("."));
        try {
            QueryManager qm = ws.getQueryManager();
            Query query = qm.createQuery(xPath, "xpath");
            QueryResult singleStorageNode = query.execute();
            NodeIterator itSingle = singleStorageNode.getNodes();
            while (itSingle.hasNext()) {
                Node singleNode = itSingle.nextNode();
                session.move(singleNode.getPath(), singleNode.getParent().getPath() + "/" + newName);
                NodeIterator it = singleNode.getNodes();
                while (it.hasNext()) {
                    Node contentNode = it.nextNode();
                    contentNode.remove();
                    session.save();
                }
                Node fileNode = singleNode.addNode(fileName, "nt:file");
                Node resNode = fileNode.addNode("jcr:content", "nt:resource");
                resNode.setProperty("jcr:mimeType", mimeType);
                BinaryValue fileBinary = new BinaryValue(is);
                resNode.setProperty("jcr:data", (Value)fileBinary);
                session.save();
            }
        }
        catch (InvalidQueryException e) {
            logger.error((Object)"\u65e0\u6548\u7684\u5de5\u4f5c\u9879\u67e5\u8be2\u8bed\u53e5!", (Throwable)e);
            throw new FileStoreException("\u65e0\u6548\u7684\u5de5\u4f5c\u9879\u67e5\u8be2\u8bed\u53e5!", e);
        }
        catch (RepositoryException e) {
            logger.error((Object)"\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", (Throwable)e);
            throw new FileStoreException("\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new FileStoreException("\u6587\u4ef6\u6d41\u5173\u95ed\u5931\u8d25!", e);
                }
            }
        }
    }
}

