/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.doc.common.persist;

import com.ustc.doc.common.persist.FileInfo;
import com.ustc.doc.common.persist.PersistInterface;
import com.ustc.doc.common.util.FileHelper;
import com.ustc.doc.common.util.FileStoreException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.web.multipart.MultipartFile;

public class PersistLocalFile
implements PersistInterface {
    private String localpath = "";
    private String localvisualpath = "";
    FileHelper filehelper = new FileHelper();
    private static PersistLocalFile instance;

    public PersistLocalFile(String lp, String lvp) {
        this.localpath = lp;
        this.localvisualpath = lvp;
    }

    public static synchronized PersistLocalFile getInstance(String lp, String lvp) {
        if (instance == null) {
            instance = new PersistLocalFile(lp, lvp);
        }
        return instance;
    }

    @Override
    public String uploadFile(MultipartFile file, FileInfo fileinfo) {
        String filename = this.filehelper.replaceBlank(file.getOriginalFilename());
        fileinfo.setFilename(filename);
        String fileID = "";
        String catapath = "/" + fileinfo.getProjectid() + "/" + fileinfo.getCatalogid() + "/";
        String pathString = this.localpath + "/" + catapath;
        String visualpathString = this.localvisualpath + catapath;
        File diskpath = new File(pathString);
        if (!diskpath.exists()) {
            diskpath.mkdirs();
        }
        String diskfilepath = diskpath.getAbsolutePath() + "/" + filename;
        File diskfile = this.filehelper.generFile(diskfilepath);
        String visualfilepath = visualpathString + diskfile.getName();
        try {
            file.transferTo(diskfile);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        fileID = visualfilepath;
        return fileID;
    }

    @Override
    public FileInfo downloadFile(FileInfo fileinfo) throws FileStoreException {
        String pathString = "D:/TOMCAT-TAIMP/webapps/defaultroot/";
        String visualpathString = "/defaultroot/";
        String filepath = fileinfo.getUUID().replaceFirst(this.localvisualpath, this.localpath);
        File file = new File(filepath);
        if (this.filehelper.hasPermissions()) {
            try {
                fileinfo.setIs(new FileInputStream(file));
                fileinfo.setFilesize(file.length());
                return fileinfo;
            }
            catch (FileNotFoundException e) {
                throw new FileStoreException("\u6587\u4ef6:" + fileinfo.getUUID() + " \u672a\u627e\u5230!", e);
            }
        }
        return null;
    }

    public File downloadhelpFile(String filename) throws FileStoreException {
        String pathString = this.localpath;
        String visualpathString = this.localvisualpath;
        String filepath = filename.replaceFirst(visualpathString, pathString);
        File file = new File(filepath);
        return file;
    }

    @Override
    public FileInfo viewFile(FileInfo fileinfo) throws FileStoreException {
        return null;
    }

    @Override
    public boolean deleteFile(FileInfo fileinfo) throws FileStoreException {
        return false;
    }

    @Override
    public void replaceFile(MultipartFile file, FileInfo fileinfo) throws FileStoreException {
    }

    @Override
    public List<String> searchFile(FileInfo fileinfo) throws FileStoreException {
        return null;
    }

    @Override
    public boolean exist(FileInfo fileinfo) throws FileStoreException {
        String pathString = "D:/TOMCAT-TAIMP/webapps/defaultroot/";
        String visualpathString = "/defaultroot/";
        String filepath = fileinfo.getUUID().replaceFirst(this.localvisualpath, this.localpath);
        File file = new File(filepath);
        return file != null && file.exists();
    }

    @Override
    public Map<String, String> searchFileWithExcerpt(FileInfo fileinfo) throws FileStoreException {
        return null;
    }
}

