/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.doc.common.ocr;

import com.baidu.aip.client.BaseClient;
import com.baidu.aip.contentcensor.EImgType;
import com.baidu.aip.error.AipError;
import com.baidu.aip.http.AipRequest;
import com.baidu.aip.util.Base64Util;
import com.baidu.aip.util.Util;
import java.io.IOException;
import java.util.Calendar;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class AipOcr
extends BaseClient {
    public AipOcr(String appId, String apiKey, String secretKey) {
        super(appId, apiKey, secretKey);
    }

    public JSONObject basicGeneral(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/general_basic");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject basicGeneral(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.basicGeneral(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject basicGeneralUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", (Object)url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/general_basic");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject basicAccurateGeneral(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/accurate_basic");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject basicAccurateGeneral(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.basicAccurateGeneral(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject general(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/general");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject general(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.general(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject generalUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", (Object)url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/general");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject accurateGeneral(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/accurate");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject accurateGeneral(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.accurateGeneral(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject enhancedGeneral(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/general_enhanced");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject enhancedGeneral(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.enhancedGeneral(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject enhancedGeneralUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", (Object)url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/general_enhanced");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject webImage(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/webimage");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject webImage(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.webImage(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject webImageUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", (Object)url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/webimage");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject idcard(byte[] image, String idCardSide, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        request.addBody("id_card_side", (Object)idCardSide);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/idcard");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject idcard(String image, String idCardSide, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.idcard(data, idCardSide, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject bankcard(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/bankcard");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject bankcard(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.bankcard(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject drivingLicense(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/driving_license");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject drivingLicense(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.drivingLicense(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject vehicleLicense(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/vehicle_license");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vehicleLicense(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.vehicleLicense(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject plateLicense(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/license_plate");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject plateLicense(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.plateLicense(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject businessLicense(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/business_license");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject businessLicense(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.businessLicense(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject receipt(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/receipt");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject receipt(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.receipt(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject trainTicket(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/train_ticket");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject trainTicket(String image, EImgType type, HashMap<String, String> options) {
        return this.ocrByUrlOrFile(image, type, "https://aip.baidubce.com/rest/2.0/ocr/v1/train_ticket", options);
    }

    public JSONObject taxiReceipt(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/taxi_receipt");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject taxiReceipt(String image, EImgType type, HashMap<String, String> options) {
        return this.ocrByUrlOrFile(image, type, "https://aip.baidubce.com/rest/2.0/ocr/v1/taxi_receipt", options);
    }

    public JSONObject form(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/form");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject form(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.form(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject tableRecognitionAsync(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/solution/v1/form_ocr/request");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject tableRecognitionAsync(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.tableRecognitionAsync(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject tableResultGet(String requestId, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("request_id", (Object)requestId);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/solution/v1/form_ocr/get_request_result");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vinCode(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/vin_code");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vinCode(String image, EImgType type, HashMap<String, String> options) {
        return this.ocrByUrlOrFile(image, type, "https://aip.baidubce.com/rest/2.0/ocr/v1/vin_code", options);
    }

    public JSONObject quotaInvoice(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/quota_invoice");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject quotaInvoice(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.quotaInvoice(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject householdRegister(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/household_register");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject householdRegister(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.householdRegister(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject HKMacauExitentrypermit(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/HK_Macau_exitentrypermit");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject HKMacauExitentrypermit(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.HKMacauExitentrypermit(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject taiwanExitentrypermit(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/taiwan_exitentrypermit");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject taiwanExitentrypermit(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.taiwanExitentrypermit(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject birthCertificate(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/birth_certificate");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject birthCertificate(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.birthCertificate(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject vehicleInvoice(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/vehicle_invoice");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vehicleInvoice(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.vehicleInvoice(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject vehicleCertificate(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/vehicle_certificate");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vehicleCertificate(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.vehicleCertificate(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject invoice(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/invoice");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject invoice(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.invoice(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject airTicket(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/air_ticket");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject airTicket(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.airTicket(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject insuranceDocuments(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/insurance_documents");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject insuranceDocuments(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.insuranceDocuments(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject vatInvoice(String image, EImgType type, HashMap<String, String> options) {
        if (type == EImgType.PDF) {
            AipRequest request = new AipRequest();
            this.preOperation(request);
            if (options != null) {
                request.addBody(options);
            }
            try {
                byte[] data = Util.readFileByBytes((String)image);
                String base64Content = Base64Util.encode((byte[])data);
                request.addBody("pdf_file", (Object)base64Content);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/vat_invoice");
            this.postOperation(request);
            return this.requestServer(request);
        }
        return this.ocrByUrlOrFile(image, type, "https://aip.baidubce.com/rest/2.0/ocr/v1/vat_invoice", options);
    }

    public JSONObject vatInvoice(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/vat_invoice");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vatInvoice(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.vatInvoice(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject qrcode(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/qrcode");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject qrcode(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.qrcode(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject numbers(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/numbers");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject numbers(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.numbers(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject lottery(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/lottery");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject lottery(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.lottery(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject passport(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/passport");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject passport(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.passport(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject businessCard(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/business_card");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject businessCard(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.businessCard(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject handwriting(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/handwriting");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject handwriting(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.handwriting(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject custom(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/solution/v1/iocr/recognise");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject custom(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.custom(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject getTableRecognitionJsonResult(String requestId) {
        return this.getTableResultHelper(requestId, "json");
    }

    public JSONObject getTableRecognitionExcelResult(String requestId) {
        return this.getTableResultHelper(requestId, "excel");
    }

    private JSONObject getTableResultHelper(String requestId, String resultType) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("request_id", (Object)requestId);
        request.addBody("result_type", (Object)resultType);
        request.setUri("https://aip.baidubce.com/rest/2.0/solution/v1/form_ocr/get_request_result");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject tableRecognizeToJson(String imgPath, long timeoutMiliseconds) {
        try {
            byte[] imgData = Util.readFileByBytes((String)imgPath);
            return this.tableRecognizeToJson(imgData, timeoutMiliseconds);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject tableRecognizeToJson(byte[] imgData, long timeoutMiliseconds) {
        return this.tableRecSyncHelper(imgData, timeoutMiliseconds, "json");
    }

    public JSONObject tableRecognizeToExcelUrl(String imgPath, long timeoutMiliseconds) {
        try {
            byte[] imgData = Util.readFileByBytes((String)imgPath);
            return this.tableRecognizeToExcelUrl(imgData, timeoutMiliseconds);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject tableRecognizeToExcelUrl(byte[] imgData, long timeoutMiliseconds) {
        return this.tableRecSyncHelper(imgData, timeoutMiliseconds, "excel");
    }

    private JSONObject tableRecSyncHelper(byte[] imgData, long timeout, String resultType) {
        JSONObject res = this.tableRecognitionAsync(imgData, null);
        if (res.has("error_code")) {
            return res;
        }
        try {
            String reqId = res.getJSONArray("result").getJSONObject(0).getString("request_id");
            long start = Calendar.getInstance().getTimeInMillis();
            long sleepInterval = 2000L;
            while (true) {
                long now;
                if ((now = Calendar.getInstance().getTimeInMillis()) - start > timeout) {
                    return AipError.ASYNC_TIMEOUT_ERROR.toJsonResult();
                }
                JSONObject result = this.getTableResultHelper(reqId, resultType);
                if (result.has("error_code")) {
                    return result;
                }
                int retCode = result.getJSONObject("result").getInt("ret_code");
                if (retCode == 3) {
                    return result;
                }
                try {
                    Thread.sleep(sleepInterval);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (JSONException e1) {
            e1.printStackTrace();
            return new JSONObject();
        }
    }

    public JSONObject docAnalysis(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.docAnalysis(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject docAnalysis(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/doc_analysis");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject meter(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.meter(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject meter(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/meter");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject webimageLoc(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.webimageLoc(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject webimageLoc(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/webimage_loc");
        this.postOperation(request);
        return this.requestServer(request);
    }

    private JSONObject ocrByUrlOrFile(String image, EImgType type, String targetUrl, HashMap<String, String> options) {
        if (type == EImgType.FILE) {
            return this.ocrByFile(image, targetUrl, options);
        }
        return this.ocrByUrl(image, targetUrl, options);
    }

    private JSONObject ocrByUrl(String imageUrl, String targetUrl, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", (Object)imageUrl);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri(targetUrl);
        this.postOperation(request);
        return this.requestServer(request);
    }

    private JSONObject ocrByFile(String image, String targetUrl, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        try {
            byte[] data = Util.readFileByBytes((String)image);
            String base64Content = Base64Util.encode((byte[])data);
            request.addBody("image", (Object)base64Content);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
        if (options != null) {
            request.addBody(options);
        }
        request.setUri(targetUrl);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject qrcodeUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", (Object)url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/qrcode");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject docAnalysisUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", (Object)url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/doc_analysis");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vehicleInvoiceUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", (Object)url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/vehicle_invoice");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vehicleCertificateUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", (Object)url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/vehicle_certificate");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject householdRegisterUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", (Object)url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/household_register");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject handwritingUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", (Object)url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/handwriting");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject airTicketUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", (Object)url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/air_ticket");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject invoiceUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", (Object)url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/invoice");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject passportUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", (Object)url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/passport");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject multipleInvoice(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode((byte[])image);
        request.addBody("image", (Object)base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/multiple_invoice");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject multipleInvoice(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes((String)image);
            return this.multipleInvoice(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject multipleInvoice(String image, EImgType type, HashMap<String, String> options) {
        if (type == EImgType.PDF) {
            AipRequest request = new AipRequest();
            this.preOperation(request);
            if (options != null) {
                request.addBody(options);
            }
            try {
                byte[] data = Util.readFileByBytes((String)image);
                String base64Content = Base64Util.encode((byte[])data);
                request.addBody("pdf_file", (Object)base64Content);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/multiple_invoice");
            this.postOperation(request);
            return this.requestServer(request);
        }
        return this.ocrByUrlOrFile(image, type, "https://aip.baidubce.com/rest/2.0/ocr/v1/multiple_invoice", options);
    }
}

