/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.doc.common.convert;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.ComThread;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import com.ustc.doc.common.convert.OfficeToPDFInfo;
import java.io.File;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import org.apache.commons.io.FilenameUtils;

public class MSOfficeToPDFUtils {
    private static final int wdFormatPDF = 17;
    private static final int xlTypePDF = 0;
    private static final int ppSaveAsPDF = 32;

    public static int officeToPdf(String sourceFile, String destFile) {
        String extentionName;
        File inputFile = new File(sourceFile);
        if (!inputFile.exists()) {
            return -1;
        }
        File outputFile = new File(destFile);
        if (!outputFile.getParentFile().exists()) {
            outputFile.getParentFile().mkdirs();
        }
        if ((extentionName = FilenameUtils.getExtension((String)sourceFile)).equalsIgnoreCase("ppt") || extentionName.equalsIgnoreCase("pptx")) {
            MSOfficeToPDFUtils.ppt2pdf(sourceFile, destFile);
        } else if (extentionName.equalsIgnoreCase("doc") || extentionName.equalsIgnoreCase("docx")) {
            MSOfficeToPDFUtils.doc2pdf(sourceFile, destFile);
        } else if (extentionName.equalsIgnoreCase("xls") || extentionName.equalsIgnoreCase("xlsx")) {
            MSOfficeToPDFUtils.excel2PDF(sourceFile, destFile);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean doc2pdf(String srcFilePath, String pdfFilePath) {
        boolean bl;
        ActiveXComponent app;
        block5: {
            app = null;
            Dispatch doc = null;
            try {
                ComThread.InitSTA();
                app = new ActiveXComponent("Word.Application");
                app.setProperty("Visible", false);
                Dispatch docs = app.getProperty("Documents").toDispatch();
                doc = Dispatch.invoke((Dispatch)docs, (String)"Open", (int)1, (Object[])new Object[]{srcFilePath, new Variant(false), new Variant(true), new Variant(false), new Variant((Object)"pwd")}, (int[])new int[1]).toDispatch();
                Dispatch.put((Dispatch)doc, (String)"RemovePersonalInformation", (Object)false);
                Dispatch.call((Dispatch)doc, (String)"ExportAsFixedFormat", (Object[])new Object[]{pdfFilePath, 17});
                bl = true;
                if (doc == null) break block5;
            }
            catch (Throwable throwable) {
                if (doc != null) {
                    Dispatch.call(doc, (String)"Close", (Object[])new Object[]{false});
                }
                if (app != null) {
                    app.invoke("Quit", 0);
                }
                ComThread.Release();
                throw throwable;
            }
            Dispatch.call((Dispatch)doc, (String)"Close", (Object[])new Object[]{false});
        }
        if (app != null) {
            app.invoke("Quit", 0);
        }
        ComThread.Release();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean ppt2pdf(String srcFilePath, String pdfFilePath) {
        boolean bl;
        ActiveXComponent app;
        block5: {
            app = null;
            Dispatch ppt = null;
            try {
                ComThread.InitSTA();
                app = new ActiveXComponent("PowerPoint.Application");
                Dispatch ppts = app.getProperty("Presentations").toDispatch();
                ppt = Dispatch.call((Dispatch)ppts, (String)"Open", (Object[])new Object[]{srcFilePath, true, true, false}).toDispatch();
                Dispatch.call((Dispatch)ppt, (String)"SaveAs", (Object[])new Object[]{pdfFilePath, 32});
                bl = true;
                if (ppt == null) break block5;
            }
            catch (Throwable throwable) {
                if (ppt != null) {
                    Dispatch.call(ppt, (String)"Close");
                }
                if (app != null) {
                    app.invoke("Quit");
                }
                ComThread.Release();
                throw throwable;
            }
            Dispatch.call((Dispatch)ppt, (String)"Close");
        }
        if (app != null) {
            app.invoke("Quit");
        }
        ComThread.Release();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean excel2PDF(String inputFile, String pdfFile) {
        boolean bl;
        ActiveXComponent app;
        block5: {
            app = null;
            Dispatch excel = null;
            try {
                ComThread.InitSTA();
                app = new ActiveXComponent("Excel.Application");
                app.setProperty("Visible", false);
                Dispatch excels = app.getProperty("Workbooks").toDispatch();
                excel = Dispatch.call((Dispatch)excels, (String)"Open", (Object[])new Object[]{inputFile, false, true}).toDispatch();
                Dispatch.call((Dispatch)excel, (String)"ExportAsFixedFormat", (Object[])new Object[]{0, pdfFile});
                bl = true;
                if (excel == null) break block5;
            }
            catch (Throwable throwable) {
                if (excel != null) {
                    Dispatch.call(excel, (String)"Close");
                }
                if (app != null) {
                    app.invoke("Quit");
                }
                ComThread.Release();
                throw throwable;
            }
            Dispatch.call((Dispatch)excel, (String)"Close");
        }
        if (app != null) {
            app.invoke("Quit");
        }
        ComThread.Release();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean printFile(String srcFilePath) {
        ActiveXComponent app = null;
        try {
            ComThread.InitSTA();
            app = new ActiveXComponent("Word.Application");
            Dispatch document = app.getProperty("Documents").toDispatch();
            Dispatch doc = Dispatch.invoke((Dispatch)document, (String)"Open", (int)1, (Object[])new Object[]{srcFilePath}, (int[])new int[1]).toDispatch();
            app.setProperty("ActivePrinter", new Variant((Object)"Microsoft XPS Document Writer v4"));
            Dispatch.callN((Dispatch)doc, (String)"PrintOut", (Object[])new Object[0]);
            boolean bl = true;
            return bl;
        }
        finally {
            if (app != null) {
                app.invoke("Quit");
            }
            ComThread.Release();
        }
    }

    public static void main(String[] args) {
        PrintService[] services;
        OfficeToPDFInfo info = new OfficeToPDFInfo();
        info.setDestUrl("D:\\BaiduYunDownload\\REL-3.1.2.8\\TIMS\u5f71\u50cf\u7cfb\u7edf\u90e8\u7f72\u5b9e\u65bd\u624b\u518c_v3.1.2.6.pdf");
        info.setSourceUrl("D:\\BaiduYunDownload\\REL-3.1.2.8\\TIMS\u5f71\u50cf\u7cfb\u7edf\u90e8\u7f72\u5b9e\u65bd\u624b\u518c_v3.1.2.6.docx");
        for (PrintService p : services = PrintServiceLookup.lookupPrintServices(null, null)) {
            System.out.println(p.getName());
        }
        MSOfficeToPDFUtils.printFile(info.getSourceUrl());
    }
}

