/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.business.hr.service;

import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.service.CommonService;
import com.ustc.business.hr.dao.HrWorkLiveDao;
import com.ustc.business.hr.entity.HrWorkLive;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class HrWorkLiveService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private HrWorkLiveDao hrworkliveDao;

    public HrWorkLive findHrWorkLive(Long id) {
        HrWorkLive entity = (HrWorkLive)this.hrworkliveDao.findById(id).get();
        return entity;
    }

    public void saveHrWorkLive(HrWorkLive entity) {
        this.hrworkliveDao.save(entity);
    }

    public void delHrWorkLive(Long id, Long userId) {
        HrWorkLive entity = (HrWorkLive)this.hrworkliveDao.findById(id).get();
        entity.setIsUse("N");
        entity.setModifyAccount(userId);
        entity.setModifyTime(new Date());
        this.hrworkliveDao.save(entity);
    }

    public PageObject PageAll(String search, int page, int rows, Long empId) {
        PageObject pageobject = new PageObject();
        if (empId == null) {
            return pageobject;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select * from HR_WORK_LIVE t where t.is_use=:isUse ");
        params.put("isUse", "Y");
        if (!StringUtils.isEmpty((String)search)) {
            sql.append("and  (");
            sql.append("  upper(t.WORK_LIVE_ID) like :search ");
            sql.append(" or upper(t.EMP_ID) like :search ");
            sql.append(" or upper(t.START_TIME) like :search ");
            sql.append(" or upper(t.END_TIME) like :search ");
            sql.append(" or upper(t.WORK_UNIT) like :search ");
            sql.append(" or upper(t.DEPT_NAME) like :search ");
            sql.append(" or upper(t.CERTIFICATE) like :search ");
            sql.append(" or upper(t.REMARK) like :search ");
            sql.append(" or upper(t.MODIFY_ACCOUNT) like :search ");
            sql.append(" or upper(t.MODIFY_TIME) like :search ");
            sql.append(" or upper(t.IS_USE) like :search ");
            sql.append(" or upper(t.CERTIFIER) like :search ");
            sql.append(" or upper(t.TELEPHONE) like :search ");
            sql.append(")");
            params.put("search", "%" + search.toUpperCase().replace("%", "/%") + "%");
        }
        sql.append("and t.EMP_ID=:empId");
        params.put("empId", empId);
        sql.append(" order by t.WORK_LIVE_ID");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }
}

