/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.business.hr.service;

import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.service.CommonService;
import com.ustc.business.hr.dao.HrTrainingLiveDao;
import com.ustc.business.hr.entity.HrTrainingLive;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class HrTrainingLiveService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private HrTrainingLiveDao hrtrainingliveDao;

    public HrTrainingLive findHrTrainingLive(Long id) {
        HrTrainingLive entity = (HrTrainingLive)this.hrtrainingliveDao.findById(id).get();
        return entity;
    }

    public void saveHrTrainingLive(HrTrainingLive entity) {
        this.hrtrainingliveDao.save(entity);
    }

    public void delHrTrainingLive(Long id, Long userId) {
        HrTrainingLive entity = (HrTrainingLive)this.hrtrainingliveDao.findById(id).get();
        entity.setIsUse("N");
        entity.setModifyAccount(userId);
        entity.setModifyTime(new Date());
        this.hrtrainingliveDao.save(entity);
    }

    public PageObject PageAll(String search, int page, int rows, Long empId) {
        PageObject pageobject = new PageObject();
        if (empId == null) {
            return pageobject;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select DISTINCT t.*,\n");
        sql.append(" t.END_TIME-t.START_TIME as TIME \n");
        sql.append("from HR_TRAINING_LIVE t \n");
        sql.append("    WHERE t.is_use = :isUse ");
        params.put("isUse", "Y");
        if (!StringUtils.isEmpty((String)search)) {
            sql.append("and  (");
            sql.append("  upper(t.TRAINING_LIVE_ID) like :search ");
            sql.append(" or upper(t.EMP_ID) like :search ");
            sql.append(" or upper(t.START_TIME) like :search ");
            sql.append(" or upper(t.END_TIME) like :search ");
            sql.append(" or upper(t.TRAINING_CONTENT) like :search ");
            sql.append(" or upper(t.TRAINING_ORG) like :search ");
            sql.append(" or upper(t.TRAINING_CERTIFICATE) like :search ");
            sql.append(" or upper(t.RETERENCE) like :search ");
            sql.append(" or upper(t.REMARK) like :search ");
            sql.append(" or upper(t.MODIFY_ACCOUNT) like :search ");
            sql.append(" or upper(t.MODIFY_TIME) like :search ");
            sql.append(" or upper(t.IS_USE) like :search ");
            sql.append(")");
            params.put("search", "%" + search.toUpperCase().replace("%", "/%") + "%");
        }
        sql.append("and t.EMP_ID=:empId");
        params.put("empId", empId);
        sql.append(" order by t.TRAINING_LIVE_ID");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }
}

