/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.business.hr.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.business.hr.dao.HrSettingsDao;
import com.ustc.business.hr.entity.HrSettings;
import com.ustc.gen.util.DBPropertyUtil;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class HrSettingsService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private HrSettingsDao hrsettingsDao;

    public HrSettings findHrSettings(Long id) {
        HrSettings entity = (HrSettings)this.hrsettingsDao.findById(id).get();
        return entity;
    }

    public void saveHrSettings(HrSettings entity) {
        this.hrsettingsDao.save(entity);
    }

    public HrSettings findByOrgId(Long orgId) {
        return this.hrsettingsDao.findByOrgIdAndIsUse(orgId, "Y");
    }

    public void delHrSettings(Long id) {
        HrSettings entity = (HrSettings)this.hrsettingsDao.findById(id).get();
        entity.setIsUse("N");
        this.hrsettingsDao.save(entity);
    }

    public PageObject PageAll(String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase().replace("%", "/%") + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        return this.bSqlHelper.serachPage("business.hr.HrSettings.select", params, PageRequest.of((int)page, (int)rows));
    }
}

