/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.business.hr.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ustc.app.common.AppPush;
import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.DateUtils;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.dao.BasDicDao;
import com.ustc.base.dao.BasEmpAccountDao;
import com.ustc.base.dao.BasEmpDao;
import com.ustc.base.entity.BasDic;
import com.ustc.base.entity.BasEmp;
import com.ustc.base.entity.BasEmpAccount;
import com.ustc.base.service.BasMessageService;
import com.ustc.base.service.CommonService;
import com.ustc.business.hr.dao.HrEmpDao;
import com.ustc.business.hr.entity.ExcelHrEmpEntity;
import com.ustc.business.hr.entity.HrEducationLive;
import com.ustc.business.hr.entity.HrEmp;
import com.ustc.business.hr.entity.HrFamilyMember;
import com.ustc.business.hr.entity.HrProtectScopt;
import com.ustc.business.hr.entity.HrSettings;
import com.ustc.business.hr.entity.HrTrainingLive;
import com.ustc.business.hr.entity.HrWorkLive;
import com.ustc.business.hr.service.HrDeptPostService;
import com.ustc.business.hr.service.HrEducationLiveService;
import com.ustc.business.hr.service.HrFamilyMemberService;
import com.ustc.business.hr.service.HrProtectScoptService;
import com.ustc.business.hr.service.HrSettingsService;
import com.ustc.business.hr.service.HrTrainingLiveService;
import com.ustc.business.hr.service.HrWorkLiveService;
import com.ustc.business.hr.service.excel.ExcelExportUtil;
import com.ustc.doc.common.FileService;
import com.ustc.doc.common.persist.FileInfo;
import com.ustc.doc.entity.FormFileBean;
import com.ustc.doc.service.DocFormFileService;
import com.ustc.sys.util.ListUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.jeecgframework.poi.excel.entity.TemplateExportParams;
import org.jeecgframework.poi.excel.export.styler.ExcelExportStylerDefaultImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Component
@Transactional
public class HrEmpService {
    @Autowired
    private CommonService commonService;
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private HrEmpDao hrempDao;
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private DocFormFileService docFormFileService;
    @Autowired
    private HrEducationLiveService hreducationliveService;
    @Autowired
    private HrTrainingLiveService hrtrainingliveService;
    @Autowired
    private HrWorkLiveService hrworkliveService;
    @Autowired
    private HrFamilyMemberService hrfamilymemberService;
    @Autowired
    private HrDeptPostService hrDeptPostService;
    @Autowired
    private HrSettingsService hrSettingsService;
    @Autowired
    private HrProtectScoptService hrprotectscoptService;
    @Autowired
    private BasMessageService msgService;
    @Autowired
    private BasEmpDao basEmpDao;
    @Autowired
    private BasEmpAccountDao basEmpAccountDao;
    @Autowired
    private FileService fileService;
    @Autowired
    private BasDicDao basDicDao;

    public HrEmp findHrEmp(Long id) {
        HrEmp entity = (HrEmp)this.hrempDao.findById(id).get();
        return entity;
    }

    public List<HrEmp> findHrEmpAllByOrgId(Long OrgId) {
        List<HrEmp> list = this.hrempDao.findByOrgIdAndIsUseOrderByDisplayNoAsc(OrgId, "Y");
        return list;
    }

    public HrEmp findByEmpName(String empName, String deptName) {
        int num;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("empName", empName);
        if (StringUtils.isNotBlank((String)deptName)) {
            params.put("deptName", deptName);
        }
        if ((num = this.bSqlHelper.getIntValue("business.hr.HrEmp.findByEmpName", params).intValue()) == 1) {
            return this.hrempDao.findByEmpNameAndIsUse(empName, "Y");
        }
        return this.bSqlHelper.getEntity("business.hr.HrEmp.findByEmpName1", params, HrEmp.class);
    }

    public HrEmp findByEmpCode(String empCode) {
        return this.hrempDao.findByEmpCodeAndIsUse(empCode, "Y");
    }

    public void birthdayRemind() {
        JSONObject json;
        String wishWord = "\u4eca\u5929\u662f\u4f60\u7684\u751f\u65e5\uff0c\u795d\u4f60\u751f\u65e5\u5feb\u4e50\uff01\u6211\u4eec\u4e00\u8d77\u7ed9\u4f60\u4e00\u4e2a\u5927\u7684\u62e5\u62b1\uff0c\u9001\u4e0a\u6e29\u6696\u7684\u795d\u798f\uff0c\u613f\u8fc7\u53bb\u4e00\u5e74\u91cc\u4f60\u6240\u6709\u7684\u52aa\u529b\u548c\u4ed8\u51fa\uff0c\u90fd\u80fd\u5728\u4eca\u5929\u5316\u4f5c\u6210\u957f\u7684\u795d\u798f\uff0c\u5d2d\u65b0\u7684\u4e00\u5e74\uff0c\u671f\u5f85\u6211\u4eec\u4e00\u8def\u540c\u884c\u3002";
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("business.hr.HrEmp.getCurMonthBirth", MapUtil.of((Object)"", (Object)""));
        for (Map<String, Object> map : list) {
            json = new JSONObject();
            json.put("businessMainId", map.get("accountId"));
            json.put("formCode", (Object)"birthday");
            json.put("wishWord", (Object)wishWord);
            json.put("age", map.get("age"));
            AppPush.pushToList("\u60a8\u6709\u4e00\u6761\u65b0\u7684\u6d88\u606f", "\u751f\u65e5\u795d\u798f", json.toJSONString(), CollUtil.newArrayList((Object[])new String[]{map.get("clientId").toString()}));
        }
        wishWord = "\u4eca\u5929\u662f\u4f60\u52a0\u5165\u516c\u53f8\u7684\u7b2c%s\u5e74\uff01\u6211\u4eec\u4e00\u8d77\u7ed9\u4f60\u4e00\u4e2a\u5927\u7684\u62e5\u62b1\uff0c\u9001\u4e0a\u6e29\u6696\u7684\u795d\u798f\uff0c\u613f\u8fc7\u53bb\u4e00\u5e74\u91cc\u4f60\u6240\u6709\u7684\u52aa\u529b\u548c\u4ed8\u51fa\uff0c\u90fd\u80fd\u5728\u4eca\u5929\u5316\u4f5c\u6210\u957f\u7684\u795d\u798f\uff0c\u5d2d\u65b0\u7684\u4e00\u5e74\uff0c\u671f\u5f85\u6211\u4eec\u4e00\u8def\u540c\u884c\u3002";
        list = this.bSqlHelper.getMapList("business.hr.HrEmp.getCurMonthEntry", MapUtil.of((Object)"", (Object)""));
        for (Map<String, Object> map : list) {
            json = new JSONObject();
            json.put("businessMainId", map.get("accountId"));
            json.put("formCode", (Object)"anniversary");
            json.put("wishWord", (Object)String.format(wishWord, map.get("age").toString()));
            json.put("age", map.get("age"));
            AppPush.pushToList("\u60a8\u6709\u4e00\u6761\u65b0\u7684\u6d88\u606f", "\u5165\u804c\u5468\u5e74\u5e86", json.toJSONString(), CollUtil.newArrayList((Object[])new String[]{map.get("clientId").toString()}));
        }
        wishWord = "\u4eca\u5929\u662f\u4f60\u5165\u515a\u7b2c%s\u5e74\uff01\u5e0c\u671b\u4f60\u80fd\u4e0d\u5fd8\u521d\u5fc3\uff0c\u7262\u8bb0\u4f7f\u547d\uff0c\u7ee7\u7eed\u4e3a\u4eba\u6c11\u670d\u52a1\uff01";
        list = this.bSqlHelper.getMapList("business.dj.PartyMemberInfo.getPartyMemberByMonth", MapUtil.of((Object)"", (Object)""));
        for (Map<String, Object> map : list) {
            ArrayList<Long> accountIds = new ArrayList<Long>();
            long accountId = Long.parseLong(map.get("accountId").toString());
            String accountName = Objects.toString(map.get("accountName"), "");
            String joinDate = Objects.toString(map.get("joinDate"), "");
            accountIds.add(accountId);
            String msgTitle = String.format(wishWord, map.get("age").toString());
            String msgUrl = "/view/business/dj/PartyJoinWish?accountName=" + accountName + "&joinDate=" + joinDate;
            this.msgService.saveMessage(null, null, msgTitle, null, 0L, accountIds, msgUrl, "3", "PartyMemberInfo", "1", null, null, true);
        }
    }

    public void saveHrEmp(HrEmp entity, String userId) {
        this.hrempDao.save(entity);
        BasEmp basEmp = this.basEmpDao.findByHrEmpIdAndIsUse(entity.getEmpId(), "Y");
        if (basEmp != null) {
            basEmp.setDeptId(entity.getDeptId());
            basEmp.setOrgId(entity.getOrgId());
            this.basEmpDao.save(basEmp);
            List<BasEmpAccount> accounts = this.basEmpAccountDao.findByEmpIdAndIsUse(basEmp.getEmpId(), "Y");
            if (accounts.size() == 1) {
                accounts.forEach(account -> {
                    account.setDeptId(entity.getDeptId());
                    account.setOrgId(entity.getOrgId());
                });
                this.basEmpAccountDao.saveAll(accounts);
            }
        }
        this.hrprotectscoptService.deleteByEmpId(entity.getEmpId());
        if (!StringUtils.isEmpty((String)userId)) {
            for (String id : userId.split(",")) {
                HrProtectScopt info = new HrProtectScopt();
                String[] idArray = id.split(":");
                info.setEmpId(entity.getEmpId());
                info.setUserType(idArray[0]);
                info.setUserId(Long.parseLong(idArray[1]));
                info.setModifyAccount(SysUtils.getLoginAccountId());
                info.setModifyTime(new Date());
                info.setIsUse("Y");
                info.setCreateAccount(SysUtils.getLoginAccountId());
                info.setCreateTime(new Date());
                this.hrprotectscoptService.saveHrProtectScopt(info);
            }
        }
    }

    public void saveHrEmp(HrEmp entity) {
        this.hrempDao.save(entity);
    }

    public void delHrEmp(Long id) {
        HrEmp entity = (HrEmp)this.hrempDao.findById(id).get();
        entity.setIsUse("C");
        entity.setQuitTime(new Date());
        entity.setStatus("3");
        BasEmp basEmp = this.basEmpDao.findByHrEmpIdAndIsUse(id, "Y");
        if (basEmp != null) {
            basEmp.setStatus("3");
            basEmp.setIsUse("N");
            this.basEmpDao.save(basEmp);
        }
        this.hrempDao.save(entity);
    }

    public PageObject pageAllEmp(String isWin, String topEducation, Date borndaya, Date borndayb, String politicalStatus, String empPropStatus, String nationStatus, String status, Long orgid, Long deptid, String orgbirth, String birth, String professionalTitle, String search, int page, int rows, String sort, String order, Long org, Date workTimeStart, Date workTimeEnd, Long login, String name) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        HrSettings hrSettings = this.hrSettingsService.findByOrgId(org);
        String mgrProtect = "Y";
        if (hrSettings != null && StringUtils.isNotBlank((String)hrSettings.getMgrProtect())) {
            mgrProtect = hrSettings.getMgrProtect();
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select DISTINCT t.*,(case t.is_use when 'C' then '\u6ce8\u9500' else '\u5728\u518c' end)IS_USE_TEXT_,\n");
        sql.append("CASE\n  when t.MOBILEPHONE is not null  AND t.is_protect = 'Y' AND :login NOT IN  ( SELECT\r\n\tUSER_ID \r\nFROM\r\n\tHR_PROTECT_SCOPT \r\nWHERE\r\n\tUSER_TYPE = 'user' \r\n\tAND IS_USE = 'Y' AND EMP_ID=t.EMP_ID UNION\r\n\tSELECT ACCOUNT_ID as USER_ID  FROM BAS_EMP_ACCOUNT WHERE DEPT_ID IN(\r\nSELECT\r\n\tUSER_ID \r\nFROM\r\n\tHR_PROTECT_SCOPT WHERE USER_TYPE = 'dept' \r\n\tAND IS_USE = 'Y' AND  EMP_ID=t.EMP_ID ) UNION \r\n\tSELECT ACCOUNT_ID as USER_ID  FROM BAS_EMP_ACCOUNT WHERE ORG_ID IN(\r\nSELECT\r\n\tUSER_ID \r\nFROM\r\n\tHR_PROTECT_SCOPT WHERE USER_TYPE = 'org' \r\n\tAND IS_USE = 'Y' AND EMP_ID=t.EMP_ID  ) ) then concat(substr(t.MOBILEPHONE,0,7),'****')\n  else t.MOBILEPHONE\nend MOBILEPHONE_TEXT,\n");
        sql.append(" DATE_FORMAT(t.birthday,'%Y-%m-%d') birthday_f,\n");
        sql.append(" (select s.STATION_name from HR_STATION_LEVEL s where s.id = t.STATION)STATION_TEXT,\n");
        sql.append(" (select s.STATION_name from HR_STATION_LEVEL s where s.id = t.STATION_level)STATION_level_TEXT,\n");
        sql.append(" DATE_FORMAT(t.work_Time,'%Y-%m') work_Time_f,\n");
        sql.append(" DATE_FORMAT(t.entry_Time,'%Y-%m-%d') entry_Time_f,\n");
        sql.append("floor(PERIOD_DIFF(DATE_FORMAT(SYSDATE(),'%Y%m'),DATE_FORMAT(birthday,'%Y%m')) / 12) bornday,\n");
        sql.append(" c.sort shi,a.display_no xian,t.display_no chu,a.dept_name dept_name,c.abbr org_name,b.DIC_TEXT, \n");
        sql.append(" GETDICNAME('STAFF_STATUS',t.status) as status_TEXT_ ,\n");
        sql.append(" ep.post_name as PRESENT_JOB_TEXT_ \n");
        sql.append(" from hr_emp t \n");
        sql.append(" left join bas_dept a on a.dept_id=t.dept_id\n");
        sql.append(" left join bas_org c on c.org_id=t.org_id\n");
        sql.append(" left join (select emp.emp_id, GROUP_CONCAT(p.post_name) post_name \n");
        sql.append("   from (SELECT cp.emp_id, \n");
        sql.append("   REGEXP_SUBSTR(cp.present_job, '[^,]+', 1, L) AS ES_GROUP, L \n");
        sql.append("   FROM hr_emp CP, \n");
        sql.append("      (SELECT (@rownum\\:=@rownum+1 ) AS L FROM (SELECT @rownum\\:=0)r,hr_emp LIMIT 10) r\n");
        sql.append("   WHERE L + 1 <= LENGTH(cp.present_job) - LENGTH(REPLACE(cp.present_job, ',','')) + 1 \n");
        sql.append("   order by emp_id) emp\n");
        sql.append("   left join hr_post p on p.post_id = emp.ES_GROUP \n");
        sql.append("    group by emp.emp_id) ep on ep.emp_id = t.emp_id\n ");
        sql.append("LEFT JOIN bas_dic b ON b.DIC_CODE= 'SEX' AND t.sex=b.DIC_VALUE \n");
        sql.append("where t.is_use in ('Y','C') and t.is_visual='N' \n");
        params.put("login", login);
        if (StringUtils.isNotEmpty((String)isWin)) {
            sql.append("and t.emp_id not in (select bas.HR_EMP_ID from bas_emp bas where bas.is_use in ('Y','C') and bas.hr_emp_id is not null)\n");
        }
        if (orgid == null) {
            orgid = SysUtils.getLoginUser().getOrgid();
        }
        sql.append(" and( t.org_id in (with RECURSIVE cte as (    select * from BAS_ORG where org_id = :orgid    union all    select o.* from BAS_ORG o    inner join cte on o.PORG_ID = cte.ORG_ID    )select ORG_ID from cte) or ( t.hr_org in (with RECURSIVE cte as (    select * from BAS_ORG where org_id = :orgid    union all    select o.* from BAS_ORG o    inner join cte on o.PORG_ID = cte.ORG_ID    )select ORG_ID from cte)))");
        params.put("orgid", orgid);
        if (deptid != null) {
            sql.append(" and t.dept_id in (with RECURSIVE cte as (    select * from BAS_DEPT where dept_id = :deptid    union all    select o.* from BAS_DEPT o    inner join cte on o.pdept_id = cte.dept_id    )select dept_id from cte)");
            params.put("deptid", deptid);
        }
        if (StringUtils.isNotBlank((String)politicalStatus)) {
            sql.append(" and t.POLITICAL_STAT =:politicalStatus\n");
            params.put("politicalStatus", politicalStatus);
        }
        if (StrKit.notBlank(empPropStatus)) {
            sql.append(" and t.EMP_PROPERTY =:empPropStatus");
            params.put("empPropStatus", empPropStatus);
        }
        if (StrKit.notBlank(nationStatus)) {
            sql.append(" and t.NATION =:nationStatus");
            params.put("nationStatus", nationStatus);
        }
        if (StringUtils.isNotBlank((String)topEducation)) {
            sql.append(" and t.top_Education =:topEducation\n");
            params.put("topEducation", topEducation);
        }
        if (StrKit.notBlank(professionalTitle)) {
            sql.append(" and (t.rank =:professionalTitle ) \n");
            params.put("professionalTitle", professionalTitle);
        }
        if (!StringUtils.isEmpty((String)search)) {
            sql.append(" and ( ");
            sql.append("  upper(t.emp_name) like:search \n");
            sql.append(" or upper(a.abbr) like:search   \n");
            sql.append(" or upper(c.abbr) like:search   \n");
            sql.append(" or upper(b.DIC_TEXT) like:search   \n");
            sql.append(" or upper(t.EMP_CODE) like:search   \n");
            sql.append(" or upper(t.rank) like:search   \n");
            sql.append(" or upper(t.NATIVE_PLACE) like:search   \n");
            sql.append(" or upper(t.PROFESSION) like:search   \n");
            sql.append(" or upper(t.MOBILEPHONE) like:search   \n");
            sql.append(" or upper(t.ID_CARD) like:search   \n");
            sql.append(" or upper(t.GRADUATE_COLL) like:search   \n");
            sql.append(" )   \n");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (StringUtils.isNotBlank((String)orgbirth)) {
            sql.append(" and DATE_FORMAT(t.entry_Time,'%Y-%m') =:orgbirth\n");
            params.put("orgbirth", orgbirth);
        }
        if (StringUtils.isNotBlank((String)birth)) {
            sql.append(" and DATE_FORMAT(t.birthday,'%m') =:birth\n");
            String bir = birth.substring(birth.length() - 2, birth.length());
            params.put("birth", bir);
        }
        if (StringUtils.isNotBlank((String)status)) {
            sql.append(" and t.status =:status\n");
            params.put("status", status);
        } else {
            sql.append(" and t.status <>2 and t.status <>3\n");
        }
        if (StringUtils.isNotBlank((String)name)) {
            sql.append("and t.EMP_NAME  like '%" + name + "%'");
        }
        if (workTimeStart != null) {
            sql.append(" and t.WORK_TIME >=:workTimeStart\n");
            params.put("workTimeStart", workTimeStart);
        }
        if (workTimeEnd != null) {
            sql.append(" and t.WORK_TIME <=:workTimeEnd\n");
            params.put("workTimeEnd", workTimeEnd);
        }
        if (borndaya != null) {
            sql.append(" and t.BIRTHDAY >=:borndaya\n");
            params.put("borndaya", borndaya);
        }
        if (borndayb != null) {
            sql.append(" and t.BIRTHDAY <=:borndayb\n");
            params.put("borndayb", borndayb);
        }
        if (StrKit.notBlank(sort)) {
            String exesql = "select t.* from (" + sql.toString() + ") t " + SysUtils.genOrderBy(" t." + sort, order);
            pageobject = this.sqlHelper.pagerNativeSQL(exesql, params, (Integer)page, (Integer)rows);
        } else {
            sql.append("  order by c.sort, a.display_no ,t.display_no,t.emp_id");
            pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("SEX", "SEX");
        dicmapper.put("POLITICAL_STAT", "POLITICAL_STAT");
        dicmapper.put("TOP_EDUCATION", "ACADEMIC_DEGREE");
        dicmapper.put("TECHNICAL", "TECHNICAL");
        dicmapper.put("NATION", "NATION");
        dicmapper.put("EMP_TYPE", "EMP_TYPE");
        HashMap<String, List<BasDic>> diclists = new HashMap<String, List<BasDic>>();
        List<BasDic> diclist = null;
        for (String column : dicmapper.keySet()) {
            diclist = this.basDicDao.findByDicCodeOrderByDisplayNoAscDicCodeAscDicValueAsc((String)dicmapper.get(column));
            diclists.put(column, diclist);
        }
        return pageobject;
    }

    public boolean checkWorkDate(String workgridrowlist) {
        ArrayList<String> workdateList = new ArrayList<String>();
        if (StrKit.notBlank(workgridrowlist)) {
            JSONArray rows = JSON.parseArray((String)workgridrowlist);
            for (Object o : rows) {
                Map row = (Map)o;
                if (row.get("START_TIME") != null && StrKit.notBlank(row.get("START_TIME").toString())) {
                    workdateList.add(row.get("START_TIME").toString());
                }
                if (row.get("END_TIME") == null || !StrKit.notBlank(row.get("END_TIME").toString())) continue;
                workdateList.add(row.get("END_TIME").toString());
            }
        }
        System.out.println("\u6392\u5e8f\u524d" + workdateList);
        final SimpleDateFormat f = new SimpleDateFormat("yyyy-MM");
        Collections.sort(workdateList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                try {
                    Date d1 = (Date)f.parseObject(o1);
                    Date d2 = (Date)f.parseObject(o2);
                    return d1.compareTo(d2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 0;
                }
            }
        });
        System.out.println("\u6392\u5e8f\u540e" + workdateList);
        for (int i = 0; i < workdateList.size(); ++i) {
            if ((i + 1) % 2 != 0) continue;
            try {
                String stratTime = workdateList.get(i).toString();
                String endTime = workdateList.get(i + 1).toString();
                if (DateUtils.getDatePoorDays(DateUtils.strToMonthDate(endTime), DateUtils.strToMonthDate(stratTime)) <= 31L) continue;
                return false;
            }
            catch (Exception e) {
                System.out.println("\u5de5\u4f5c\u5c65\u5386\u51fa\u9519:" + e.getMessage());
                return false;
            }
        }
        return true;
    }

    public JsonMsg saveHrEmp(HttpServletRequest request, HrEmp hrEmp, FormFileBean formfile, String formcode, String userId) throws ParseException {
        String familygridrowlist;
        String workgridrowlist;
        String traingridrowlist;
        JsonMsg msg = new JsonMsg();
        if (StringUtils.isBlank((String)hrEmp.getIsVisual())) {
            hrEmp.setIsVisual("N");
        }
        this.saveHrEmp(hrEmp, userId);
        msg.setO(hrEmp);
        String edugridrowlist = request.getParameter("edugrid");
        if (StrKit.notBlank(edugridrowlist)) {
            JSONArray rows = JSON.parseArray((String)edugridrowlist);
            for (Object o : rows) {
                Map row = (Map)o;
                HrEducationLive record = new HrEducationLive();
                if (StrKit.notNull(row.get("RETERENCE"))) {
                    record.setReterence(row.get("RETERENCE").toString());
                }
                if (StrKit.notNull(row.get("EDUCATION_LIVE_ID"))) {
                    record.setEducationLiveId(Long.parseLong(row.get("EDUCATION_LIVE_ID").toString()));
                }
                if (StrKit.notBlank(row.get("START_TIME").toString())) {
                    record.setStartTime(DateUtils.strToMonthDate(row.get("START_TIME").toString()));
                }
                if (StrKit.notBlank(row.get("END_TIME").toString())) {
                    record.setEndTime(DateUtils.strToMonthDate(row.get("END_TIME").toString()));
                }
                if (StrKit.notNull(row.get("GRADUATE_COLLEGE"))) {
                    record.setGraduateCollege(row.get("GRADUATE_COLLEGE").toString());
                }
                if (StrKit.notNull(row.get("PROFESSION"))) {
                    record.setProfession(row.get("PROFESSION").toString());
                }
                if (StrKit.notNull(row.get("EDUCATION"))) {
                    record.setEducation(row.get("EDUCATION").toString());
                }
                if (StrKit.notNull(row.get("ACADEMIC_DEGREE"))) {
                    record.setAcademicDegree(row.get("ACADEMIC_DEGREE").toString());
                }
                if (StrKit.notNull(row.get("CERTIFICATE_NO"))) {
                    record.setCertificateNo(row.get("CERTIFICATE_NO").toString());
                }
                if (StrKit.notNull(row.get("REMARK"))) {
                    record.setRemark(row.get("REMARK").toString());
                }
                record.setEmpId(hrEmp.getEmpId());
                record.setIsUse("Y");
                record.setModifyAccount(hrEmp.getModifyAccount());
                record.setModifyTime(new Date());
                this.hreducationliveService.saveHrEducationLive(record);
            }
        }
        if (StrKit.notBlank(traingridrowlist = request.getParameter("traingrid"))) {
            JSONArray rows = JSON.parseArray((String)traingridrowlist);
            for (Object o : rows) {
                Map row = (Map)o;
                HrTrainingLive record = new HrTrainingLive();
                if (StrKit.notNull(row.get("TRAINING_LIVE_ID"))) {
                    record.setTrainingLiveId(Long.parseLong(row.get("TRAINING_LIVE_ID").toString()));
                }
                if (StrKit.notBlank(row.get("START_TIME").toString())) {
                    record.setStartTime(DateUtils.strToMonthDate(row.get("START_TIME").toString()));
                }
                if (StrKit.notBlank(row.get("END_TIME").toString())) {
                    record.setEndTime(DateUtils.strToMonthDate(row.get("END_TIME").toString()));
                }
                if (StrKit.notNull(row.get("TRAINING_CONTENT"))) {
                    record.setTrainingContent(row.get("TRAINING_CONTENT").toString());
                }
                if (StrKit.notNull(row.get("TRAINING_ORG"))) {
                    record.setTrainingOrg(row.get("TRAINING_ORG").toString());
                }
                if (StrKit.notNull(row.get("TRAINING_CERTIFICATE"))) {
                    record.setTrainingCertificate(row.get("TRAINING_CERTIFICATE").toString());
                }
                if (StrKit.notNull(row.get("REMARK"))) {
                    record.setRemark(row.get("REMARK").toString());
                }
                record.setEmpId(hrEmp.getEmpId());
                record.setIsUse("Y");
                record.setModifyAccount(hrEmp.getModifyAccount());
                record.setModifyTime(new Date());
                this.hrtrainingliveService.saveHrTrainingLive(record);
            }
        }
        if (StrKit.notBlank(workgridrowlist = request.getParameter("workgrid"))) {
            JSONArray rows = JSON.parseArray((String)workgridrowlist);
            for (Object o : rows) {
                Map row = (Map)o;
                HrWorkLive record = new HrWorkLive();
                if (StrKit.notNull(row.get("WORK_LIVE_ID"))) {
                    record.setWorkLiveId(Long.parseLong(row.get("WORK_LIVE_ID").toString()));
                }
                if (row.get("START_TIME") != null && StrKit.notBlank(row.get("START_TIME").toString())) {
                    record.setStartTime(DateUtils.strToMonthDate(row.get("START_TIME").toString()));
                }
                if (row.get("END_TIME") != null && StrKit.notBlank(row.get("END_TIME").toString())) {
                    record.setEndTime(DateUtils.strToMonthDate(row.get("END_TIME").toString()));
                }
                if (StrKit.notNull(row.get("WORK_UNIT"))) {
                    record.setWorkUnit(row.get("WORK_UNIT").toString());
                }
                if (StrKit.notNull(row.get("DEPT_NAME"))) {
                    record.setDeptName(row.get("DEPT_NAME").toString());
                }
                if (StrKit.notNull(row.get("CERTIFIER"))) {
                    record.setCertifier(row.get("CERTIFIER").toString());
                }
                if (StrKit.notNull(row.get("TELEPHONE"))) {
                    record.setTelephone(row.get("TELEPHONE").toString());
                }
                if (StrKit.notNull(row.get("REMARK"))) {
                    record.setRemark(row.get("REMARK").toString());
                }
                record.setEmpId(hrEmp.getEmpId());
                record.setIsUse("Y");
                record.setModifyAccount(hrEmp.getModifyAccount());
                record.setModifyTime(new Date());
                this.hrworkliveService.saveHrWorkLive(record);
            }
        }
        if (StrKit.notBlank(familygridrowlist = request.getParameter("familygrid"))) {
            JSONArray rows = JSON.parseArray((String)familygridrowlist);
            for (Object o : rows) {
                Map row = (Map)o;
                HrFamilyMember record = new HrFamilyMember();
                if (StrKit.notNull(row.get("FAMILY_MEMBER_ID"))) {
                    record.setFamilyMemberId(Long.parseLong(row.get("FAMILY_MEMBER_ID").toString()));
                }
                if (StrKit.notNull(row.get("MEMBER_NAME"))) {
                    record.setMemberName(row.get("MEMBER_NAME").toString());
                }
                if (StrKit.notBlank(row.get("BIRTHDAY").toString())) {
                    record.setBirthday(DateUtils.strToDate(row.get("BIRTHDAY").toString()));
                }
                if (StrKit.notBlank(row.get("RELATIONSHIP").toString())) {
                    record.setRelationship(row.get("RELATIONSHIP").toString());
                }
                if (StrKit.notNull(row.get("COMPANY"))) {
                    record.setCompany(row.get("COMPANY").toString());
                }
                if (StrKit.notNull(row.get("TELEPHONE"))) {
                    record.setTelephone(row.get("TELEPHONE").toString());
                }
                if (StrKit.notNull(row.get("REMARK"))) {
                    record.setRemark(row.get("REMARK").toString());
                }
                record.setEmpId(hrEmp.getEmpId());
                record.setIsUse("Y");
                record.setModifyAccount(hrEmp.getModifyAccount());
                record.setModifyTime(new Date());
                this.hrfamilymemberService.saveHrFamilyMember(record);
            }
        }
        formfile.setPrimaryKey(hrEmp.getEmpId());
        formfile.setAccountid(hrEmp.getModifyAccount());
        this.docFormFileService.SaveFormFileBean(formfile);
        if (StringUtils.isNotBlank((String)hrEmp.getPresentJob())) {
            this.hrDeptPostService.saveHrDeptPost(hrEmp);
        }
        return msg;
    }

    public HrEmp findEmpByempId(Long empId) {
        HrEmp emp = (HrEmp)this.hrempDao.findById(empId).get();
        if (emp != null) {
            return emp;
        }
        return new HrEmp();
    }

    public PageObject findEmpBirthdayList(String putMonth, String empNameOrCode, String orgId, String sort, String order) {
        if (putMonth == null || "".equals(putMonth)) {
            return new PageObject();
        }
        String sql = "SELECT '" + putMonth + "' put_month,\n       (SELECT a.org_name\n          FROM bas_org a\n         WHERE a.org_id = t.org_id) org_name,\n       (SELECT a.sort\n          FROM bas_org a\n         WHERE a.org_id = t.org_id) org_no,\n       (SELECT b.dept_name\n          FROM bas_dept b\n         WHERE b.dept_id = t.dept_id) dept_name,\n       (SELECT b.display_no\n          FROM bas_dept b\n         WHERE b.dept_id = t.dept_id) dept_no,\n       t.emp_name,\n       t.emp_code,\n       concat(substr(t.id_card, 7, 4),'-',substr(t.id_card, 11, 2),'-',substr(t.id_card, 13, 2)) birthday,\n       concat(substr(t.id_card, 11, 2),'-',substr(t.id_card, 13, 2)) birthday_time\n  FROM hr_emp t\n WHERE t.emp_type IS NOT NULL\n   AND t.is_use = 'Y'\n   AND t.is_visual = 'N'\n\tAND (t.status is null or t.status = ?)\n    AND substr(t.id_card, 11, 2) = ?\n";
        ArrayList<String> params = new ArrayList<String>();
        params.add("1");
        params.add(putMonth.substring(5, 7));
        if (!StringUtils.isEmpty((String)empNameOrCode)) {
            sql = sql + "   AND concat(t.emp_code,t.emp_name) LIKE ?\n";
            params.add("%" + empNameOrCode + "%");
        }
        if (!StringUtils.isEmpty((String)orgId)) {
            sql = sql + " AND t.org_id = ?\n";
            params.add(orgId);
        }
        sql = sql + " ORDER BY org_no, dept_no,\n          t.display_no";
        List list = null;
        if (StrKit.notBlank(sort)) {
            String exesql = "select * from (" + sql.toString() + ") " + SysUtils.genOrderBy(sort, order);
            list = this.sqlHelper.queryByNativeSQL(exesql, params.toArray(), new int[0]);
        } else {
            list = this.sqlHelper.queryByNativeSQL(sql, params.toArray(), new int[0]);
        }
        PageObject obj = new PageObject();
        if (list != null && !list.isEmpty()) {
            obj.setRows(list);
            obj.setTotal(list.size());
        }
        return obj;
    }

    public Map<String, Object> findEmpByAccountId(Long accountId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountId", accountId);
        return this.bSqlHelper.getMap("business.hr.HrEmp.findEmpByAccountId", params);
    }

    public Object queryHrEmpLeaderList(Long empId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("empId", empId);
        return this.bSqlHelper.getMapList("business.hr.HrEmp.queryHrEmpLeaderList", params);
    }

    public List<Map<String, Object>> getAllContacts(String mgrProtect, Long login) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)mgrProtect)) {
            params.put("mgrProtect", mgrProtect);
        }
        if (login != null) {
            params.put("login", login);
        }
        return this.bSqlHelper.getMapList("business.hr.HrEmp.getAllContacts1", params);
    }

    public List<Map<String, Object>> getAllContacts(String mgrProtect) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)mgrProtect)) {
            params.put("mgrProtect", mgrProtect);
        }
        return this.bSqlHelper.getMapList("business.hr.HrEmp.getAllContacts", params);
    }

    public List<Map<String, Object>> getAllContacts1(String mgrProtect, Long orgId, String userInfo) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)mgrProtect)) {
            params.put("mgrProtect", mgrProtect);
        }
        if (StringUtils.isNotBlank((String)userInfo)) {
            params.put("userInfo", "%" + userInfo.toUpperCase() + "%");
        }
        if (orgId != null) {
            params.put("orgId", orgId);
        }
        return this.bSqlHelper.getMapList("business.hr.HrEmp.getAllContacts", params);
    }

    public Map<String, Object> findByEmpId(Long id, String mgrProtect) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("empId", id);
        if (StringUtils.isNotBlank((String)mgrProtect)) {
            params.put("mgrProtect", mgrProtect);
        }
        return this.bSqlHelper.getMap("business.hr.HrEmp.findByEmpId", params);
    }

    public List<Map<String, Object>> fineByDeptId(Long deptid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("deptid", deptid);
        return this.bSqlHelper.getMapList("business.hr.HrEmp.fineByDeptId", params);
    }

    public List<Map<String, Object>> getMySubColleagues() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("loginuser", SysUtils.getLoginUser());
        return this.bSqlHelper.getMapList("business.hr.HrEmp.getMySubColleagues", params);
    }

    public Map<String, Object> findEmpById(Long empId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (empId != null) {
            params.put("empId", empId);
        }
        return this.bSqlHelper.getMap("business.hr.HrEmp.findEmpById", params);
    }

    public List<Map<String, Object>> findEmpByIds(String empIds, String orgName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)empIds)) {
            params.put("empIds", empIds);
        }
        if (StringUtils.isNotBlank((String)orgName)) {
            params.put("orgName", orgName);
        }
        return this.bSqlHelper.getMapList("business.hr.HrEmp.findEmpByIds", params);
    }

    public List<Map<String, Object>> findByIdToDetials(Long empId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (empId != null) {
            params.put("empId", empId);
        }
        return this.bSqlHelper.getMapList("business.hr.HrEmp.findByIdToDetials", params);
    }

    public List<Map<String, Object>> findByIdToTrain(Long empId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (empId != null) {
            params.put("empId", empId);
        }
        return this.bSqlHelper.getMapList("business.hr.HrEmp.findByIdToTrain", params);
    }

    public List<Map<String, Object>> findByIdToWork(Long empId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (empId != null) {
            params.put("empId", empId);
        }
        return this.bSqlHelper.getMapList("business.hr.HrEmp.findByIdToWork", params);
    }

    public List<Map<String, Object>> findByFamilyDetail(Long empId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (empId != null) {
            params.put("empId", empId);
        }
        return this.bSqlHelper.getMapList("business.hr.HrEmp.findByFamilyDetail", params);
    }

    public String saveTemplateFile(String empId) throws Exception {
        ClassPathResource res = new ClassPathResource("renshi.xls");
        InputStream is = res.getInputStream();
        DiskFileItem fileItem = new DiskFileItem("mainFile", Files.probeContentType(res.getFile().toPath()), false, res.getFilename(), (int)res.getFile().length(), res.getFile().getParentFile());
        try {
            OutputStream os = fileItem.getOutputStream();
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException os) {
            // empty catch block
        }
        CommonsMultipartFile multipartFile = new CommonsMultipartFile((FileItem)fileItem);
        HrEmp emp = (HrEmp)this.hrempDao.findById(Long.parseLong(empId)).get();
        FileInfo fileinfo = new FileInfo();
        fileinfo.setLoginuser(SysUtils.getLoginUser());
        fileinfo.setFilename(emp.getEmpName());
        fileinfo = this.fileService.upLoadFile((MultipartFile)multipartFile, fileinfo);
        emp.setRecordId(fileinfo.getVersionid().toString());
        this.hrempDao.save(emp);
        return fileinfo.getVersionid().toString();
    }

    public Workbook constructWorkbook(String empIds) {
        TemplateExportParams params = new TemplateExportParams("static/template/HrEmpTemplate.xlsx", new Integer[0]);
        HashMap<Integer, Map<String, Object>> sheet = new HashMap<Integer, Map<String, Object>>();
        String[] orgNames = new String[]{"\u6ee8\u6295\u516c\u53f8", "\u79df\u8d41\u516c\u53f8", "\u5927\u79d1\u5b66\u88c5\u7f6e\u516c\u53f8", "\u8d44\u4ea7\u516c\u53f8", "\u5de5\u7a0b\u516c\u53f8", "\u516c\u56ed\u529e"};
        String[] sheetName = new String[]{"", "", "", "", "", ""};
        String yearMonth = new SimpleDateFormat("yyyy-MM").format(new Date());
        Integer index = 0;
        for (String orgName : orgNames) {
            List<Map<String, Object>> mapList = this.findEmpByIds(empIds, orgName);
            if (mapList.isEmpty()) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("orgName", orgName);
            map.put("yearMonth", yearMonth);
            ArrayList<ExcelHrEmpEntity> result = new ArrayList<ExcelHrEmpEntity>();
            int squence = 0;
            for (Map<String, Object> m : mapList) {
                ExcelHrEmpEntity excelHrEmpEntity = new ExcelHrEmpEntity();
                excelHrEmpEntity.setSquence(++squence);
                excelHrEmpEntity.setOrgName(Objects.toString(m.get("orgName"), ""));
                excelHrEmpEntity.setDeptName(Objects.toString(m.get("deptName"), ""));
                excelHrEmpEntity.setEmpName(Objects.toString(m.get("empName"), ""));
                excelHrEmpEntity.setSexText(Objects.toString(m.get("sexText"), ""));
                excelHrEmpEntity.setNationText(Objects.toString(m.get("nationText"), ""));
                excelHrEmpEntity.setNativePlace(Objects.toString(m.get("nativePlace"), ""));
                excelHrEmpEntity.setBirthdayDate(Objects.toString(m.get("birthdayDate"), ""));
                excelHrEmpEntity.setBirthPalce(Objects.toString(m.get("birthPalce"), ""));
                excelHrEmpEntity.setJoinTime(Objects.toString(m.get("joinTime"), ""));
                excelHrEmpEntity.setWorkDate(Objects.toString(m.get("workDate"), ""));
                excelHrEmpEntity.setIdCard(Objects.toString(m.get("idCard"), ""));
                excelHrEmpEntity.setMaritalStatuText(Objects.toString(m.get("maritalStatuText"), ""));
                excelHrEmpEntity.setMobilephone(Objects.toString(m.get("mobilephone"), ""));
                excelHrEmpEntity.setSparePhone(Objects.toString(m.get("sparePhone"), ""));
                excelHrEmpEntity.setEmail(Objects.toString(m.get("email"), ""));
                excelHrEmpEntity.setRank(Objects.toString(m.get("rank"), ""));
                excelHrEmpEntity.setTechnicalTime(Objects.toString(m.get("technicalTime"), ""));
                excelHrEmpEntity.setDomicilePlace(Objects.toString(m.get("domicilePlace"), ""));
                excelHrEmpEntity.setHomeAddr(Objects.toString(m.get("homeAddr"), ""));
                excelHrEmpEntity.setProTechPosition(Objects.toString(m.get("proTechPosition"), ""));
                excelHrEmpEntity.setProSpecialty(Objects.toString(m.get("proSpecialty"), ""));
                excelHrEmpEntity.setCrashContact(Objects.toString(m.get("crashContact"), ""));
                excelHrEmpEntity.setCrashTel(Objects.toString(m.get("crashTel"), ""));
                excelHrEmpEntity.setTopEducationText(Objects.toString(m.get("topEducationText"), ""));
                excelHrEmpEntity.setGraduate(Objects.toString(m.get("graduateColl"), "") + " " + Objects.toString(m.get("profession"), ""));
                excelHrEmpEntity.setRewardPunish(Objects.toString(m.get("rewardPunish"), ""));
                excelHrEmpEntity.setAssessResult(Objects.toString(m.get("assessResult"), ""));
                excelHrEmpEntity.setHrEduWorkDetail(Objects.toString(m.get("hrEduDetail"), "") + "\n" + Objects.toString(m.get("hrWorkDetail"), ""));
                excelHrEmpEntity.setHrTraDetail(Objects.toString(m.get("hrTraDetail"), ""));
                excelHrEmpEntity.setHrFamilyDetail(Objects.toString(m.get("hrFamilyDetail"), ""));
                result.add(excelHrEmpEntity);
            }
            map.put("list", result);
            sheetName[index.intValue()] = orgName;
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
            sheet.put(n, map);
        }
        Integer[] sheetNum = new Integer[index.intValue()];
        Integer i = 0;
        while (i < index) {
            sheetNum[i.intValue()] = i;
            Integer n = i;
            Integer n3 = i = Integer.valueOf(i + 1);
        }
        params.setSheetNum(sheetNum);
        params.setSheetName(sheetName);
        params.setStyle(ExcelExportStylerDefaultImpl.class);
        Workbook workbook = ExcelExportUtil.exportExcel(sheet, params);
        return workbook;
    }

    public List<Map<String, Object>> findEmpByAccountIds(String accountIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)accountIds) && !"null".equals(accountIds)) {
            params.put("accountIds", ListUtils.stringToListWithLong(accountIds));
        }
        return this.bSqlHelper.getMapList("business.hr.HrEmp.findEmpByAccountIds", params);
    }
}

