/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.business.hr.service;

import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.service.CommonService;
import com.ustc.business.hr.dao.HrEducationLiveDao;
import com.ustc.business.hr.entity.HrEducationLive;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class HrEducationLiveService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private HrEducationLiveDao hreducationliveDao;

    public HrEducationLive findHrEducationLive(Long id) {
        HrEducationLive entity = (HrEducationLive)this.hreducationliveDao.findById(id).get();
        return entity;
    }

    public void saveHrEducationLive(HrEducationLive entity) {
        this.hreducationliveDao.save(entity);
    }

    public void delHrEducationLive(Long id, Long userId) {
        HrEducationLive entity = (HrEducationLive)this.hreducationliveDao.findById(id).get();
        entity.setIsUse("N");
        entity.setModifyAccount(userId);
        entity.setModifyTime(new Date());
        this.hreducationliveDao.save(entity);
    }

    public PageObject PageAll(String search, int page, int rows, Long empId) {
        PageObject pageobject = new PageObject();
        if (empId == null) {
            return pageobject;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select * from HR_EDUCATION_LIVE t where t.is_use=:isUse\n");
        params.put("isUse", "Y");
        if (!StringUtils.isEmpty((String)search)) {
            sql.append(" and  (");
            sql.append("  upper(t.EDUCATION_LIVE_ID) like :search ");
            sql.append(" or upper(t.EMP_ID) like :search ");
            sql.append(" or upper(t.START_TIME) like :search ");
            sql.append(" or upper(t.END_TIME) like :search ");
            sql.append(" or upper(t.GRADUATE_COLLEGE) like :search ");
            sql.append(" or upper(t.PROFESSION) like :search ");
            sql.append(" or upper(t.EDUCATION) like :search ");
            sql.append(" or upper(t.ACADEMIC_DEGREE) like :search ");
            sql.append(" or upper(t.CERTIFICATE_NO) like :search ");
            sql.append(" or upper(t.REMARK) like :search ");
            sql.append(" or upper(t.MODIFY_ACCOUNT) like :search ");
            sql.append(" or upper(t.MODIFY_TIME) like :search ");
            sql.append(" or upper(t.IS_USE) like :search ");
            sql.append(")");
            params.put("search", "%" + search.toUpperCase().replace("%", "/%") + "%");
        }
        sql.append("and t.EMP_ID=:empId");
        params.put("empId", empId);
        sql.append(" order by t.EDUCATION_LIVE_ID");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("ACADEMIC_DEGREE", "ACADEMIC_DEGREE");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }
}

