/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.business.hr.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.business.hr.dao.HrDeptPostDao;
import com.ustc.business.hr.entity.HrDeptPost;
import com.ustc.business.hr.entity.HrEmp;
import com.ustc.gen.util.DBPropertyUtil;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class HrDeptPostService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private HrDeptPostDao hrdeptpostDao;

    public HrDeptPost findHrDeptPost(Long id) {
        HrDeptPost entity = (HrDeptPost)this.hrdeptpostDao.findById(id).get();
        return entity;
    }

    public void saveHrDeptPost(HrDeptPost entity) {
        this.hrdeptpostDao.save(entity);
    }

    public void delHrDeptPost(Long id) {
        HrDeptPost entity = (HrDeptPost)this.hrdeptpostDao.findById(id).get();
        entity.setIsUse("N");
        this.hrdeptpostDao.save(entity);
    }

    public PageObject PageAll(String search, String orgid, String deptid, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)orgid)) {
            params.put("orgid", orgid);
        }
        if (!StringUtils.isEmpty((String)deptid)) {
            params.put("deptid", deptid);
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        return this.bSqlHelper.serachPage("business.hr.HrDeptPost.select", params, PageRequest.of((int)page, (int)rows));
    }

    public boolean checkEntity(Long orgId, Long deptId, String postId) {
        Long count;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (orgId != null) {
            params.put("orgId", orgId);
        }
        if (deptId != null) {
            params.put("deptId", deptId);
        }
        if (!StringUtils.isEmpty((String)postId)) {
            params.put("postId", postId);
        }
        return (count = this.bSqlHelper.getLongValue("business.hr.HrDeptPost.checkCount", params)) == 0L;
    }

    public void saveHrDeptPost(HrEmp hrEmp) {
        String[] postIds;
        Long orgId = hrEmp.getOrgId();
        Long deptId = hrEmp.getDeptId();
        for (String postId : postIds = hrEmp.getPresentJob().split(",")) {
            if (!this.checkEntity(orgId, deptId, postId)) continue;
            HrDeptPost entity = new HrDeptPost();
            entity.setDeptId(deptId);
            entity.setOrgId(orgId);
            entity.setPostId(Long.parseLong(postId));
            entity.setModifyAccount(hrEmp.getModifyAccount());
            entity.setModifyTime(new Date());
            entity.setIsUse("Y");
            entity.setCreateAccount(hrEmp.getModifyAccount());
            entity.setCreateTime(new Date());
            this.hrdeptpostDao.save(entity);
        }
    }

    public String getPostNameById(String ids) {
        if (StringUtils.isNotEmpty((String)ids)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("ids", ids.split(","));
            return this.bSqlHelper.getStringValue("business.hr.HrDeptPost.getPostNameById", params);
        }
        return "";
    }
}

