/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.business.hr.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ustc.base.common.util.DateUtils;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.controller.BaseController;
import com.ustc.business.hr.entity.HrWorkLive;
import com.ustc.business.hr.service.HrWorkLiveService;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/HrWorkLive"})
public class HrWorkLiveController
extends BaseController {
    @Autowired
    private HrWorkLiveService hrworkliveService;

    @RequestMapping(value={"/pageHrWorkLive"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageHrWorkLive(@RequestParam(value="empId", defaultValue="") Long empId, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows) {
        return this.hrworkliveService.PageAll(search, page, rows, empId);
    }

    @RequestMapping(value={"/findHrWorkLive"})
    @ResponseBody
    public Object findHrWorkLive(Long id) {
        return this.hrworkliveService.findHrWorkLive(id);
    }

    @RequestMapping(value={"/saveHrWorkLive"})
    @ResponseBody
    public Object saveBHrWorkLive(HttpServletRequest request, HrWorkLive entity) {
        JsonMsg msg = new JsonMsg();
        entity.setModifyAccount(this.getLoginUser(request).getAccountid());
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        this.hrworkliveService.saveHrWorkLive(entity);
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/delHrWorkLive"})
    @ResponseBody
    public Object delHrWorkLive(HttpServletRequest request, Long id) {
        this.hrworkliveService.delHrWorkLive(id, this.getLoginUser(request).getAccountid());
        return new JsonMsg();
    }

    @RequestMapping(value={"/savework"})
    @ResponseBody
    public Object save(HttpServletRequest request, Long empId) throws ParseException {
        JsonMsg msg = new JsonMsg();
        String rowlist = request.getParameter("rowlist");
        if (StrKit.notBlank(rowlist)) {
            JSONArray rows = JSON.parseArray((String)rowlist);
            for (Object o : rows) {
                Map row = (Map)o;
                HrWorkLive record = new HrWorkLive();
                if (StrKit.notNull(row.get("WORK_LIVE_ID"))) {
                    record.setWorkLiveId(Long.parseLong(row.get("WORK_LIVE_ID").toString()));
                }
                if (StrKit.notNull(row.get("START_TIME"))) {
                    record.setStartTime(DateUtils.strToDate(row.get("START_TIME").toString()));
                }
                if (StrKit.notNull(row.get("END_TIME"))) {
                    record.setEndTime(DateUtils.strToDate(row.get("END_TIME").toString()));
                }
                if (StrKit.notNull(row.get("WORK_UNIT"))) {
                    record.setWorkUnit(row.get("WORK_UNIT").toString());
                }
                if (StrKit.notNull(row.get("DEPT_NAME"))) {
                    record.setDeptName(row.get("DEPT_NAME").toString());
                }
                if (StrKit.notNull(row.get("CERTIFIER"))) {
                    record.setCertifier(row.get("CERTIFIER").toString());
                }
                if (StrKit.notNull(row.get("TELEPHONE"))) {
                    record.setTelephone(row.get("TELEPHONE").toString());
                }
                if (StrKit.notNull(row.get("REMARK"))) {
                    record.setRemark(row.get("REMARK").toString());
                }
                record.setEmpId(empId);
                record.setIsUse("Y");
                record.setModifyAccount(this.getLoginUser(request).getAccountid());
                record.setModifyTime(new Date());
                this.hrworkliveService.saveHrWorkLive(record);
            }
        }
        msg.setO(empId);
        return msg;
    }
}

