/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.business.hr.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ustc.base.common.util.DateUtils;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.controller.BaseController;
import com.ustc.business.hr.entity.HrTrainingLive;
import com.ustc.business.hr.service.HrTrainingLiveService;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/HrTrainingLive"})
public class HrTrainingLiveController
extends BaseController {
    @Autowired
    private HrTrainingLiveService hrtrainingliveService;

    @RequestMapping(value={"/pageHrTrainingLive"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageHrTrainingLive(@RequestParam(value="empId", defaultValue="") Long empId, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows) {
        return this.hrtrainingliveService.PageAll(search, page, rows, empId);
    }

    @RequestMapping(value={"/findHrTrainingLive"})
    @ResponseBody
    public Object findHrTrainingLive(Long id) {
        return this.hrtrainingliveService.findHrTrainingLive(id);
    }

    @RequestMapping(value={"/saveHrTrainingLive"})
    @ResponseBody
    public Object saveHrTrainingLive(HttpServletRequest request, HrTrainingLive entity) {
        JsonMsg msg = new JsonMsg();
        entity.setModifyAccount(this.getLoginUser(request).getAccountid());
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        this.hrtrainingliveService.saveHrTrainingLive(entity);
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/delHrTrainingLive"})
    @ResponseBody
    public Object delHrTrainingLive(HttpServletRequest request, Long id) {
        this.hrtrainingliveService.delHrTrainingLive(id, this.getLoginUser(request).getAccountid());
        return new JsonMsg();
    }

    @RequestMapping(value={"/savetrain"})
    @ResponseBody
    public Object save(HttpServletRequest request, Long empId) throws ParseException {
        JsonMsg msg = new JsonMsg();
        String rowlist = request.getParameter("rowlist");
        if (StrKit.notBlank(rowlist)) {
            JSONArray rows = JSON.parseArray((String)rowlist);
            for (Object o : rows) {
                Map row = (Map)o;
                HrTrainingLive record = new HrTrainingLive();
                if (StrKit.notNull(row.get("TRAINING_LIVE_ID"))) {
                    record.setTrainingLiveId(Long.parseLong(row.get("TRAINING_LIVE_ID").toString()));
                }
                if (StrKit.notNull(row.get("START_TIME"))) {
                    record.setStartTime(DateUtils.strToDate(row.get("START_TIME").toString()));
                }
                if (StrKit.notNull(row.get("END_TIME"))) {
                    record.setEndTime(DateUtils.strToDate(row.get("END_TIME").toString()));
                }
                if (StrKit.notNull(row.get("TRAINING_CONTENT"))) {
                    record.setTrainingContent(row.get("TRAINING_CONTENT").toString());
                }
                if (StrKit.notNull(row.get("TRAINING_ORG"))) {
                    record.setTrainingOrg(row.get("TRAINING_ORG").toString());
                }
                if (StrKit.notNull(row.get("TRAINING_CERTIFICATE"))) {
                    record.setTrainingCertificate(row.get("TRAINING_CERTIFICATE").toString());
                }
                if (StrKit.notNull(row.get("REMARK"))) {
                    record.setRemark(row.get("REMARK").toString());
                }
                record.setEmpId(empId);
                record.setIsUse("Y");
                record.setModifyAccount(this.getLoginUser(request).getAccountid());
                record.setModifyTime(new Date());
                this.hrtrainingliveService.saveHrTrainingLive(record);
            }
        }
        msg.setO(empId);
        return msg;
    }
}

