/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.business.hr.controller;

import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.controller.BaseController;
import com.ustc.base.dao.BasEmpAccountDao;
import com.ustc.base.entity.BasEmpAccount;
import com.ustc.business.hr.entity.HrPost;
import com.ustc.business.hr.service.HrPostService;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/HrPost"})
public class HrPostController
extends BaseController {
    @Autowired
    private HrPostService hrpostService;
    @Autowired
    private BasEmpAccountDao basEmpAccountDao;

    @RequestMapping(value={"/pageHrPost"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageHrPost(HttpServletRequest request, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String orgId, String deptId, String sort, String order) {
        return this.hrpostService.PageAll(search, page, rows, orgId, deptId, sort, order);
    }

    @RequestMapping(value={"/queryHrPost"})
    @ResponseBody
    public Object queryHrPost(HttpServletRequest request) {
        Long login = this.getLoginUser(request).getAccountid();
        BasEmpAccount basEmpAccount = this.basEmpAccountDao.findByAccountIdAndIsUse(login, "Y");
        Long orgId = null;
        if (basEmpAccount != null) {
            orgId = basEmpAccount.getOrgId();
        }
        return this.hrpostService.queryHrPostList(orgId);
    }

    @RequestMapping(value={"/findHrPost"})
    @ResponseBody
    public Object findHrPost(Long id) {
        HrPost entity = this.hrpostService.findHrPost(id);
        return entity;
    }

    @RequestMapping(value={"/saveHrPost"})
    @ResponseBody
    public Object saveHrPost(HttpServletRequest request, HrPost entity) {
        JsonMsg msg = new JsonMsg();
        entity.setModifyAccount(this.getLoginUser(request).getAccountid());
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        if (entity.getPostId() == null) {
            entity.setCreateAccount(this.getLoginUser(request).getAccountid());
            entity.setCreateTime(new Date());
        }
        this.hrpostService.saveHrPost(entity);
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/delHrPost"})
    @ResponseBody
    public Object delHrPost(Long id) {
        this.hrpostService.delHrPost(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/combo"})
    @ResponseBody
    public Object combo(HttpServletRequest request, Long orgId, Long deptId) {
        if (orgId == null) {
            orgId = this.getLoginUser(request).getOrgid();
        }
        return this.hrpostService.combo(orgId, deptId);
    }
}

