/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.business.hr.controller;

import com.ustc.base.common.exception.GEPSBisException;
import com.ustc.base.common.spring.SystemControllerLog;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.LoginUser;
import com.ustc.base.common.util.Pinyin4jUtil;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.controller.BaseController;
import com.ustc.base.entity.BasDept;
import com.ustc.base.entity.BasEmp;
import com.ustc.base.entity.BasEmpAccount;
import com.ustc.base.entity.BasMessage;
import com.ustc.base.service.BasDeptService;
import com.ustc.base.service.BasEmpAccountService;
import com.ustc.base.service.BasEmpService;
import com.ustc.base.service.BasMessageService;
import com.ustc.base.service.BasOrgService;
import com.ustc.base.service.FirstPageService;
import com.ustc.business.hr.dao.HrProtectScoptDao;
import com.ustc.business.hr.entity.HrEmp;
import com.ustc.business.hr.entity.HrProtectScopt;
import com.ustc.business.hr.entity.HrSettings;
import com.ustc.business.hr.service.HrDeptPostService;
import com.ustc.business.hr.service.HrEmpService;
import com.ustc.business.hr.service.HrSettingsService;
import com.ustc.doc.entity.FormFileBean;
import com.ustc.workflow.service.FlowUtilService;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.dom4j.DocumentException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/HrEmp"})
public class HrEmpController
extends BaseController {
    @Autowired
    private BasDeptService basDeptService;
    @Autowired
    private BasOrgService basOrgService;
    @Autowired
    private HrEmpService hrempService;
    @Autowired
    private HrDeptPostService hrDeptPostService;
    @Autowired
    private BasEmpService basEmpService;
    @Autowired
    private BasEmpAccountService basEmpAccountService;
    @Autowired
    private FirstPageService firstPageService;
    @Autowired
    private HrSettingsService hrSettingsService;
    @Autowired
    private HrProtectScoptDao hrprotectscoptDao;
    @Autowired
    private FlowUtilService flowUtilService;
    @Autowired
    private BasMessageService basmessageService;

    @RequestMapping(value={"/pageAllEmp"})
    @ResponseBody
    public Object pageAllEmp(HttpServletRequest request, @RequestParam(value="borndaya", defaultValue="") Date borndaya, @RequestParam(value="borndayb", defaultValue="") Date borndayb, @RequestParam(value="empPropStatus", defaultValue="") String empPropStatus, @RequestParam(value="name", defaultValue="") String name, @RequestParam(value="status", defaultValue="") String status, @RequestParam(value="workTimeStart", defaultValue="") Date workTimeStart, @RequestParam(value="workTimeEnd", defaultValue="") Date workTimeEnd, @RequestParam(value="politicalStatus", defaultValue="") String politicalStatus, @RequestParam(value="nationStatus", defaultValue="") String nationStatus, @RequestParam(value="topEducation", defaultValue="") String topEducation, @RequestParam(value="professionalTitle", defaultValue="") String professionalTitle, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, @RequestParam(value="sort", defaultValue="") String sort, @RequestParam(value="isWin", defaultValue="") String isWin, String orgbirth, String birth, Long orgid, Long deptid, String order) {
        Long org = this.getLoginUser(request).getOrgid();
        Long login = this.getLoginUser(request).getAccountid();
        return this.hrempService.pageAllEmp(isWin, topEducation, borndaya, borndayb, politicalStatus, empPropStatus, nationStatus, status, orgid, deptid, orgbirth, birth, professionalTitle, search, page, rows, sort, order, org, workTimeStart, workTimeEnd, login, name);
    }

    @RequestMapping(value={"/findHrEmp"})
    @ResponseBody
    public Object findHrEmp(Long id) {
        HrEmp entity = this.hrempService.findHrEmp(id);
        return entity;
    }

    @RequestMapping(value={"/findHrEmp1"})
    @ResponseBody
    public Object findHrEmp1(HttpServletRequest request, Long id) {
        JsonMsg msg = new JsonMsg();
        Long org = this.getLoginUser(request).getOrgid();
        HrSettings hrSettings = this.hrSettingsService.findByOrgId(org);
        String mgrProtect = "Y";
        if (hrSettings != null && StringUtils.isNotBlank((String)hrSettings.getMgrProtect())) {
            mgrProtect = hrSettings.getMgrProtect();
        }
        Map<String, Object> emp = this.hrempService.findByEmpId(id, mgrProtect);
        msg.setO(emp);
        return msg;
    }

    @RequestMapping(value={"/queryHrEmpLeader"})
    @ResponseBody
    public Object queryHrEmpLeader(HttpServletRequest request) {
        Long loginUser = this.getLoginUser(request).getAccountid();
        Long empId = this.basEmpAccountService.findEmpAccountById(loginUser).getEmpId();
        Long HrEmpId = this.basEmpService.findEmpByempId(empId).getHrEmpId();
        return this.hrempService.queryHrEmpLeaderList(HrEmpId);
    }

    @RequestMapping(value={"/saveHrEmp"})
    @ResponseBody
    public Object saveHrEmp(HttpServletRequest request, HrEmp entity) {
        JsonMsg msg = new JsonMsg();
        entity.setModifyAccount(this.getLoginUser(request).getAccountid());
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        this.hrempService.saveHrEmp(entity);
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/delHrEmp"})
    @ResponseBody
    @SystemControllerLog(description="\u5458\u5de5\u6863\u6848\u6ce8\u9500")
    public Object delHrEmp(Long id) {
        this.hrempService.delHrEmp(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/savestaff"}, method={RequestMethod.POST})
    @ResponseBody
    public Object saveStaff(HttpServletRequest request, HrEmp hrEmp, FormFileBean formfile, String formcode, String userId) throws RemoteException, ParseException {
        boolean isAdd;
        boolean bl = isAdd = hrEmp.getEmpId() == null;
        if (!isAdd) {
            HrEmp oldemp = this.hrempService.findHrEmp(hrEmp.getEmpId());
            hrEmp.setIsUse("Y");
            hrEmp.setCreateAccount(oldemp.getCreateAccount());
            hrEmp.setCreateTime(oldemp.getCreateTime());
        } else {
            hrEmp.setCreateAccount(this.getLoginUser(request).getAccountid());
            hrEmp.setCreateTime(new Date());
        }
        hrEmp.setModifyAccount(this.getLoginUser(request).getAccountid());
        hrEmp.setModifyTime(new Date());
        hrEmp.setIsUse("Y");
        if (StringUtils.isBlank((String)hrEmp.getStatus())) {
            hrEmp.setStatus("1");
        }
        return this.hrempService.saveHrEmp(request, hrEmp, formfile, formcode, userId);
    }

    @RequestMapping(value={"/printEmpInfo"})
    public Object printEmpInfo(Long empId, Model model) {
        Map<String, Object> emp = this.hrempService.findEmpById(empId);
        List<Map<String, Object>> hrEduDetail = this.hrempService.findByIdToDetials(empId);
        List<Map<String, Object>> hrTraDetail = this.hrempService.findByIdToTrain(empId);
        List<Map<String, Object>> hrWorkDetail = this.hrempService.findByIdToWork(empId);
        List<Map<String, Object>> hrFamilyDetail = this.hrempService.findByFamilyDetail(empId);
        model.addAttribute("emp", emp);
        model.addAttribute("hrEduDetail", hrEduDetail);
        model.addAttribute("hrTraDetail", hrTraDetail);
        model.addAttribute("hrWorkDetail", hrWorkDetail);
        model.addAttribute("hrFamilyDetail", hrFamilyDetail);
        int size = 0;
        if (hrFamilyDetail != null) {
            size = hrFamilyDetail.size();
        }
        model.addAttribute("size", (Object)size);
        model.addAttribute("blankSize", (Object)(4 - size));
        model.addAttribute("blankSize2", (Object)(7 - size));
        String jsonStr = SysUtils.getJsonStr("HrEmp_form", emp.get("empId").toString(), null);
        model.addAttribute("CodeInfo", (Object)jsonStr);
        return "/business/print/HrEmpInfo";
    }

    @RequestMapping(value={"/EmpInfoMulti"})
    public Object EmpInfoMulti(String empIds, Model model) {
        String[] idlist = empIds.split(",");
        ArrayList list = new ArrayList();
        for (String idstr : idlist) {
            Long empId = Long.parseLong(idstr);
            HashMap<String, Object> map = new HashMap<String, Object>();
            Map<String, Object> emp = this.hrempService.findEmpById(empId);
            List<Map<String, Object>> hrEduDetail = this.hrempService.findByIdToDetials(empId);
            List<Map<String, Object>> hrTraDetail = this.hrempService.findByIdToTrain(empId);
            List<Map<String, Object>> hrWorkDetail = this.hrempService.findByIdToWork(empId);
            List<Map<String, Object>> hrFamilyDetail = this.hrempService.findByFamilyDetail(empId);
            map.put("emp", emp);
            map.put("hrEduDetail", hrEduDetail);
            map.put("hrTraDetail", hrTraDetail);
            map.put("hrWorkDetail", hrWorkDetail);
            map.put("hrFamilyDetail", hrFamilyDetail);
            int size = 0;
            if (hrFamilyDetail != null) {
                size = hrFamilyDetail.size();
            }
            map.put("size", size);
            map.put("blankSize", 4 - size);
            map.put("blankSize2", 7 - size);
            String jsonStr = SysUtils.getJsonStr("HrEmp_form", emp.get("empId").toString(), null);
            map.put("CodeInfo", jsonStr);
            list.add(map);
        }
        model.addAttribute("list", list);
        return "/business/print/HrEmpInfoMulti";
    }

    @RequestMapping(value={"exportEmpExcel"})
    @ResponseBody
    public void exportEmpExcel(HttpServletResponse response, HttpServletRequest request, String empIds) {
        Workbook workbook = this.hrempService.constructWorkbook(empIds);
        HrEmpController.downLoadExcel("\u5458\u5de5\u4fe1\u606f\u8868.xlsx", response, workbook);
    }

    private static void downLoadExcel(String fileName, HttpServletResponse response, Workbook workbook) {
        try {
            response.setCharacterEncoding("UTF-8");
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            workbook.write((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            e.getStackTrace();
        }
    }

    @RequestMapping(value={"/queryEmpById"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryEmpById(String empId) {
        BasDept dept;
        HrEmp entity = this.hrempService.findEmpByempId(Long.parseLong(empId));
        if (entity.getOrgId() != null) {
            entity.setOrgId_TEXT_(this.basOrgService.findByOrgId(entity.getOrgId()).getOrgName());
        }
        if (entity.getDeptId() != null && (dept = this.basDeptService.findByDeptId(entity.getDeptId())) != null) {
            entity.setDeptId_TEXT_(this.basDeptService.findByDeptId(entity.getDeptId()).getDeptName());
        }
        if (entity.getMyLeader() != null) {
            entity.setMyLeader_TEXT_(this.basEmpAccountService.queryEmpAccountById(entity.getMyLeader()));
        }
        if (StringUtils.isNotEmpty((String)entity.getViceStation())) {
            entity.setViceStation_TEXT_(this.hrDeptPostService.getPostNameById(entity.getViceStation()));
        }
        List<HrProtectScopt> list = this.hrprotectscoptDao.findByEmpIdAndIsUse(Long.parseLong(empId), "Y");
        StringBuilder user = new StringBuilder();
        StringBuilder userId = new StringBuilder();
        String user1 = "";
        String userId1 = "";
        if (list != null && !list.isEmpty()) {
            for (HrProtectScopt hrProtectScopt : list) {
                if ("user".equals(hrProtectScopt.getUserType())) {
                    String username = this.basEmpAccountService.findById(hrProtectScopt.getUserId()).getAccountName();
                    user.append(username + ",");
                    userId.append("user:" + hrProtectScopt.getUserId() + ",");
                    continue;
                }
                if ("dept".equals(hrProtectScopt.getUserType())) {
                    String deptName = this.basDeptService.findByDeptId(hrProtectScopt.getUserId()).getDeptName();
                    user.append(deptName + ",");
                    userId.append("dept:" + hrProtectScopt.getUserId() + ",");
                    continue;
                }
                if (!"org".equals(hrProtectScopt.getUserType())) continue;
                String orgName = this.basOrgService.findByOrgId(hrProtectScopt.getUserId()).getOrgName();
                user.append(orgName + ",");
                userId.append("org:" + hrProtectScopt.getUserId() + ",");
            }
            user1 = user.toString();
            user1 = user1.substring(0, user1.length() - 1);
            userId1 = userId.toString();
            userId1 = userId1.substring(0, userId1.length() - 1);
        }
        entity.setUserId_TEXT_(user1);
        entity.setUserId(userId1);
        return entity;
    }

    @RequestMapping(value={"/findEmpBirthdayList"})
    @ResponseBody
    public Object findEmpBirthdayList(HttpServletRequest request) {
        String putMonth = request.getParameter("putMonth");
        String empNameOrCode = request.getParameter("empNameOrCode");
        String orgId = request.getParameter("orgId");
        String sort = request.getParameter("sort");
        String order = request.getParameter("order");
        return this.hrempService.findEmpBirthdayList(putMonth, empNameOrCode, orgId, sort, order);
    }

    @RequestMapping(value={"/viewPersonCenter"})
    public Object viewPersonCenter(Model model, HttpServletRequest request) {
        Long accountid = this.getLoginUser(request).getAccountid();
        List<Map<String, Object>> msglist = this.firstPageService.findAccountTodoList(accountid);
        int msgsize = msglist.size();
        BasEmpAccount basEmpAccount = this.basEmpAccountService.findById(accountid);
        BasEmp basEmp = this.basEmpService.findEmpByempId(basEmpAccount.getEmpId());
        HrEmp hrEmp = this.hrempService.findHrEmp(basEmp.getHrEmpId());
        Long photoVersionId = hrEmp.getPhotoVersionId();
        String empName = hrEmp.getEmpName();
        String empCode = hrEmp.getEmpCode();
        Long deptId = hrEmp.getDeptId();
        BasDept basDept = this.basDeptService.findByDeptId(deptId);
        String deptName = basDept.getDeptName();
        model.addAttribute("photoVersionId", (Object)photoVersionId);
        model.addAttribute("empName", (Object)empName);
        model.addAttribute("empCode", (Object)empCode);
        model.addAttribute("deptName", (Object)deptName);
        model.addAttribute("msgsize", (Object)msgsize);
        return "/space/model/personalCenter";
    }

    @RequestMapping(value={"/constructHrContacts"})
    public Object constructHrContacts(Model model, HttpServletRequest request) {
        Long org = this.getLoginUser(request).getOrgid();
        Long login = this.getLoginUser(request).getAccountid();
        HrSettings hrSettings = this.hrSettingsService.findByOrgId(org);
        String mgrProtect = "Y";
        if (hrSettings != null && StringUtils.isNotBlank((String)hrSettings.getMgrProtect())) {
            mgrProtect = hrSettings.getMgrProtect();
        }
        List<Map<String, Object>> contactsList = this.hrempService.getAllContacts(mgrProtect, login);
        TreeMap data = new TreeMap(new Comparator<String>(){

            @Override
            public int compare(String obj1, String obj2) {
                return obj1.compareTo(obj2);
            }
        });
        for (Map<String, Object> map : contactsList) {
            String empName = Objects.toString(map.get("empName"), "");
            String pf = Pinyin4jUtil.getPinyinFirstToUpperCase(empName);
            if (!StringUtils.isNotBlank((String)pf) || pf.length() <= 0) continue;
            String empNameStart = pf.substring(0, 1);
            if ("Y".equals(String.valueOf(map.get("isProtect")))) {
                empNameStart = " ";
            }
            if (data.get(empNameStart) == null) {
                data.put(empNameStart, new ArrayList());
            }
            ((List)data.get(empNameStart)).add(map);
        }
        model.addAttribute("info", data);
        List<Map<String, Object>> colleagueList = this.hrempService.fineByDeptId(this.getLoginUser(request).getDeptid());
        String[] colors = new String[]{"#d57171", "#a47566", "#4da9eb", "#f7b55e", "#FF8C00"};
        int i = 0;
        for (Map<String, Object> map : colleagueList) {
            map.put("color", colors[i++ % 5]);
        }
        model.addAttribute("colleagueList", colleagueList);
        return "/business/hr/HrContacts";
    }

    @RequestMapping(value={"/constructHrContactList"})
    @ResponseBody
    public Object contacts(Model model, HttpServletRequest request, Long orgId, String userInfo) {
        Long org = this.getLoginUser(request).getOrgid();
        HrSettings hrSettings = this.hrSettingsService.findByOrgId(org);
        String mgrProtect = "Y";
        if (hrSettings != null && StringUtils.isNotBlank((String)hrSettings.getMgrProtect())) {
            mgrProtect = hrSettings.getMgrProtect();
        }
        List<Map<String, Object>> contactsList = this.hrempService.getAllContacts1(mgrProtect, orgId, userInfo);
        TreeMap data = new TreeMap(new Comparator<String>(){

            @Override
            public int compare(String obj1, String obj2) {
                return obj1.compareTo(obj2);
            }
        });
        for (Map<String, Object> map : contactsList) {
            String pf;
            String empName = Objects.toString(map.get("empName"), "");
            if (!StringUtils.isNotBlank((String)empName) || empName.length() <= 0 || !StringUtils.isNotBlank((String)(pf = Pinyin4jUtil.getPinyinFirstToUpperCase(empName))) || pf.length() <= 0) continue;
            String empNameStart = pf.substring(0, 1);
            if (data.get(empNameStart) == null) {
                data.put(empNameStart, new ArrayList());
            }
            ((List)data.get(empNameStart)).add(map);
        }
        return data;
    }

    @RequestMapping(value={"/hrContactsBook"})
    public Object hrContactsBook(Model model, HttpServletRequest request) {
        Long org = this.getLoginUser(request).getOrgid();
        Long login = this.getLoginUser(request).getAccountid();
        HrSettings hrSettings = this.hrSettingsService.findByOrgId(org);
        String mgrProtect = "Y";
        if (hrSettings != null && StringUtils.isNotBlank((String)hrSettings.getMgrProtect())) {
            mgrProtect = hrSettings.getMgrProtect();
        }
        List<Map<String, Object>> contactsList = this.hrempService.getAllContacts(mgrProtect);
        TreeMap data = new TreeMap(new Comparator<String>(){

            @Override
            public int compare(String obj1, String obj2) {
                return obj1.compareTo(obj2);
            }
        });
        for (Map<String, Object> map : contactsList) {
            String empName = map.get("empName").toString();
            String pf = Pinyin4jUtil.getPinyinFirstToUpperCase(empName);
            if (!StringUtils.isNotBlank((String)pf) || pf.length() <= 0) continue;
            String empNameStart = pf.substring(0, 1);
            if (data.get(empNameStart) == null) {
                data.put(empNameStart, new ArrayList());
            }
            ((List)data.get(empNameStart)).add(map);
        }
        model.addAttribute("info", data);
        String[] colors = new String[]{"#00868B", "#3a9fe6", "#698B22", "#8A2BE2", "#FF34B3", "#8DB6CD", "#00EE00", "#6A5ACD", "#8A2BE2", "#8B4726"};
        List<Map<String, Object>> colleagueList = this.hrempService.fineByDeptId(this.getLoginUser(request).getDeptid());
        int i = 0;
        for (Map<String, Object> map : colleagueList) {
            map.put("color", colors[i++ % 10]);
        }
        model.addAttribute("colleagueList", colleagueList);
        return "/business/hr/HrContactsBook";
    }

    @RequestMapping(value={"/myColleagues"})
    public Object myColleagues(Model model, HttpServletRequest request) {
        model.addAttribute("deptColleagues", this.hrempService.fineByDeptId(this.getLoginUser(request).getDeptid()));
        model.addAttribute("subColleagues", this.hrempService.getMySubColleagues());
        return "/space/model/myColleagues";
    }

    @RequestMapping(value={"/toExcelPage"})
    public String toExcelPage(HttpServletRequest request, Model model) throws Exception {
        String recordId = request.getParameter("recordId");
        String empId = request.getParameter("empId");
        if (StringUtils.isEmpty((String)recordId) || "null".equals(recordId)) {
            recordId = this.hrempService.saveTemplateFile(empId);
        }
        model.addAttribute("recordId", (Object)recordId);
        return "doc/iweboffice/ExcelPage";
    }

    @RequestMapping(value={"/toAddPage"})
    public String toAddPage(HttpServletRequest request, Model model, Long msgid) {
        BasMessage msg;
        LoginUser user = this.getLoginUser(request);
        Long empId = user.getHrEmp().getEmpId();
        if (StringUtils.isNotBlank((String)request.getParameter("id"))) {
            empId = Long.parseLong(request.getParameter("id"));
        }
        model.addAttribute("isLayer", (Object)request.getParameter("isLayer"));
        model.addAttribute("empId", (Object)empId);
        HrEmp emp = this.hrempService.findEmpByempId(empId);
        if (msgid != null && (msg = this.basmessageService.findBasMessage(msgid)) != null) {
            model.addAttribute("empId", (Object)msg.getBusiMainId());
            model.addAttribute("msg", (Object)1);
            emp = this.hrempService.findEmpByempId(Long.parseLong(msg.getBusiMainId()));
        }
        model.addAttribute("emp", (Object)emp);
        if (emp.getWorkflowStatus() == null || emp.getWorkflowStatus().toString().indexOf("1") != -1) {
            model.addAttribute("edit", (Object)1);
        }
        if (emp.getWorkflowStatus() != null && emp.getWorkflowStatus().compareTo(21L) == 0) {
            model.addAttribute("edit", (Object)21);
        }
        return "business/hr/HrEmpAdd";
    }

    @RequestMapping(value={"/reportEmp"})
    @ResponseBody
    public JsonMsg reportEmp(HttpServletRequest request, Long empId) throws GEPSBisException, DocumentException {
        HrEmp entity = this.hrempService.findEmpByempId(empId);
        if (entity.getProcessinstid() == null) {
            Long processinstid = this.flowUtilService.createAndStartProcess(this.getLoginUser(request).getAccountid(), "HrEmp", entity.getEmpId(), null, request.getParameter("app"));
            entity = this.hrempService.findEmpByempId(empId);
            entity.setProcessinstid(processinstid);
        }
        this.flowUtilService.excuteFlowDefault(entity.getProcessinstid(), "HrEmp", entity.getEmpId(), entity.getEmpName());
        return new JsonMsg(true, "\u63d0\u4ea4\u6210\u529f");
    }

    @RequestMapping(value={"/findEmpByAccountIds"})
    @ResponseBody
    public List<Map<String, Object>> findEmpByAccountIds(String accountIds) {
        return this.hrempService.findEmpByAccountIds(accountIds);
    }
}

